/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.metrics;

import com.google.common.collect.ImmutableSet;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowInstanceMetrics {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceMetrics.class);
    private static final Set<String> workflowInstanceStates = ImmutableSet.of((Object)"submit", (Object)"timeout", (Object)"finish", (Object)"failover", (Object)"success", (Object)"fail", (Object[])new String[]{"stop"});
    private static final Timer commandQueryTimer;
    private static final Timer workflowInstanceGenerateTimer;

    public static void recordCommandQueryTime(long milliseconds) {
        commandQueryTimer.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static void recordWorkflowInstanceGenerateTime(long milliseconds) {
        workflowInstanceGenerateTimer.record(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static synchronized void registerWorkflowInstanceRunningGauge(Supplier<Number> function) {
        Gauge.builder((String)"ds.workflow.instance.running", function).description("The current running workflow instance count").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static synchronized void registerWorkflowInstanceResubmitGauge(Supplier<Number> function) {
        Gauge.builder((String)"ds.workflow.instance.resubmit", function).description("The current workflow instance need to resubmit count").register((MeterRegistry)Metrics.globalRegistry);
    }

    public static void incWorkflowInstanceByStateAndWorkflowDefinitionCode(String state, String workflowDefinitionCode) {
        Metrics.globalRegistry.counter("ds.workflow.instance.count", new String[]{"state", state, "workflow.definition.code", workflowDefinitionCode}).increment();
    }

    public static void cleanUpWorkflowInstanceCountMetricsByDefinitionCode(Long workflowDefinitionCode) {
        for (String state : workflowInstanceStates) {
            Counter counter = Metrics.globalRegistry.counter("ds.workflow.instance.count", new String[]{"state", state, "workflow.definition.code", String.valueOf(workflowDefinitionCode)});
            Metrics.globalRegistry.remove((Meter)counter);
        }
    }

    @Generated
    private WorkflowInstanceMetrics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (String state : workflowInstanceStates) {
            Counter.builder((String)"ds.workflow.instance.count").tags(new String[]{"state", state, "workflow.definition.code", "dummy"}).description(String.format("workflow instance total count by state and definition code", new Object[0])).register((MeterRegistry)Metrics.globalRegistry);
        }
        commandQueryTimer = Timer.builder((String)"ds.workflow.command.query.duration").description("Command query duration").register((MeterRegistry)Metrics.globalRegistry);
        workflowInstanceGenerateTimer = Timer.builder((String)"ds.workflow.instance.generate.duration").description("workflow instance generated duration").register((MeterRegistry)Metrics.globalRegistry);
    }
}

