/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.redis.RedisManager;
import com.azure.resourcemanager.redis.fluent.RedisClient;
import com.azure.resourcemanager.redis.fluent.RedisManagementClient;
import com.azure.resourcemanager.redis.fluent.models.OperationInner;
import com.azure.resourcemanager.redis.fluent.models.RedisResourceInner;
import com.azure.resourcemanager.redis.implementation.RedisCacheImpl;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.resourcemanager.redis.models.RedisCaches;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;

public class RedisCachesImpl
extends TopLevelModifiableResourcesImpl<RedisCache, RedisCacheImpl, RedisResourceInner, RedisClient, RedisManager>
implements RedisCaches {
    public RedisCachesImpl(RedisManager redisManager) {
        super((InnerSupportsListing)((RedisManagementClient)redisManager.serviceClient()).getRedis(), (Manager)redisManager);
    }

    public RedisCacheImpl define(String name) {
        return this.wrapModel(name);
    }

    protected RedisCacheImpl wrapModel(String name) {
        return new RedisCacheImpl(name, new RedisResourceInner(), (RedisManager)this.manager());
    }

    protected RedisCacheImpl wrapModel(RedisResourceInner redisResourceInner) {
        if (redisResourceInner == null) {
            return null;
        }
        return new RedisCacheImpl(redisResourceInner.name(), redisResourceInner, (RedisManager)this.manager());
    }

    @Override
    public PagedIterable<OperationInner> listOperations() {
        return new PagedIterable(this.listOperationsAsync());
    }

    @Override
    public PagedFlux<OperationInner> listOperationsAsync() {
        return ((RedisManagementClient)((RedisManager)this.manager()).serviceClient()).getOperations().listAsync();
    }
}

