/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.resourcemanager.compute.models.DedicatedHostInstanceView;
import com.azure.resourcemanager.compute.models.DedicatedHostLicenseTypes;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class DedicatedHostProperties {
    @JsonProperty(value="platformFaultDomain")
    private Integer platformFaultDomain;
    @JsonProperty(value="autoReplaceOnFailure")
    private Boolean autoReplaceOnFailure;
    @JsonProperty(value="hostId", access=JsonProperty.Access.WRITE_ONLY)
    private String hostId;
    @JsonProperty(value="virtualMachines", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceReadOnly> virtualMachines;
    @JsonProperty(value="licenseType")
    private DedicatedHostLicenseTypes licenseType;
    @JsonProperty(value="provisioningTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime provisioningTime;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private DedicatedHostInstanceView instanceView;
    @JsonProperty(value="timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public DedicatedHostProperties withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public Boolean autoReplaceOnFailure() {
        return this.autoReplaceOnFailure;
    }

    public DedicatedHostProperties withAutoReplaceOnFailure(Boolean autoReplaceOnFailure) {
        this.autoReplaceOnFailure = autoReplaceOnFailure;
        return this;
    }

    public String hostId() {
        return this.hostId;
    }

    public List<SubResourceReadOnly> virtualMachines() {
        return this.virtualMachines;
    }

    public DedicatedHostLicenseTypes licenseType() {
        return this.licenseType;
    }

    public DedicatedHostProperties withLicenseType(DedicatedHostLicenseTypes licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public OffsetDateTime provisioningTime() {
        return this.provisioningTime;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public DedicatedHostInstanceView instanceView() {
        return this.instanceView;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.virtualMachines() != null) {
            this.virtualMachines().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

