/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.util;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.propagation.Format;
import java.util.concurrent.Callable;

public final class GlobalTracer
implements Tracer {
    private static final GlobalTracer INSTANCE = new GlobalTracer();
    private static volatile Tracer tracer = NoopTracerFactory.create();
    private static volatile boolean isRegistered = false;

    private GlobalTracer() {
    }

    public static Tracer get() {
        return INSTANCE;
    }

    public static boolean isRegistered() {
        return isRegistered;
    }

    public static synchronized boolean registerIfAbsent(Callable<Tracer> provider) {
        GlobalTracer.requireNonNull(provider, "Cannot register GlobalTracer from provider <null>.");
        if (!GlobalTracer.isRegistered()) {
            try {
                Tracer suppliedTracer = GlobalTracer.requireNonNull(provider.call(), "Cannot register GlobalTracer <null>.");
                if (!(suppliedTracer instanceof GlobalTracer)) {
                    tracer = suppliedTracer;
                    isRegistered = true;
                    return true;
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Exception obtaining tracer from provider: " + ex.getMessage(), ex);
            }
        }
        return false;
    }

    public static synchronized boolean registerIfAbsent(final Tracer tracer) {
        GlobalTracer.requireNonNull(tracer, "Cannot register GlobalTracer. Tracer is null");
        return GlobalTracer.registerIfAbsent(new Callable<Tracer>(){

            @Override
            public Tracer call() {
                return tracer;
            }
        });
    }

    @Deprecated
    public static void register(Tracer tracer) {
        if (!(GlobalTracer.registerIfAbsent(GlobalTracer.provide(tracer)) || tracer.equals(GlobalTracer.tracer) || tracer instanceof GlobalTracer)) {
            throw new IllegalStateException("There is already a current global Tracer registered.");
        }
    }

    public ScopeManager scopeManager() {
        return tracer.scopeManager();
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return tracer.buildSpan(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        tracer.inject(spanContext, format, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        return tracer.extract(format, carrier);
    }

    public Span activeSpan() {
        return tracer.activeSpan();
    }

    public Scope activateSpan(Span span) {
        return tracer.activateSpan(span);
    }

    public void close() {
        tracer.close();
    }

    public String toString() {
        return GlobalTracer.class.getSimpleName() + '{' + tracer + '}';
    }

    private static Callable<Tracer> provide(final Tracer tracer) {
        return new Callable<Tracer>(){

            @Override
            public Tracer call() {
                return tracer;
            }
        };
    }

    private static <T> T requireNonNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }
}

