/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.service;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.alert.service.AlertHAServer;
import org.apache.dolphinscheduler.alert.service.EventFetcher;
import org.apache.dolphinscheduler.alert.service.EventPendingQueue;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventFetcher<T>
extends BaseDaemonThread
implements EventFetcher<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEventFetcher.class);
    protected static final int FETCH_SIZE = 100;
    protected static final long FETCH_INTERVAL = 5000L;
    protected final AlertHAServer alertHAServer;
    private final EventPendingQueue<T> eventPendingQueue;
    private final AtomicBoolean runningFlag = new AtomicBoolean(false);
    private Integer eventOffset;

    protected AbstractEventFetcher(String fetcherName, AlertHAServer alertHAServer, EventPendingQueue<T> eventPendingQueue) {
        super(fetcherName);
        this.alertHAServer = alertHAServer;
        this.eventPendingQueue = eventPendingQueue;
        this.eventOffset = -1;
    }

    @Override
    public synchronized void start() {
        if (!this.runningFlag.compareAndSet(false, true)) {
            throw new IllegalArgumentException("AlertEventFetcher is already started");
        }
        log.info("AlertEventFetcher starting...");
        super.start();
        log.info("AlertEventFetcher started...");
    }

    public void run() {
        while (this.runningFlag.get()) {
            try {
                if (!this.alertHAServer.isActive()) {
                    log.debug("The current node is not active, will not loop Alert");
                    Thread.sleep(5000L);
                    continue;
                }
                List pendingEvents = this.fetchPendingEvent(this.eventOffset);
                if (CollectionUtils.isEmpty((Collection)pendingEvents)) {
                    log.debug("No pending events found");
                    Thread.sleep(5000L);
                    continue;
                }
                for (Object alert : pendingEvents) {
                    this.eventPendingQueue.put(alert);
                }
                this.eventOffset = Math.max(this.eventOffset, pendingEvents.stream().map(this::getEventOffset).max(Integer::compareTo).get());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                log.error("AlertEventFetcher error", (Throwable)ex);
            }
        }
    }

    protected abstract int getEventOffset(T var1);

    @Override
    public void shutdown() {
        if (!this.runningFlag.compareAndSet(true, false)) {
            log.warn("The AlertEventFetcher is not started");
        }
    }
}

