/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc;

import org.apache.dolphinscheduler.plugin.registry.jdbc.KeyUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.JdbcRegistryDataChangeListener;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;

public class JdbcRegistryDataChangeListenerAdapter
implements JdbcRegistryDataChangeListener {
    private final String watchedPath;
    private final SubscribeListener listener;

    public JdbcRegistryDataChangeListenerAdapter(String watchedPath, SubscribeListener listener) {
        this.watchedPath = watchedPath;
        this.listener = listener;
    }

    @Override
    public void onJdbcRegistryDataChanged(String eventPath, String value) {
        if (!this.isPathMatch(this.watchedPath, eventPath, this.listener.getSubscribeScope())) {
            return;
        }
        Event event = Event.builder().watchedPath(this.watchedPath).eventPath(eventPath).eventData(value).type(Event.Type.UPDATE).build();
        this.listener.notify(event);
    }

    @Override
    public void onJdbcRegistryDataDeleted(String eventPath) {
        if (!this.isPathMatch(this.watchedPath, eventPath, this.listener.getSubscribeScope())) {
            return;
        }
        Event event = Event.builder().watchedPath(this.watchedPath).eventPath(eventPath).type(Event.Type.REMOVE).build();
        this.listener.notify(event);
    }

    @Override
    public void onJdbcRegistryDataAdded(String eventPath, String value) {
        if (!this.isPathMatch(this.watchedPath, eventPath, this.listener.getSubscribeScope())) {
            return;
        }
        Event event = Event.builder().watchedPath(this.watchedPath).eventPath(eventPath).eventData(value).type(Event.Type.ADD).build();
        this.listener.notify(event);
    }

    private boolean isPathMatch(String subscribePath, String eventPath, SubscribeListener.SubscribeScope subscribeScope) {
        switch (subscribeScope) {
            case PATH_ONLY: {
                return KeyUtils.isSamePath(subscribePath, eventPath);
            }
            case CHILDREN_ONLY: {
                return KeyUtils.isParent(subscribePath, eventPath);
            }
            case ALL: {
                return KeyUtils.isParent(subscribePath, eventPath) || KeyUtils.isSamePath(subscribePath, eventPath);
            }
        }
        throw new IllegalArgumentException("Invalid subscribe scope " + subscribeScope);
    }
}

