/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.common.enums.ContextType;
import org.apache.dolphinscheduler.dao.entity.AbstractTaskInstanceContext;
import org.apache.dolphinscheduler.dao.entity.DependentResultTaskInstanceContext;
import org.apache.dolphinscheduler.dao.entity.TaskInstanceContext;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceContextMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceContextDao;
import org.springframework.stereotype.Repository;

@Repository
public class TaskInstanceContextDaoImpl
extends BaseDao<TaskInstanceContext, TaskInstanceContextMapper>
implements TaskInstanceContextDao {
    public TaskInstanceContextDaoImpl(TaskInstanceContextMapper taskInstanceContextMapper) {
        super(taskInstanceContextMapper);
    }

    @Override
    public List<TaskInstanceContext> queryListByTaskInstanceIdAndContextType(Integer taskInstanceId, ContextType contextType) {
        if (taskInstanceId == null) {
            return Collections.emptyList();
        }
        return ((TaskInstanceContextMapper)this.mybatisMapper).queryListByTaskInstanceIdAndContextType(taskInstanceId, contextType);
    }

    @Override
    public int deleteByTaskInstanceIdAndContextType(Integer taskInstanceId, ContextType contextType) {
        if (taskInstanceId == null) {
            throw new IllegalArgumentException("taskInstanceId cannot be null");
        }
        return ((TaskInstanceContextMapper)this.mybatisMapper).deleteByTaskInstanceIdAndContextType(taskInstanceId, contextType);
    }

    @Override
    public int upsertTaskInstanceContext(TaskInstanceContext taskInstanceContext) {
        if (taskInstanceContext == null) {
            return 0;
        }
        TaskInstanceContext dbTaskInstanceContext = ((TaskInstanceContextMapper)this.mybatisMapper).queryListByTaskInstanceIdAndContextType(taskInstanceContext.getTaskInstanceId(), taskInstanceContext.getContextType()).stream().findFirst().orElse(null);
        if (dbTaskInstanceContext == null) {
            return ((TaskInstanceContextMapper)this.mybatisMapper).insert(taskInstanceContext);
        }
        List<AbstractTaskInstanceContext> dbDependentResultTaskInstanceContextList = dbTaskInstanceContext.getTaskInstanceContext();
        dbDependentResultTaskInstanceContextList.addAll(taskInstanceContext.getTaskInstanceContext());
        List deduplicatedDependentResultTaskInstanceContextList = dbDependentResultTaskInstanceContextList.stream().map(DependentResultTaskInstanceContext.class::cast).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DependentResultTaskInstanceContext>(Comparator.comparing(o -> o.getProjectCode() + "_" + o.getWorkflowDefinitionCode() + "_" + o.getTaskDefinitionCode() + "_" + o.getDateCycle()))), ArrayList::new));
        taskInstanceContext.setTaskInstanceContext(deduplicatedDependentResultTaskInstanceContextList);
        return ((TaskInstanceContextMapper)this.mybatisMapper).updateById(taskInstanceContext);
    }

    @Override
    public List<TaskInstanceContext> batchQueryByTaskInstanceIdsAndContextType(List<Integer> taskInstanceIds, ContextType contextType) {
        if (CollectionUtils.isEmpty(taskInstanceIds)) {
            return Collections.emptyList();
        }
        return ((TaskInstanceContextMapper)this.mybatisMapper).batchQueryByTaskInstanceIdsAndContextType(taskInstanceIds, contextType);
    }
}

