/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.StaticEncryptionMaterialsProvider;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class AsymmetricKeyEncryptionClientDemo {
    private static final String pubKeyPath = "pub.key";
    private static final String priKeyPath = "pri.key";
    private static final SecureRandom srand = new SecureRandom();
    private static String bucketName = "mybucket-12500000000";
    private static String key = "testKMS/asy.txt";
    private static File localFile = new File("len1m.txt");
    private static COSClient cosClient = AsymmetricKeyEncryptionClientDemo.createCosClient();

    public static void main(String[] args) throws Exception {
        AsymmetricKeyEncryptionClientDemo.putObjectDemo();
        AsymmetricKeyEncryptionClientDemo.getObjectDemo();
        cosClient.shutdown();
    }

    private static COSClient createCosClient() {
        return AsymmetricKeyEncryptionClientDemo.createCosClient("ap-guangzhou");
    }

    private static COSClient createCosClient(String region) {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDxxxxxxxxxxxxxxxxxxxxxxxxxxx", "yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy");
        ClientConfig clientConfig = new ClientConfig(new Region(region));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        KeyPair asymKeyPair = null;
        try {
            asymKeyPair = AsymmetricKeyEncryptionClientDemo.loadAsymKeyPair();
        }
        catch (Exception e) {
            throw new CosClientException(e);
        }
        EncryptionMaterials encryptionMaterials = new EncryptionMaterials(asymKeyPair);
        CryptoConfiguration cryptoConf = new CryptoConfiguration(CryptoMode.AesCtrEncryption).withStorageMode(CryptoStorageMode.ObjectMetadata);
        COSEncryptionClient cosEncryptionClient = new COSEncryptionClient(new COSStaticCredentialsProvider(cred), new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConf);
        return cosEncryptionClient;
    }

    private static void buildAndSaveAsymKeyPair() throws IOException, NoSuchAlgorithmException {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
        keyGenerator.initialize(1024, srand);
        KeyPair keyPair = keyGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        FileOutputStream fos = new FileOutputStream(pubKeyPath);
        fos.write(x509EncodedKeySpec.getEncoded());
        fos.close();
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        fos = new FileOutputStream(priKeyPath);
        fos.write(pkcs8EncodedKeySpec.getEncoded());
        fos.close();
    }

    private static KeyPair loadAsymKeyPair() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        File filePublicKey = new File(pubKeyPath);
        FileInputStream fis = new FileInputStream(filePublicKey);
        byte[] encodedPublicKey = new byte[(int)filePublicKey.length()];
        fis.read(encodedPublicKey);
        fis.close();
        File filePrivateKey = new File(priKeyPath);
        fis = new FileInputStream(filePrivateKey);
        byte[] encodedPrivateKey = new byte[(int)filePrivateKey.length()];
        fis.read(encodedPrivateKey);
        fis.close();
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedPublicKey);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedPrivateKey);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return new KeyPair(publicKey, privateKey);
    }

    private static void getObjectDemo() {
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        File downloadFile = new File("downAsy.txt");
        ObjectMetadata objectMetadata = cosClient.getObject(getObjectRequest, downloadFile);
        System.out.println(objectMetadata.getRequestId());
    }

    private static void putObjectDemo() {
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        System.out.println(putObjectResult.getRequestId());
    }

    private static void deleteObjectDemo() {
        cosClient.deleteObject(bucketName, key);
    }
}

