/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.job.TransTpl;
import com.qcloud.cos.model.ciModel.job.VideoTargetRec;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobResponseV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaJobsRequestV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaTemplateRequestV2;
import com.qcloud.cos.model.ciModel.job.v2.MediaTemplateResponseV2;
import com.qcloud.cos.model.ciModel.template.MediaListTemplateResponse;
import com.qcloud.cos.model.ciModel.template.MediaTemplateObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.utils.CIJackson;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class VideoTargetRecJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        VideoTargetRecJobDemo.describeMediaTemplates(client);
    }

    public static void createMediaJobs(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setTag("VideoTargetRec");
        request.getInput().setObject("1.mp4");
        MediaJobOperation operation = request.getOperation();
        VideoTargetRec videoTargetRec = operation.getVideoTargetRec();
        videoTargetRec.setBody("true");
        videoTargetRec.setPet("true");
        videoTargetRec.setCar("true");
        videoTargetRec.setFace("true");
        MediaJobResponseV2 response = client.createMediaJobsV2(request);
        System.out.println(response.getJobsDetail().getJobId());
    }

    public static void describeMediaJob(COSClient client) {
        MediaJobsRequestV2 request = new MediaJobsRequestV2();
        request.setBucketName("demo-1234567890");
        request.setJobId("a794b193e4fad11ef8a36bfd795e*****");
        MediaJobResponseV2 response = client.describeMediaJobV2(request);
        System.out.println(CIJackson.toJsonString(response));
    }

    public static void createMediaTemplate(COSClient client) throws UnsupportedEncodingException {
        MediaTemplateRequestV2 request = new MediaTemplateRequestV2();
        request.setBucketName("demo-1234567890");
        request.setTag("VideoTargetRec");
        request.setName("mark-VideoTargetRec-175");
        VideoTargetRec videoTargetRec = new VideoTargetRec();
        videoTargetRec.setCar("false");
        videoTargetRec.setBody("false");
        videoTargetRec.setPet("false");
        videoTargetRec.setFace("true");
        videoTargetRec.setProcessType("Mosaic");
        TransTpl transTpl = new TransTpl();
        MediaContainerObject container = new MediaContainerObject();
        container.setFormat("mp4");
        transTpl.setContainer(container);
        MediaVideoObject video = new MediaVideoObject();
        video.setCodec("H.264");
        video.setCrf("23");
        transTpl.setVideo(video);
        videoTargetRec.setTransTpl(transTpl);
        request.setVideoTargetRec(videoTargetRec);
        MediaTemplateResponseV2 response = client.createMediaTemplateV2(request);
        System.out.println(CIJackson.toJsonString(response));
    }

    public static void describeMediaTemplates(COSClient client) {
        MediaTemplateRequest request = new MediaTemplateRequest();
        request.setBucketName("demo-1234567890");
        request.setTag("VideoTargetRec");
        MediaListTemplateResponse response = client.describeMediaTemplatesV2(request);
        List<MediaTemplateObject> templateList = response.getTemplateList();
        for (MediaTemplateObject mediaTemplateObject : templateList) {
            System.out.println(CIJackson.toJsonString(mediaTemplateObject));
        }
    }
}

