/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.dolphinscheduler.api.audit.OperatorLog;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.TaskExecuteType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="TASK_INSTANCE_TAG")
@RestController
@RequestMapping(value={"/projects/{projectCode}/task-instances"})
public class TaskInstanceController
extends BaseController {
    @Autowired
    private TaskInstanceService taskInstanceService;

    @Operation(summary="queryTaskListPaging", description="QUERY_TASK_INSTANCE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="workflowInstanceId", description="WORKFLOW_INSTANCE_ID", schema=@Schema(implementation=int.class, example="100")), @Parameter(name="workflowInstanceName", description="WORKFLOW_INSTANCE_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="taskName", description="TASK_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="taskCode", description="TASK_CODE", schema=@Schema(implementation=Long.class)), @Parameter(name="executorName", description="EXECUTOR_NAME", schema=@Schema(implementation=String.class)), @Parameter(name="stateType", description="EXECUTION_STATUS", schema=@Schema(implementation=TaskExecutionStatus.class)), @Parameter(name="host", description="HOST", schema=@Schema(implementation=String.class)), @Parameter(name="startDate", description="START_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="endDate", description="END_DATE", schema=@Schema(implementation=String.class)), @Parameter(name="taskExecuteType", description="TASK_EXECUTE_TYPE", schema=@Schema(implementation=TaskExecuteType.class, example="STREAM")), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_LIST_PAGING_ERROR)
    public Result queryTaskListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="workflowInstanceId", required=false, defaultValue="0") Integer workflowInstanceId, @RequestParam(value="workflowInstanceName", required=false) String workflowInstanceName, @RequestParam(value="workflowDefinitionName", required=false) String workflowDefinitionName, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="taskName", required=false) String taskName, @RequestParam(value="taskCode", required=false) Long taskCode, @RequestParam(value="executorName", required=false) String executorName, @RequestParam(value="stateType", required=false) TaskExecutionStatus stateType, @RequestParam(value="host", required=false) String host, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="taskExecuteType", required=false, defaultValue="BATCH") TaskExecuteType taskExecuteType, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        return this.taskInstanceService.queryTaskListPaging(loginUser, projectCode, workflowInstanceId, workflowInstanceName, workflowDefinitionName, taskName, taskCode, executorName, startTime, endTime, searchVal, stateType, host, taskExecuteType, pageNo, pageSize);
    }

    @Operation(summary="force-success", description="FORCE_TASK_SUCCESS")
    @Parameters(value={@Parameter(name="id", description="TASK_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="12"))})
    @PostMapping(value={"/{id}/force-success"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.FORCE_TASK_SUCCESS_ERROR)
    @OperatorLog(auditType=AuditType.TASK_INSTANCE_FORCE_SUCCESS)
    public Result<Void> forceTaskSuccess(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Schema(name="projectCode", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        this.taskInstanceService.forceTaskSuccess(loginUser, projectCode, id);
        return Result.success();
    }

    @Operation(summary="savepoint", description="TASK_SAVEPOINT")
    @Parameters(value={@Parameter(name="id", description="TASK_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="12"))})
    @PostMapping(value={"/{id}/savepoint"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.TASK_SAVEPOINT_ERROR)
    public Result<Object> taskSavePoint(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        return this.taskInstanceService.taskSavePoint(loginUser, projectCode, id);
    }

    @Operation(summary="stop", description="TASK_INSTANCE_STOP")
    @Parameters(value={@Parameter(name="id", description="TASK_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="12"))})
    @PostMapping(value={"/{id}/stop"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.TASK_STOP_ERROR)
    public Result<Object> stopTask(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        return this.taskInstanceService.stopTask(loginUser, projectCode, id);
    }
}

