/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.security.impl.oidc;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import lombok.NonNull;
import org.apache.dolphinscheduler.api.configuration.ApiConfig;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.security.impl.AbstractSsoAuthenticator;
import org.apache.dolphinscheduler.api.security.impl.oidc.OidcConfigProperties;
import org.apache.dolphinscheduler.api.security.impl.oidc.OidcProviderConfig;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.utils.RegexUtils;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component(value="oidcAuthenticator")
public class OidcAuthenticator
extends AbstractSsoAuthenticator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OidcAuthenticator.class);
    private final OidcConfigProperties oidcConfig;
    private final UsersService usersService;
    private final ApiConfig apiConfig;
    private static final String EMAIL_ATTRIBUTE = "email";
    private static final String STATE_DELIMITER = ":";
    private static final int STATE_PARTS_COUNT = 2;
    private static final int PROVIDER_ID_INDEX = 0;
    private final Map<String, OIDCProviderMetadata> providerMetadataCache = new ConcurrentHashMap<String, OIDCProviderMetadata>();

    public OidcAuthenticator(OidcConfigProperties oidcConfig, UsersService usersService, ApiConfig apiConfig) {
        this.oidcConfig = oidcConfig;
        this.usersService = usersService;
        this.apiConfig = apiConfig;
    }

    @Override
    public User login(@NonNull String state, String code) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        try {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (servletRequestAttributes == null) {
                log.error("ServletRequestAttributes is null, cannot get session");
                return null;
            }
            HttpServletRequest request = servletRequestAttributes.getRequest();
            String originalState = (String)request.getSession().getAttribute("sso.login.user.state");
            request.getSession().removeAttribute("sso.login.user.state");
            if (originalState == null || !MessageDigest.isEqual(originalState.getBytes(), state.getBytes())) {
                log.error("State validation failed. Expected: {}, Actual: {}", (Object)originalState, (Object)RegexUtils.escapeNRT(state));
                return null;
            }
            String[] stateParts = state.split(STATE_DELIMITER, 2);
            if (stateParts.length != 2) {
                log.error("Invalid state format: {}", (Object)RegexUtils.escapeNRT(state));
                return null;
            }
            String providerId = stateParts[0];
            OidcProviderConfig providerConfig = this.oidcConfig.getProviders().get(providerId);
            if (providerConfig == null) {
                log.error("Provider not found: {}", (Object)RegexUtils.escapeNRT(providerId));
                return null;
            }
            OIDCProviderMetadata providerMetadata = this.getProviderMetadata(providerId, providerConfig);
            OIDCTokens tokens = this.exchangeCodeForTokens(providerMetadata, providerConfig, code, providerId);
            IDTokenClaimsSet idTokenClaims = this.validateIdToken(providerMetadata, providerConfig, tokens.getIDToken());
            UserInfo userInfo = this.getUserInfo(providerMetadata, tokens.getAccessToken());
            String username = this.extractUsername(providerConfig, idTokenClaims, userInfo);
            String email = this.extractEmail(idTokenClaims, userInfo);
            List<String> groups = this.extractGroups(providerConfig, idTokenClaims, userInfo);
            User user = this.usersService.getUserByUserName(username);
            UserType userType = this.determineUserType(groups);
            if (user == null) {
                if (this.oidcConfig.getUser().isAutoCreate()) {
                    user = this.usersService.createUser(userType, username, email);
                }
            } else if (user.getUserType() != userType) {
                user.setUserType(userType);
                user = this.usersService.updateUser(user);
            }
            return user;
        }
        catch (Exception e) {
            log.error("An error occurred during OIDC authentication:", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getSignInUrl(String state) {
        try {
            String[] stateParts = state.split(STATE_DELIMITER, 2);
            String providerId = stateParts[0];
            OidcProviderConfig providerConfig = this.oidcConfig.getProviders().get(providerId);
            if (providerConfig == null) {
                log.error("Provider not found: {}", (Object)RegexUtils.escapeNRT(providerId));
                return null;
            }
            OIDCProviderMetadata providerMetadata = this.getProviderMetadata(providerId, providerConfig);
            ClientID clientID = new ClientID(providerConfig.getClientId());
            URI redirectURI = new URI(this.getCallbackUrl(providerId));
            Scope scope = this.parseScope(providerConfig.getScope());
            State nimbusState = new State(state);
            Nonce nonce = new Nonce();
            AuthenticationRequest authRequest = new AuthenticationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), scope, clientID, redirectURI).state(nimbusState).nonce(nonce).endpointURI(providerMetadata.getAuthorizationEndpointURI()).build();
            return authRequest.toURI().toString();
        }
        catch (Exception e) {
            log.error("Error generating OIDC sign-in URL:", (Throwable)e);
            return null;
        }
    }

    private String getCallbackUrl(String providerId) {
        return String.format("%s/login/oauth2/code/%s", this.apiConfig.getBaseUrl(), providerId);
    }

    private OIDCProviderMetadata getProviderMetadata(String providerId, OidcProviderConfig providerConfig) throws Exception {
        if (this.providerMetadataCache.containsKey(providerId)) {
            return this.providerMetadataCache.get(providerId);
        }
        URI wellKnownURI = new URI(providerConfig.getIssuerUri() + "/.well-known/openid-configuration");
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, wellKnownURI.toURL());
        HTTPResponse httpResponse = httpRequest.send();
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)httpResponse.getContent());
        this.providerMetadataCache.put(providerId, metadata);
        return metadata;
    }

    private OIDCTokens exchangeCodeForTokens(OIDCProviderMetadata providerMetadata, OidcProviderConfig providerConfig, String code, String providerId) {
        try {
            TokenResponse tokenResponse;
            ClientID clientID = new ClientID(providerConfig.getClientId());
            Secret clientSecret = new Secret(providerConfig.getClientSecret());
            URI redirectURI = new URI(this.getCallbackUrl(providerId));
            AuthorizationCode authorizationCode = new AuthorizationCode(code);
            AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(authorizationCode, redirectURI);
            Object clientAuth = "client_secret_post".equalsIgnoreCase(providerConfig.getClientAuthenticationMethod()) ? new ClientSecretPost(clientID, clientSecret) : new ClientSecretBasic(clientID, clientSecret);
            TokenRequest tokenRequest = new TokenRequest(providerMetadata.getTokenEndpointURI(), (ClientAuthentication)clientAuth, (AuthorizationGrant)codeGrant);
            try {
                tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)tokenRequest.toHTTPRequest().send());
            }
            catch (Exception e) {
                log.error("Failed to send token request", (Throwable)e);
                throw new ServiceException(Status.OIDC_TOKEN_EXCHANGE_FAILED);
            }
            if (!tokenResponse.indicatesSuccess()) {
                log.error("Token request failed: {}", (Object)tokenResponse.toErrorResponse().getErrorObject());
                throw new ServiceException(Status.OIDC_TOKEN_EXCHANGE_FAILED);
            }
            return ((OIDCTokenResponse)tokenResponse).getOIDCTokens();
        }
        catch (URISyntaxException e) {
            log.error("Invalid redirect URI configured for OIDC provider: {}", (Object)providerId, (Object)e);
            throw new ServiceException("Failed to construct OIDC redirect URI", e);
        }
    }

    private IDTokenClaimsSet validateIdToken(OIDCProviderMetadata providerMetadata, OidcProviderConfig providerConfig, JWT idToken) {
        JWTClaimsSet claimsSet;
        try {
            claimsSet = idToken.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new ServiceException("Error parsing ID token claims", e);
        }
        String issuer = claimsSet.getIssuer();
        if (issuer == null || !issuer.equals(providerMetadata.getIssuer().getValue())) {
            throw new ServiceException(Status.OIDC_ID_TOKEN_ISSUER_INVALID);
        }
        List audiences = claimsSet.getAudience();
        if (audiences == null || !audiences.contains(providerConfig.getClientId())) {
            throw new ServiceException(Status.OIDC_ID_TOKEN_AUDIENCE_INVALID);
        }
        Date expirationTime = claimsSet.getExpirationTime();
        if (expirationTime == null || expirationTime.before(new Date())) {
            throw new ServiceException(Status.OIDC_ID_TOKEN_EXPIRED);
        }
        try {
            return new IDTokenClaimsSet(claimsSet);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            log.error("Failed to parse ID token claims, required claims may be missing.", (Throwable)e);
            throw new ServiceException("ID token is missing required claims", (Exception)((Object)e));
        }
    }

    private UserInfo getUserInfo(OIDCProviderMetadata providerMetadata, AccessToken accessToken) throws Exception {
        UserInfoRequest userInfoRequest = new UserInfoRequest(providerMetadata.getUserInfoEndpointURI(), accessToken);
        HTTPResponse httpResponse = userInfoRequest.toHTTPRequest().send();
        UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
        if (!userInfoResponse.indicatesSuccess()) {
            log.error("User info request failed: {}", (Object)userInfoResponse.toErrorResponse().getErrorObject());
            return null;
        }
        return userInfoResponse.toSuccessResponse().getUserInfo();
    }

    private String extractUsername(OidcProviderConfig providerConfig, IDTokenClaimsSet idTokenClaims, UserInfo userInfo) {
        Object usernameFromUserInfo;
        String userNameAttribute = providerConfig.getUserNameAttribute();
        Object usernameFromIdToken = idTokenClaims.getClaim(userNameAttribute);
        if (usernameFromIdToken != null) {
            return usernameFromIdToken.toString();
        }
        if (userInfo != null && (usernameFromUserInfo = userInfo.getClaim(userNameAttribute)) != null) {
            return usernameFromUserInfo.toString();
        }
        return idTokenClaims.getSubject().getValue();
    }

    private String extractEmail(IDTokenClaimsSet idTokenClaims, UserInfo userInfo) {
        Object emailFromUserInfo;
        Object emailFromIdToken = idTokenClaims.getClaim(EMAIL_ATTRIBUTE);
        if (emailFromIdToken != null) {
            return emailFromIdToken.toString();
        }
        if (userInfo != null && (emailFromUserInfo = userInfo.getClaim(EMAIL_ATTRIBUTE)) != null) {
            return emailFromUserInfo.toString();
        }
        return null;
    }

    private List<String> extractGroups(OidcProviderConfig providerConfig, IDTokenClaimsSet idTokenClaims, UserInfo userInfo) {
        Object groupsFromUserInfo;
        String groupsClaim = providerConfig.getGroupsClaim();
        if (groupsClaim == null || groupsClaim.isEmpty()) {
            return Collections.emptyList();
        }
        Object groupsFromIdToken = idTokenClaims.getClaim(groupsClaim);
        if (groupsFromIdToken instanceof List) {
            List groups = (List)groupsFromIdToken;
            return groups;
        }
        if (userInfo != null && (groupsFromUserInfo = userInfo.getClaim(groupsClaim)) instanceof List) {
            List groups = (List)groupsFromUserInfo;
            return groups;
        }
        return Collections.emptyList();
    }

    private UserType determineUserType(List<String> groups) {
        List<String> adminGroups = this.oidcConfig.getUser().getAdminGroupMapping();
        if (adminGroups != null && !adminGroups.isEmpty() && groups != null) {
            for (String group : groups) {
                if (!adminGroups.contains(group)) continue;
                return UserType.ADMIN_USER;
            }
        }
        return UserType.GENERAL_USER;
    }

    private Scope parseScope(String scopeString) {
        if (scopeString == null || scopeString.isEmpty()) {
            return new Scope(new String[]{"openid", "profile", EMAIL_ATTRIBUTE});
        }
        return Scope.parse((String)scopeString);
    }
}

