/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.UpdateFileFromContentDto;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class UpdateFileFromContentDtoValidator
extends AbstractResourceValidator<UpdateFileFromContentDto> {
    public UpdateFileFromContentDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(UpdateFileFromContentDto updateFileFromContentDto) {
        String fileAbsolutePath = updateFileFromContentDto.getFileAbsolutePath();
        User loginUser = updateFileFromContentDto.getLoginUser();
        String fileContent = updateFileFromContentDto.getFileContent();
        this.exceptionResourceAbsolutePathInvalidated(fileAbsolutePath);
        this.exceptionResourceNotExists(fileAbsolutePath);
        this.exceptionResourceIsNotFile(fileAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, fileAbsolutePath);
        this.exceptionFileContentCannotFetch(fileAbsolutePath);
        this.exceptionFileContentInvalidated(fileContent);
    }
}

