/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.SyncFullSchemaPropertiesInner;
import com.azure.resourcemanager.sql.fluent.models.SyncGroupInner;
import com.azure.resourcemanager.sql.fluent.models.SyncGroupLogPropertiesInner;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlSyncFullSchemaPropertyImpl;
import com.azure.resourcemanager.sql.implementation.SqlSyncGroupLogPropertyImpl;
import com.azure.resourcemanager.sql.implementation.SqlSyncMemberOperationsImpl;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlSyncFullSchemaProperty;
import com.azure.resourcemanager.sql.models.SqlSyncGroup;
import com.azure.resourcemanager.sql.models.SqlSyncGroupLogProperty;
import com.azure.resourcemanager.sql.models.SqlSyncGroupOperations;
import com.azure.resourcemanager.sql.models.SqlSyncMemberOperations;
import com.azure.resourcemanager.sql.models.SyncConflictResolutionPolicy;
import com.azure.resourcemanager.sql.models.SyncGroupSchema;
import com.azure.resourcemanager.sql.models.SyncGroupState;
import com.azure.resourcemanager.sql.models.SyncGroupsType;
import java.time.OffsetDateTime;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlSyncGroupImpl
extends ExternalChildResourceImpl<SqlSyncGroup, SyncGroupInner, SqlDatabaseImpl, SqlDatabase>
implements SqlSyncGroup,
SqlSyncGroup.Update,
SqlSyncGroupOperations.SqlSyncGroupOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;
    private String sqlDatabaseName;
    private SqlSyncMemberOperations.SqlSyncMemberActionsDefinition syncMemberOps;

    SqlSyncGroupImpl(String name, SqlDatabaseImpl parent, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.sqlServerName();
        this.sqlDatabaseName = parent.name();
    }

    SqlSyncGroupImpl(String resourceGroupName, String sqlServerName, String sqlDatabaseName, String name, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        this.sqlDatabaseName = sqlDatabaseName;
    }

    SqlSyncGroupImpl(String name, SyncGroupInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        if (innerObject != null && innerObject.id() != null) {
            try {
                ResourceId resourceId = ResourceId.fromString((String)innerObject.id());
                this.resourceGroupName = resourceId.resourceGroupName();
                this.sqlServerName = resourceId.parent().parent().name();
                this.sqlDatabaseName = resourceId.parent().name();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String id() {
        return ((SyncGroupInner)((Object)this.innerModel())).id();
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String sqlDatabaseName() {
        return this.sqlDatabaseName;
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)((SyncGroupInner)((Object)this.innerModel())).id());
    }

    @Override
    public int interval() {
        return ((SyncGroupInner)((Object)this.innerModel())).interval();
    }

    @Override
    public OffsetDateTime lastSyncTime() {
        return ((SyncGroupInner)((Object)this.innerModel())).lastSyncTime();
    }

    @Override
    public SyncConflictResolutionPolicy conflictResolutionPolicy() {
        return ((SyncGroupInner)((Object)this.innerModel())).conflictResolutionPolicy();
    }

    @Override
    public String syncDatabaseId() {
        return ((SyncGroupInner)((Object)this.innerModel())).syncDatabaseId();
    }

    @Override
    public String databaseUserName() {
        return ((SyncGroupInner)((Object)this.innerModel())).hubDatabaseUsername();
    }

    @Override
    public SyncGroupState syncState() {
        return ((SyncGroupInner)((Object)this.innerModel())).syncState();
    }

    @Override
    public SyncGroupSchema schema() {
        return ((SyncGroupInner)((Object)this.innerModel())).schema();
    }

    @Override
    public void refreshHubSchema() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().refreshHubSchema(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Mono<Void> refreshHubSchemaAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().refreshHubSchemaAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public PagedIterable<SqlSyncFullSchemaProperty> listHubSchemas() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listHubSchemas(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()), inner -> new SqlSyncFullSchemaPropertyImpl((SyncFullSchemaPropertiesInner)inner));
    }

    @Override
    public PagedFlux<SqlSyncFullSchemaProperty> listHubSchemasAsync() {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listHubSchemasAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name()), syncFullSchemaPropertiesInner -> new SqlSyncFullSchemaPropertyImpl((SyncFullSchemaPropertiesInner)syncFullSchemaPropertiesInner));
    }

    @Override
    public PagedIterable<SqlSyncGroupLogProperty> listLogs(String startTime, String endTime, String type) {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listLogs(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), startTime, endTime, SyncGroupsType.fromString(type)), inner -> new SqlSyncGroupLogPropertyImpl((SyncGroupLogPropertiesInner)inner));
    }

    @Override
    public PagedFlux<SqlSyncGroupLogProperty> listLogsAsync(String startTime, String endTime, String type) {
        return PagedConverter.mapPage(((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().listLogsAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), startTime, endTime, SyncGroupsType.fromString(type)), syncGroupLogPropertiesInner -> new SqlSyncGroupLogPropertyImpl((SyncGroupLogPropertiesInner)syncGroupLogPropertiesInner));
    }

    @Override
    public void triggerSynchronization() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().triggerSync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Mono<Void> triggerSynchronizationAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().triggerSyncAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public void cancelSynchronization() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().cancelSync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Mono<Void> cancelSynchronizationAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().cancelSyncAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public SqlSyncGroupImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlSyncGroupImpl withExistingSqlDatabase(SqlDatabase sqlDatabase) {
        this.resourceGroupName = sqlDatabase.resourceGroupName();
        this.sqlServerName = sqlDatabase.sqlServerName();
        this.sqlDatabaseName = sqlDatabase.name();
        return this;
    }

    @Override
    public SqlSyncGroupImpl withExistingDatabaseName(String databaseName) {
        this.sqlDatabaseName = databaseName;
        return this;
    }

    @Override
    public SqlSyncGroupImpl withSyncDatabaseId(String syncDatabaseId) {
        ((SyncGroupInner)((Object)this.innerModel())).withSyncDatabaseId(syncDatabaseId);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withDatabaseUserName(String userName) {
        ((SyncGroupInner)((Object)this.innerModel())).withHubDatabaseUsername(userName);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withDatabasePassword(String password) {
        ((SyncGroupInner)((Object)this.innerModel())).withHubDatabasePassword(password);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withConflictResolutionPolicyHubWins() {
        ((SyncGroupInner)((Object)this.innerModel())).withConflictResolutionPolicy(SyncConflictResolutionPolicy.HUB_WIN);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withConflictResolutionPolicyMemberWins() {
        ((SyncGroupInner)((Object)this.innerModel())).withConflictResolutionPolicy(SyncConflictResolutionPolicy.MEMBER_WIN);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withInterval(int interval) {
        ((SyncGroupInner)((Object)this.innerModel())).withInterval(interval);
        return this;
    }

    @Override
    public SqlSyncGroupImpl withSchema(SyncGroupSchema schema) {
        ((SyncGroupInner)((Object)this.innerModel())).withSchema(schema);
        return this;
    }

    public SqlSyncGroup.Update update() {
        this.setPendingOperation(ExternalChildResourceImpl.PendingOperation.ToBeUpdated);
        return this;
    }

    public Mono<SqlSyncGroup> createResourceAsync() {
        SqlSyncGroupImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name(), (SyncGroupInner)((Object)this.innerModel())).map(syncGroupInner -> {
            self.setInner(syncGroupInner);
            return self;
        });
    }

    public Mono<SqlSyncGroup> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().deleteAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    protected Mono<SyncGroupInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().getAsync(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public void delete() {
        ((SqlManagementClient)this.sqlServerManager.serviceClient()).getSyncGroups().delete(this.resourceGroupName, this.sqlServerName, this.sqlDatabaseName, this.name());
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public SqlSyncMemberOperations.SqlSyncMemberActionsDefinition syncMembers() {
        if (this.syncMemberOps == null) {
            this.syncMemberOps = new SqlSyncMemberOperationsImpl(this, this.sqlServerManager);
        }
        return this.syncMemberOps;
    }
}

