/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.fluent.models.OutboundRuleInner;
import com.azure.resourcemanager.network.implementation.LoadBalancerImpl;
import com.azure.resourcemanager.network.models.LoadBalancer;
import com.azure.resourcemanager.network.models.LoadBalancerBackend;
import com.azure.resourcemanager.network.models.LoadBalancerFrontend;
import com.azure.resourcemanager.network.models.LoadBalancerOutboundRule;
import com.azure.resourcemanager.network.models.LoadBalancerOutboundRuleProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class LoadBalancerOutboundRuleImpl
extends ChildResourceImpl<OutboundRuleInner, LoadBalancerImpl, LoadBalancer>
implements LoadBalancerOutboundRule,
LoadBalancerOutboundRule.Definition<LoadBalancerImpl>,
LoadBalancerOutboundRule.Update<LoadBalancerImpl> {
    LoadBalancerOutboundRuleImpl(OutboundRuleInner inner, LoadBalancerImpl parent) {
        super((Object)inner, (Object)parent);
    }

    @Override
    public LoadBalancerOutboundRuleProtocol protocol() {
        return ((OutboundRuleInner)((Object)this.innerModel())).protocol();
    }

    @Override
    public Map<String, LoadBalancerFrontend> frontends() {
        TreeMap<String, LoadBalancerFrontend> nameToFrontEndMap = new TreeMap<String, LoadBalancerFrontend>();
        if (((OutboundRuleInner)((Object)this.innerModel())).frontendIpConfigurations() != null && !((OutboundRuleInner)((Object)this.innerModel())).frontendIpConfigurations().isEmpty()) {
            for (SubResource frontendIpConfiguration : ((OutboundRuleInner)((Object)this.innerModel())).frontendIpConfigurations()) {
                LoadBalancerFrontend frontend = ((LoadBalancerImpl)this.parent()).frontends().get(ResourceUtils.nameFromResourceId((String)frontendIpConfiguration.id()));
                nameToFrontEndMap.put(frontend.name(), frontend);
            }
        }
        return Collections.unmodifiableMap(nameToFrontEndMap);
    }

    @Override
    public LoadBalancerBackend backend() {
        return ((LoadBalancerImpl)this.parent()).backends().get(ResourceUtils.nameFromResourceId((String)((OutboundRuleInner)((Object)this.innerModel())).backendAddressPool().id()));
    }

    @Override
    public int allocatedOutboundPorts() {
        return ((OutboundRuleInner)((Object)this.innerModel())).allocatedOutboundPorts();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((OutboundRuleInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public int idleTimeoutInMinutes() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((OutboundRuleInner)((Object)this.innerModel())).idleTimeoutInMinutes());
    }

    @Override
    public boolean tcpResetEnabled() {
        return ((OutboundRuleInner)((Object)this.innerModel())).enableTcpReset();
    }

    public String name() {
        return ((OutboundRuleInner)((Object)this.innerModel())).name();
    }

    @Override
    public LoadBalancerOutboundRuleImpl withProtocol(LoadBalancerOutboundRuleProtocol protocol) {
        ((OutboundRuleInner)((Object)this.innerModel())).withProtocol(protocol);
        return this;
    }

    public LoadBalancerOutboundRuleImpl fromBackend(String name) {
        ((LoadBalancerImpl)this.parent()).defineBackend(name).attach();
        SubResource backendRef = new SubResource().withId(((LoadBalancerImpl)this.parent()).futureResourceId() + "/backendAddressPools/" + name);
        ((OutboundRuleInner)((Object)this.innerModel())).withBackendAddressPool(backendRef);
        return this;
    }

    public LoadBalancerOutboundRuleImpl toFrontend(String name) {
        SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(name);
        if (frontendRef != null) {
            ((OutboundRuleInner)((Object)this.innerModel())).withFrontendIpConfigurations(Arrays.asList(frontendRef));
        }
        return this;
    }

    public LoadBalancerOutboundRuleImpl toFrontends(List<String> names) {
        ArrayList<SubResource> frontendRefs = new ArrayList<SubResource>();
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                SubResource frontendRef = ((LoadBalancerImpl)this.parent()).ensureFrontendRef(name);
                frontendRefs.add(frontendRef);
            }
        }
        ((OutboundRuleInner)((Object)this.innerModel())).withFrontendIpConfigurations(frontendRefs);
        return this;
    }

    public LoadBalancerOutboundRuleImpl withIdleTimeoutInMinutes(int minutes) {
        ((OutboundRuleInner)((Object)this.innerModel())).withIdleTimeoutInMinutes(minutes);
        return this;
    }

    public LoadBalancerOutboundRuleImpl withEnableTcpReset(boolean enableTcpReset) {
        ((OutboundRuleInner)((Object)this.innerModel())).withEnableTcpReset(enableTcpReset);
        return this;
    }

    public LoadBalancerImpl attach() {
        return ((LoadBalancerImpl)this.parent()).withOutboundRule(this);
    }
}

