/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.Architecture;
import com.azure.resourcemanager.containerregistry.models.OS;
import com.azure.resourcemanager.containerregistry.models.Variant;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class PlatformProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(PlatformProperties.class);
    @JsonProperty(value="os", required=true)
    private OS os;
    @JsonProperty(value="architecture")
    private Architecture architecture;
    @JsonProperty(value="variant")
    private Variant variant;

    public OS os() {
        return this.os;
    }

    public PlatformProperties withOs(OS os) {
        this.os = os;
        return this;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public PlatformProperties withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public Variant variant() {
        return this.variant;
    }

    public PlatformProperties withVariant(Variant variant) {
        this.variant = variant;
        return this;
    }

    public void validate() {
        if (this.os() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property os in model PlatformProperties"));
        }
    }
}

