/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.eventbus;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.eventbus.IEvent;

public abstract class AbstractDelayEvent
implements IEvent,
Delayed {
    private static final long DEFAULT_DELAY_TIME = 0L;
    protected long delayTime;
    protected long createTimeInNano;
    protected long expiredTimeInNano;

    public AbstractDelayEvent() {
        this(0L);
    }

    public AbstractDelayEvent(long delayTime) {
        this(delayTime, System.nanoTime());
    }

    public AbstractDelayEvent(long delayTime, long createTimeInNano) {
        this.delayTime = delayTime;
        this.createTimeInNano = createTimeInNano;
        this.expiredTimeInNano = this.delayTime * 1000000L + this.createTimeInNano;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long delay = this.createTimeInNano + this.delayTime * 1000000L - System.nanoTime();
        return unit.convert(delay, TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed other) {
        return Long.compare(this.expiredTimeInNano, ((AbstractDelayEvent)other).expiredTimeInNano);
    }

    @Generated
    private static long $default$createTimeInNano() {
        return System.nanoTime();
    }

    @Generated
    private static long $default$expiredTimeInNano() {
        return System.nanoTime();
    }

    @Generated
    protected AbstractDelayEvent(AbstractDelayEventBuilder<?, ?> b) {
        this.delayTime = ((AbstractDelayEventBuilder)b).delayTime;
        this.createTimeInNano = ((AbstractDelayEventBuilder)b).createTimeInNano$set ? ((AbstractDelayEventBuilder)b).createTimeInNano$value : AbstractDelayEvent.$default$createTimeInNano();
        this.expiredTimeInNano = ((AbstractDelayEventBuilder)b).expiredTimeInNano$set ? ((AbstractDelayEventBuilder)b).expiredTimeInNano$value : AbstractDelayEvent.$default$expiredTimeInNano();
    }

    @Generated
    public String toString() {
        return "AbstractDelayEvent(delayTime=" + this.delayTime + ", createTimeInNano=" + this.createTimeInNano + ", expiredTimeInNano=" + this.expiredTimeInNano + ")";
    }

    @Generated
    public static abstract class AbstractDelayEventBuilder<C extends AbstractDelayEvent, B extends AbstractDelayEventBuilder<C, B>> {
        @Generated
        private long delayTime;
        @Generated
        private boolean createTimeInNano$set;
        @Generated
        private long createTimeInNano$value;
        @Generated
        private boolean expiredTimeInNano$set;
        @Generated
        private long expiredTimeInNano$value;

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public B delayTime(long delayTime) {
            this.delayTime = delayTime;
            return this.self();
        }

        @Generated
        public B createTimeInNano(long createTimeInNano) {
            this.createTimeInNano$value = createTimeInNano;
            this.createTimeInNano$set = true;
            return this.self();
        }

        @Generated
        public B expiredTimeInNano(long expiredTimeInNano) {
            this.expiredTimeInNano$value = expiredTimeInNano;
            this.expiredTimeInNano$set = true;
            return this.self();
        }

        @Generated
        public String toString() {
            return "AbstractDelayEvent.AbstractDelayEventBuilder(delayTime=" + this.delayTime + ", createTimeInNano$value=" + this.createTimeInNano$value + ", expiredTimeInNano$value=" + this.expiredTimeInNano$value + ")";
        }
    }
}

