/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.plugin.task.api.shell.BaseShellInterceptor;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;

public abstract class BaseShellInterceptorBuilder<T extends BaseShellInterceptorBuilder<T, Y>, Y extends BaseShellInterceptor>
implements IShellInterceptorBuilder<T, Y> {
    protected String shellDirectory;
    protected String shellName;
    protected String runUser;
    protected Integer cpuQuota;
    protected Integer memoryQuota;
    protected List<String> systemEnvs = new ArrayList<String>();
    protected List<String> customEnvScripts = new ArrayList<String>();
    protected String k8sConfigYaml;
    protected Map<String, String> propertyMap = new HashMap<String, String>();
    protected boolean sudoEnable;
    protected List<String> scripts = new ArrayList<String>();

    protected BaseShellInterceptorBuilder() {
    }

    @Override
    public T newBuilder(T builder) {
        BaseShellInterceptorBuilder newBuilder = (BaseShellInterceptorBuilder)this.newBuilder();
        newBuilder.shellDirectory = ((BaseShellInterceptorBuilder)builder).shellDirectory;
        newBuilder.shellName = ((BaseShellInterceptorBuilder)builder).shellName;
        newBuilder.runUser = ((BaseShellInterceptorBuilder)builder).runUser;
        newBuilder.cpuQuota = ((BaseShellInterceptorBuilder)builder).cpuQuota;
        newBuilder.memoryQuota = ((BaseShellInterceptorBuilder)builder).memoryQuota;
        newBuilder.systemEnvs = ((BaseShellInterceptorBuilder)builder).systemEnvs;
        newBuilder.customEnvScripts = ((BaseShellInterceptorBuilder)builder).customEnvScripts;
        newBuilder.k8sConfigYaml = ((BaseShellInterceptorBuilder)builder).k8sConfigYaml;
        newBuilder.propertyMap = ((BaseShellInterceptorBuilder)builder).propertyMap;
        newBuilder.sudoEnable = ((BaseShellInterceptorBuilder)builder).sudoEnable;
        newBuilder.scripts = ((BaseShellInterceptorBuilder)builder).scripts;
        return (T)newBuilder;
    }

    @Override
    public T shellDirectory(String shellDirectory) {
        this.shellDirectory = shellDirectory;
        return (T)this;
    }

    @Override
    public T shellName(String shellFilename) {
        this.shellName = shellFilename;
        return (T)this;
    }

    @Override
    public T runUser(String systemUser) {
        this.runUser = systemUser;
        return (T)this;
    }

    @Override
    public T cpuQuota(Integer cpuQuota) {
        this.cpuQuota = cpuQuota;
        return (T)this;
    }

    @Override
    public T memoryQuota(Integer memoryQuota) {
        this.memoryQuota = memoryQuota;
        return (T)this;
    }

    @Override
    public T appendSystemEnv(String envFiles) {
        this.systemEnvs.add(envFiles);
        return (T)this;
    }

    @Override
    public T appendCustomEnvScript(String customEnvScript) {
        this.customEnvScripts.add(customEnvScript);
        return (T)this;
    }

    @Override
    public T k8sConfigYaml(String k8sConfigYaml) {
        this.k8sConfigYaml = k8sConfigYaml;
        return (T)this;
    }

    @Override
    public T properties(Map<String, String> propertyMap) {
        if (MapUtils.isNotEmpty(propertyMap)) {
            this.propertyMap.putAll(propertyMap);
        }
        return (T)this;
    }

    @Override
    public T sudoMode(boolean sudoEnable) {
        this.sudoEnable = sudoEnable;
        return (T)this;
    }

    @Override
    public T appendScript(String script) {
        this.scripts.add(script);
        return (T)this;
    }
}

