/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine;

import com.google.common.base.Preconditions;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.apache.dolphinscheduler.registry.api.ha.AbstractHAServer;
import org.apache.dolphinscheduler.registry.api.ha.AbstractServerStatusChangeListener;
import org.apache.dolphinscheduler.registry.api.ha.ServerStatusChangeListener;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.engine.ITaskGroupCoordinator;
import org.apache.dolphinscheduler.server.master.engine.IWorkflowSerialCoordinator;
import org.apache.dolphinscheduler.server.master.failover.IFailoverCoordinator;
import org.apache.dolphinscheduler.server.master.utils.MasterThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterCoordinator
extends AbstractHAServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterCoordinator.class);
    private final ITaskGroupCoordinator taskGroupCoordinator;
    private final IFailoverCoordinator failoverCoordinator;
    private final IWorkflowSerialCoordinator workflowSerialCoordinator;

    public MasterCoordinator(Registry registry, MasterConfig masterConfig, ITaskGroupCoordinator taskGroupCoordinator, IFailoverCoordinator failoverCoordinator, IWorkflowSerialCoordinator workflowSerialCoordinator) {
        super(registry, RegistryNodeType.MASTER_COORDINATOR.getRegistryPath(), masterConfig.getMasterAddress());
        this.taskGroupCoordinator = taskGroupCoordinator;
        this.failoverCoordinator = failoverCoordinator;
        this.workflowSerialCoordinator = workflowSerialCoordinator;
        this.addServerStatusChangeListener((ServerStatusChangeListener)new MasterCoordinatorListener(taskGroupCoordinator, failoverCoordinator, workflowSerialCoordinator));
    }

    public void start() {
        super.start();
        log.info("MasterCoordinator started...");
    }

    public void close() {
        this.taskGroupCoordinator.close();
        log.info("MasterCoordinator shutdown...");
    }

    public static class MasterCoordinatorListener
    extends AbstractServerStatusChangeListener {
        private final ITaskGroupCoordinator taskGroupCoordinator;
        private final IFailoverCoordinator failoverCoordinator;
        private final IWorkflowSerialCoordinator workflowSerialCoordinator;
        private Future<?> failoverCoordinatorFuture;

        public MasterCoordinatorListener(ITaskGroupCoordinator taskGroupCoordinator, IFailoverCoordinator failoverCoordinator, IWorkflowSerialCoordinator workflowSerialCoordinator) {
            this.taskGroupCoordinator = (ITaskGroupCoordinator)Preconditions.checkNotNull((Object)taskGroupCoordinator);
            this.failoverCoordinator = (IFailoverCoordinator)Preconditions.checkNotNull((Object)failoverCoordinator);
            this.workflowSerialCoordinator = (IWorkflowSerialCoordinator)Preconditions.checkNotNull((Object)workflowSerialCoordinator);
        }

        public void changeToActive() {
            this.taskGroupCoordinator.start();
            this.workflowSerialCoordinator.start();
            this.failoverCoordinatorFuture = MasterThreadFactory.getDefaultSchedulerThreadExecutor().scheduleWithFixedDelay(() -> {
                try {
                    this.failoverCoordinator.cleanHistoryFailoverFinishedMarks();
                }
                catch (Exception e) {
                    log.error("FailoverCoordinator cleanHistoryFailoverFinishedMarks failed", (Throwable)e);
                }
            }, 0L, 1L, TimeUnit.DAYS);
        }

        public void changeToStandBy() {
            this.taskGroupCoordinator.close();
            this.workflowSerialCoordinator.close();
            if (this.failoverCoordinatorFuture != null) {
                this.failoverCoordinatorFuture.cancel(true);
            }
        }
    }
}

