/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.runnable;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.AbstractTaskInstanceFactory;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskInstanceFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FirstRunTaskInstanceFactory
extends AbstractTaskInstanceFactory<FirstRunTaskInstanceBuilder> {
    @Autowired
    private TaskInstanceDao taskInstanceDao;

    @Override
    public FirstRunTaskInstanceBuilder builder() {
        return new FirstRunTaskInstanceBuilder(this);
    }

    @Override
    public TaskInstance createTaskInstance(FirstRunTaskInstanceBuilder builder) {
        TaskDefinition taskDefinition = (TaskDefinition)Preconditions.checkNotNull((Object)builder.taskDefinition);
        WorkflowInstance workflowInstance = (WorkflowInstance)Preconditions.checkNotNull((Object)builder.workflowInstance);
        TaskInstance taskInstance = new TaskInstance();
        this.injectMetadataFromTaskDefinition(taskInstance, taskDefinition);
        this.injectMetadataFromWorkflowInstance(taskInstance, workflowInstance);
        taskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
        taskInstance.setFirstSubmitTime(new Date());
        taskInstance.setSubmitTime(new Date());
        taskInstance.setStartTime(null);
        taskInstance.setEndTime(null);
        taskInstance.setHost(null);
        taskInstance.setExecutePath(null);
        taskInstance.setLogPath(null);
        taskInstance.setRetryTimes(0);
        taskInstance.setAlertFlag(Flag.NO);
        taskInstance.setFlag(Flag.YES);
        this.taskInstanceDao.insert((Object)taskInstance);
        return taskInstance;
    }

    public static class FirstRunTaskInstanceBuilder
    implements ITaskInstanceFactory.ITaskInstanceBuilder {
        private final FirstRunTaskInstanceFactory firstRunTaskInstanceFactory;
        private WorkflowInstance workflowInstance;
        private TaskDefinition taskDefinition;

        public FirstRunTaskInstanceBuilder(FirstRunTaskInstanceFactory firstRunTaskInstanceFactory) {
            this.firstRunTaskInstanceFactory = firstRunTaskInstanceFactory;
        }

        public FirstRunTaskInstanceBuilder withWorkflowInstance(WorkflowInstance workflowInstance) {
            this.workflowInstance = workflowInstance;
            return this;
        }

        public FirstRunTaskInstanceBuilder withTaskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        @Override
        public TaskInstance build() {
            return this.firstRunTaskInstanceFactory.createTaskInstance(this);
        }
    }
}

