/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPeer;
import io.kubernetes.client.openapi.models.V1NetworkPolicyPort;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8")
public class V1NetworkPolicyEgressRule {
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<V1NetworkPolicyPort> ports = null;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private List<V1NetworkPolicyPeer> to = null;

    public V1NetworkPolicyEgressRule ports(List<V1NetworkPolicyPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1NetworkPolicyEgressRule addPortsItem(V1NetworkPolicyPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1NetworkPolicyPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ports is a list of destination ports for outgoing traffic. Each item in this list is combined using a logical OR. If this field is empty or missing, this rule matches all ports (traffic not restricted by port). If this field is present and contains at least one item, then this rule allows traffic only if the traffic matches at least one port in the list.")
    public List<V1NetworkPolicyPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1NetworkPolicyPort> ports) {
        this.ports = ports;
    }

    public V1NetworkPolicyEgressRule to(List<V1NetworkPolicyPeer> to) {
        this.to = to;
        return this;
    }

    public V1NetworkPolicyEgressRule addToItem(V1NetworkPolicyPeer toItem) {
        if (this.to == null) {
            this.to = new ArrayList<V1NetworkPolicyPeer>();
        }
        this.to.add(toItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="to is a list of destinations for outgoing traffic of pods selected for this rule. Items in this list are combined using a logical OR operation. If this field is empty or missing, this rule matches all destinations (traffic not restricted by destination). If this field is present and contains at least one item, this rule allows traffic only if the traffic matches at least one item in the to list.")
    public List<V1NetworkPolicyPeer> getTo() {
        return this.to;
    }

    public void setTo(List<V1NetworkPolicyPeer> to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NetworkPolicyEgressRule v1NetworkPolicyEgressRule = (V1NetworkPolicyEgressRule)o;
        return Objects.equals(this.ports, v1NetworkPolicyEgressRule.ports) && Objects.equals(this.to, v1NetworkPolicyEgressRule.to);
    }

    public int hashCode() {
        return Objects.hash(this.ports, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NetworkPolicyEgressRule {\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

