/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.java.util.common.logger.Logger;

public class BaseNodeRoleWatcher {
    private static final Logger LOGGER = new Logger(BaseNodeRoleWatcher.class);
    private static final long DEFAULT_TIMEOUT_SECONDS = 30L;
    private final NodeRole nodeRole;
    private final ConcurrentMap<String, DiscoveryDruidNode> nodes = new ConcurrentHashMap<String, DiscoveryDruidNode>();
    private final Collection<DiscoveryDruidNode> unmodifiableNodes = Collections.unmodifiableCollection(this.nodes.values());
    private final ScheduledExecutorService listenerExecutor;
    private final List<DruidNodeDiscovery.Listener> nodeListeners = new ArrayList<DruidNodeDiscovery.Listener>();
    private final Object lock = new Object();
    private final CountDownLatch cacheInitialized = new CountDownLatch(1);
    private volatile boolean cacheInitializationTimedOut = false;

    public BaseNodeRoleWatcher(ScheduledExecutorService listenerExecutor, NodeRole nodeRole) {
        this.nodeRole = nodeRole;
        this.listenerExecutor = listenerExecutor;
    }

    public static BaseNodeRoleWatcher create(ScheduledExecutorService listenerExecutor, NodeRole nodeRole) {
        BaseNodeRoleWatcher nodeRoleWatcher = new BaseNodeRoleWatcher(listenerExecutor, nodeRole);
        nodeRoleWatcher.scheduleTimeout(30L);
        return nodeRoleWatcher;
    }

    public Collection<DiscoveryDruidNode> getAllNodes() {
        try {
            this.awaitInitialization();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.unmodifiableNodes.isEmpty()) {
            LOGGER.warn("Watcher for node role [%s] returned an empty collection.", new Object[]{this.nodeRole.getJsonName()});
        }
        return this.unmodifiableNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(DruidNodeDiscovery.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cacheInitialized.getCount() == 0L) {
                ArrayList currNodes = Lists.newArrayList(this.nodes.values());
                this.safeSchedule(() -> {
                    listener.nodesAdded(currNodes);
                    if (this.cacheInitializationTimedOut) {
                        listener.nodeViewInitializedTimedOut();
                    } else {
                        listener.nodeViewInitialized();
                    }
                }, "Exception occurred in nodesAdded([%s]) in listener [%s].", currNodes, listener);
            }
            this.nodeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childAdded(DiscoveryDruidNode druidNode) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.nodeRole.equals(druidNode.getNodeRole())) {
                LOGGER.error("Node [%s] of role [%s] addition ignored due to mismatched role (expected role [%s]).", new Object[]{druidNode.getDruidNode().getUriToUse(), druidNode.getNodeRole().getJsonName(), this.nodeRole.getJsonName()});
                return;
            }
            LOGGER.info("Node [%s] of role [%s] detected.", new Object[]{druidNode.getDruidNode().getUriToUse(), this.nodeRole.getJsonName()});
            this.addNode(druidNode);
        }
    }

    @GuardedBy(value="lock")
    private void addNode(DiscoveryDruidNode druidNode) {
        DiscoveryDruidNode prev = this.nodes.putIfAbsent(druidNode.getDruidNode().getHostAndPortToUse(), druidNode);
        if (prev == null) {
            if (this.cacheInitialized.getCount() == 0L) {
                ImmutableList newNode = ImmutableList.of((Object)druidNode);
                for (DruidNodeDiscovery.Listener listener : this.nodeListeners) {
                    this.safeSchedule(() -> BaseNodeRoleWatcher.lambda$addNode$1(listener, (List)newNode), "Exception occurred in nodeAdded(node=[%s]) in listener [%s].", druidNode.getDruidNode().getHostAndPortToUse(), listener);
                }
            }
        } else {
            LOGGER.error("Node [%s] of role [%s] discovered but existed already [%s].", new Object[]{druidNode.getDruidNode().getUriToUse(), this.nodeRole.getJsonName(), prev});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRemoved(DiscoveryDruidNode druidNode) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.nodeRole.equals(druidNode.getNodeRole())) {
                LOGGER.error("Node [%s] of role [%s] removal ignored due to mismatched role (expected role [%s]).", new Object[]{druidNode.getDruidNode().getUriToUse(), druidNode.getNodeRole().getJsonName(), this.nodeRole.getJsonName()});
                return;
            }
            LOGGER.warn("Node [%s] of role [%s] went offline.", new Object[]{druidNode.getDruidNode().getUriToUse(), this.nodeRole.getJsonName()});
            this.removeNode(druidNode);
        }
    }

    @GuardedBy(value="lock")
    private void removeNode(DiscoveryDruidNode druidNode) {
        DiscoveryDruidNode prev = (DiscoveryDruidNode)this.nodes.remove(druidNode.getDruidNode().getHostAndPortToUse());
        if (prev == null) {
            LOGGER.error("Noticed disappearance of unknown druid node [%s] of role [%s].", new Object[]{druidNode.getDruidNode().getUriToUse(), druidNode.getNodeRole().getJsonName()});
            return;
        }
        if (this.cacheInitialized.getCount() == 0L) {
            ImmutableList nodeRemoved = ImmutableList.of((Object)druidNode);
            for (DruidNodeDiscovery.Listener listener : this.nodeListeners) {
                this.safeSchedule(() -> BaseNodeRoleWatcher.lambda$removeNode$2(listener, (List)nodeRemoved), "Exception occurred in nodeRemoved(node [%s] of role [%s]) in listener [%s].", druidNode.getDruidNode().getUriToUse(), druidNode.getNodeRole().getJsonName(), listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheInitialized() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cacheInitialized.getCount() == 0L) {
                if (this.cacheInitializationTimedOut) {
                    LOGGER.warn("Cache initialization for node role[%s] has already timed out. Ignoring cache initialization event.", new Object[]{this.nodeRole.getJsonName()});
                } else {
                    LOGGER.error("Cache for node role[%s] is already initialized. ignoring cache initialization event.", new Object[]{this.nodeRole.getJsonName()});
                }
                return;
            }
            this.cacheInitialized(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheInitializedTimedOut() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cacheInitialized.getCount() != 0L) {
                this.cacheInitialized(true);
            }
        }
    }

    @GuardedBy(value="lock")
    private void cacheInitialized(boolean timedOut) {
        if (timedOut) {
            LOGGER.warn("Cache for node role [%s] could not be initialized before timeout. This service may not have full information about other nodes of type [%s].", new Object[]{this.nodeRole.getJsonName(), this.nodeRole.getJsonName()});
            this.cacheInitializationTimedOut = true;
        }
        ArrayList currNodes = Lists.newArrayList(this.nodes.values());
        LOGGER.info("Node watcher of role [%s] is now initialized with %d nodes.", new Object[]{this.nodeRole.getJsonName(), currNodes.size()});
        for (DruidNodeDiscovery.Listener listener : this.nodeListeners) {
            this.safeSchedule(() -> {
                listener.nodesAdded(currNodes);
                if (timedOut) {
                    listener.nodeViewInitializedTimedOut();
                } else {
                    listener.nodeViewInitialized();
                }
            }, "Exception occurred in nodesAdded([%s]) in listener [%s].", currNodes, listener);
        }
        this.cacheInitialized.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetNodes(Map<String, DiscoveryDruidNode> fullNodes) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<DiscoveryDruidNode> nodesAdded = new ArrayList<DiscoveryDruidNode>();
            ArrayList<DiscoveryDruidNode> nodesDeleted = new ArrayList<DiscoveryDruidNode>();
            for (Map.Entry<String, DiscoveryDruidNode> entry : fullNodes.entrySet()) {
                if (this.nodes.containsKey(entry.getKey())) continue;
                nodesAdded.add(entry.getValue());
            }
            for (Map.Entry<String, DiscoveryDruidNode> entry : this.nodes.entrySet()) {
                if (fullNodes.containsKey(entry.getKey())) continue;
                nodesDeleted.add(entry.getValue());
            }
            for (DiscoveryDruidNode discoveryDruidNode : nodesDeleted) {
                this.nodes.remove(discoveryDruidNode.getDruidNode().getHostAndPortToUse());
            }
            for (DiscoveryDruidNode discoveryDruidNode : nodesAdded) {
                this.nodes.put(discoveryDruidNode.getDruidNode().getHostAndPortToUse(), discoveryDruidNode);
            }
            if (this.cacheInitialized.getCount() == 0L) {
                for (DruidNodeDiscovery.Listener listener : this.nodeListeners) {
                    this.safeSchedule(() -> {
                        if (!nodesAdded.isEmpty()) {
                            listener.nodesAdded(nodesAdded);
                        }
                        if (!nodesDeleted.isEmpty()) {
                            listener.nodesRemoved(nodesDeleted);
                        }
                    }, "Exception occurred in resetNodes in listener [%s].", listener);
                }
            }
        }
    }

    void scheduleTimeout(long timeout) {
        this.listenerExecutor.schedule(this::cacheInitializedTimedOut, timeout, TimeUnit.SECONDS);
    }

    void awaitInitialization() throws InterruptedException {
        this.cacheInitialized.await();
    }

    private void safeSchedule(Runnable runnable, String errMsgFormat, Object ... args) {
        this.listenerExecutor.submit(() -> {
            try {
                runnable.run();
            }
            catch (Exception ex) {
                LOGGER.error(errMsgFormat, args);
            }
        });
    }

    private static /* synthetic */ void lambda$removeNode$2(DruidNodeDiscovery.Listener listener, List nodeRemoved) {
        listener.nodesRemoved(nodeRemoved);
    }

    private static /* synthetic */ void lambda$addNode$1(DruidNodeDiscovery.Listener listener, List newNode) {
        listener.nodesAdded(newNode);
    }
}

