/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.SegmentLoadInfo;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.FluentQueryRunner;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class SegmentMetadataQuerySegmentWalker
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(SegmentMetadataQuerySegmentWalker.class);
    private final CoordinatorServerView serverView;
    private final DruidHttpClientConfig httpClientConfig;
    private final ServiceEmitter emitter;
    protected final QueryRunnerFactoryConglomerate conglomerate;
    protected final ServerConfig serverConfig;

    @Inject
    public SegmentMetadataQuerySegmentWalker(CoordinatorServerView serverView, DruidHttpClientConfig httpClientConfig, QueryRunnerFactoryConglomerate conglomerate, ServerConfig serverConfig, ServiceEmitter emitter) {
        this.serverView = serverView;
        this.httpClientConfig = httpClientConfig;
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.serverConfig = serverConfig;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        throw new UnsupportedOperationException();
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, final Iterable<SegmentDescriptor> specs) {
        return this.decorateRunner(query, new QueryRunner<T>(){

            public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
                return SegmentMetadataQuerySegmentWalker.this.run(queryPlus, responseContext, new CachingClusteredClient.TimelineConverter<SegmentLoadInfo>(specs));
            }
        });
    }

    private <T> QueryRunner<T> decorateRunner(Query<T> query, QueryRunner<T> baseClusterRunner) {
        QueryToolChest toolChest = this.conglomerate.getToolChest(query);
        SetAndVerifyContextQueryRunner<T> baseRunner = new SetAndVerifyContextQueryRunner<T>(this.serverConfig, baseClusterRunner);
        return FluentQueryRunner.create(baseRunner, (QueryToolChest)toolChest).emitCPUTimeMetric(this.emitter);
    }

    private <T> Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext, UnaryOperator<TimelineLookup<String, SegmentLoadInfo>> timelineConverter) {
        Query query = queryPlus.getQuery();
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverView.getTimeline(query.getDataSource());
        if (timeline == null) {
            return Sequences.empty();
        }
        TimelineLookup timelineLookup = (TimelineLookup)timelineConverter.apply((TimelineLookup<String, SegmentLoadInfo>)timeline);
        QueryToolChest toolChest = this.conglomerate.getToolChest(query);
        Set<Pair<SegmentDescriptor, SegmentLoadInfo>> segmentAndServers = this.computeSegmentsToQuery((TimelineLookup<String, SegmentLoadInfo>)timelineLookup, query, toolChest);
        queryPlus = queryPlus.withQueryMetrics(toolChest);
        queryPlus.getQueryMetrics().reportQueriedSegmentCount((long)segmentAndServers.size()).emit(this.emitter);
        SortedMap<String, List<SegmentDescriptor>> serverSegments = this.groupSegmentsByServer(segmentAndServers, query);
        ArrayList listOfSequences = new ArrayList(serverSegments.size());
        QueryPlus finalQueryPlus = queryPlus;
        serverSegments.forEach((server, segmentsOfServer) -> {
            QueryRunner serverRunner = this.serverView.getQueryRunner((String)server);
            if (serverRunner == null) {
                log.error("Server [%s] doesn't have a query runner", new Object[]{server});
                return;
            }
            long maxQueuedBytes = this.httpClientConfig.getMaxQueuedBytes();
            long maxQueuedBytesPerServer = maxQueuedBytes / (long)serverSegments.size();
            Sequence serverResults = this.getServerResults(serverRunner, (QueryPlus)finalQueryPlus, responseContext, maxQueuedBytesPerServer, (List<SegmentDescriptor>)segmentsOfServer);
            listOfSequences.add(serverResults);
        });
        return this.merge(queryPlus.getQuery(), listOfSequences);
    }

    <T> Sequence<T> getServerResults(QueryRunner serverRunner, QueryPlus<T> queryPlus, ResponseContext responseContext, long maxQueuedBytesPerServer, List<SegmentDescriptor> segmentDescriptors) {
        return serverRunner.run(queryPlus.withQuery(Queries.withSpecificSegments((Query)queryPlus.getQuery(), segmentDescriptors)).withMaxQueuedBytes(maxQueuedBytesPerServer), responseContext);
    }

    private <T> Set<Pair<SegmentDescriptor, SegmentLoadInfo>> computeSegmentsToQuery(TimelineLookup<String, SegmentLoadInfo> timeline, Query<T> query, QueryToolChest<T, Query<T>> toolChest) {
        Function<Interval, List> lookupFn = arg_0 -> timeline.lookupWithIncompletePartitions(arg_0);
        List intervals = query.getIntervals();
        List timelineObjectHolders = intervals.stream().flatMap(i -> ((List)lookupFn.apply((Interval)i)).stream()).collect(Collectors.toList());
        List serversLookup = toolChest.filterSegments(query, timelineObjectHolders);
        HashSet<Pair<SegmentDescriptor, SegmentLoadInfo>> segmentAndServers = new HashSet<Pair<SegmentDescriptor, SegmentLoadInfo>>();
        for (TimelineObjectHolder holder : serversLookup) {
            HashSet filteredChunks = Sets.newHashSet((Iterable)holder.getObject());
            for (PartitionChunk chunk : filteredChunks) {
                SegmentLoadInfo server = (SegmentLoadInfo)chunk.getObject();
                SegmentDescriptor segment = new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                segmentAndServers.add((Pair<SegmentDescriptor, SegmentLoadInfo>)new Pair((Object)segment, (Object)server));
            }
        }
        return segmentAndServers;
    }

    private <T> SortedMap<String, List<SegmentDescriptor>> groupSegmentsByServer(Set<Pair<SegmentDescriptor, SegmentLoadInfo>> segmentAndServers, Query<T> query) {
        TreeMap<String, List<SegmentDescriptor>> serverSegments = new TreeMap<String, List<SegmentDescriptor>>();
        for (Pair<SegmentDescriptor, SegmentLoadInfo> segmentAndServer : segmentAndServers) {
            DruidServerMetadata druidServerMetadata = ((SegmentLoadInfo)segmentAndServer.rhs).pickOne();
            if (druidServerMetadata == null) {
                log.makeAlert("No servers found for SegmentDescriptor[%s] for DataSource[%s]?! How can this be?!", new Object[]{segmentAndServer.lhs, query.getDataSource()}).emit();
                continue;
            }
            serverSegments.computeIfAbsent(druidServerMetadata.getName(), s -> new ArrayList()).add((SegmentDescriptor)segmentAndServer.lhs);
        }
        return serverSegments;
    }

    private <T> Sequence<T> merge(Query<T> query, List<Sequence<T>> sequencesByInterval) {
        return Sequences.simple(sequencesByInterval).flatMerge(seq -> seq, query.getResultOrdering());
    }
}

