/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Min;
import org.apache.druid.query.search.SearchQuery;

public class SearchQueryConfig {
    public static final String CTX_KEY_STRATEGY = "searchStrategy";
    @JsonProperty
    @Min(value=1L)
    private @Min(value=1L) int maxSearchLimit = 1000;
    @JsonProperty
    private String searchStrategy = "useIndexes";

    public int getMaxSearchLimit() {
        return this.maxSearchLimit;
    }

    public String getSearchStrategy() {
        return this.searchStrategy;
    }

    public void setSearchStrategy(String strategy) {
        this.searchStrategy = strategy;
    }

    public SearchQueryConfig withOverrides(SearchQuery query) {
        SearchQueryConfig newConfig = new SearchQueryConfig();
        newConfig.maxSearchLimit = query.getLimit();
        newConfig.searchStrategy = query.context().getString(CTX_KEY_STRATEGY, this.searchStrategy);
        return newConfig;
    }
}

