/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.error.EntryAlreadyExists;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.config.TaskStorageConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.TaskStorageUtils;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.DateTime;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class HeapMemoryTaskStorage
implements TaskStorage {
    private final TaskStorageConfig config;
    private final ConcurrentHashMap<String, TaskInfo> tasks = new ConcurrentHashMap();
    @GuardedBy(value="itself")
    private final Multimap<String, TaskLock> taskLocks = HashMultimap.create();
    private static final Logger log = new Logger(HeapMemoryTaskStorage.class);

    @Inject
    public HeapMemoryTaskStorage(TaskStorageConfig config) {
        this.config = config;
    }

    @Override
    public TaskInfo insert(Task task, TaskStatus status) {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Preconditions.checkArgument((boolean)task.getId().equals(status.getId()), (String)"Task/Status ID mismatch[%s/%s]", (Object)task.getId(), (Object)status.getId());
        TaskInfo newTaskInfo = new TaskInfo(DateTimes.nowUtc(), status, task);
        TaskInfo existingTaskInfo = this.tasks.putIfAbsent(task.getId(), newTaskInfo);
        if (existingTaskInfo != null) {
            throw EntryAlreadyExists.exception((String)"Task[%s] already exists", (Object[])new Object[]{task.getId()});
        }
        log.info("Inserted task[%s] with status[%s]", new Object[]{task.getId(), status});
        return newTaskInfo;
    }

    @Override
    public Optional<Task> getTask(String taskid) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        TaskInfo taskInfo = this.tasks.get(taskid);
        if (taskInfo != null) {
            return Optional.of((Object)taskInfo.getTask());
        }
        return Optional.absent();
    }

    @Override
    public void setStatus(TaskStatus status) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        String taskid = status.getId();
        log.info("Updating task %s to status: %s", new Object[]{taskid, status});
        TaskInfo updated = this.tasks.computeIfPresent(taskid, (tid, taskInfo) -> {
            Preconditions.checkState((boolean)taskInfo.getStatus().isRunnable(), (String)"Task must be runnable: %s", (Object)taskid);
            return taskInfo.withStatus(status);
        });
        Preconditions.checkNotNull((Object)updated, (String)"Task ID must already be present: %s", (Object)taskid);
    }

    @Override
    public Optional<TaskStatus> getStatus(String taskid) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        TaskInfo existing = this.tasks.get(taskid);
        if (existing != null) {
            return Optional.of((Object)existing.getStatus());
        }
        return Optional.absent();
    }

    @Override
    @Nullable
    public TaskInfo getTaskInfo(String taskId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        return this.tasks.get(taskId);
    }

    @Override
    public List<Task> getActiveTasks() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (TaskInfo taskInfo : this.tasks.values()) {
            if (!taskInfo.getStatus().isRunnable()) continue;
            listBuilder.add((Object)taskInfo.getTask());
        }
        return listBuilder.build();
    }

    @Override
    public List<TaskInfo> getActiveTaskInfos() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (TaskInfo taskInfo : this.tasks.values()) {
            if (!taskInfo.getStatus().isRunnable()) continue;
            listBuilder.add((Object)taskInfo);
        }
        return listBuilder.build();
    }

    @Override
    public List<Task> getActiveTasksByDatasource(String datasource) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Map.Entry<String, TaskInfo> entry : this.tasks.entrySet()) {
            if (!entry.getValue().getStatus().isRunnable() || !entry.getValue().getDataSource().equals(datasource)) continue;
            listBuilder.add((Object)entry.getValue().getTask());
        }
        return listBuilder.build();
    }

    public List<TaskInfo> getActiveTaskInfo(@Nullable String dataSource) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (TaskInfo taskInfo : this.tasks.values()) {
            if (!taskInfo.getStatus().isRunnable() || dataSource != null && !dataSource.equals(taskInfo.getDataSource())) continue;
            listBuilder.add((Object)taskInfo);
        }
        return listBuilder.build();
    }

    public List<TaskInfo> getRecentlyCreatedAlreadyFinishedTaskInfo(TaskLookup.CompleteTaskLookup taskLookup) {
        Ordering createdDateDesc = new Ordering<TaskInfo>(){

            public int compare(TaskInfo a, TaskInfo b) {
                return a.getCreatedTime().compareTo((ReadableInstant)b.getCreatedTime());
            }
        }.reverse();
        return this.getRecentlyCreatedAlreadyFinishedTaskInfoSince(taskLookup.getTasksCreatedPriorTo(), taskLookup.getMaxTaskStatuses(), (Ordering<TaskInfo>)createdDateDesc);
    }

    @Override
    public List<TaskInfo> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String datasource) {
        ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
        Map<TaskLookup.TaskLookupType, TaskLookup> processedTaskLookups = TaskStorageUtils.processTaskLookups(taskLookups, DateTimes.nowUtc().minus((ReadableDuration)this.config.getRecentlyFinishedThreshold()));
        processedTaskLookups.forEach((type, lookup) -> {
            if (type == TaskLookup.TaskLookupType.COMPLETE) {
                tasks.addAll(this.getRecentlyCreatedAlreadyFinishedTaskInfo((TaskLookup.CompleteTaskLookup)lookup));
            } else {
                tasks.addAll(this.getActiveTaskInfo(datasource));
            }
        });
        return tasks;
    }

    @Override
    public List<TaskStatusPlus> getTaskStatusPlusList(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String datasource) {
        return this.getTaskInfos(taskLookups, datasource).stream().map(Task::toTaskIdentifierInfo).map(TaskStatusPlus::fromTaskIdentifierInfo).collect(Collectors.toList());
    }

    private List<TaskInfo> getRecentlyCreatedAlreadyFinishedTaskInfoSince(DateTime start, @Nullable Integer n, Ordering<TaskInfo> createdDateDesc) {
        Stream<TaskInfo> stream = this.tasks.values().stream().filter(taskInfo -> taskInfo.getStatus().isComplete() && taskInfo.getCreatedTime().isAfter((ReadableInstant)start)).sorted((Comparator<TaskInfo>)createdDateDesc);
        if (n != null) {
            stream = stream.limit(n.intValue());
        }
        return stream.collect(Collectors.toUnmodifiableList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLock(String taskid, TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        Multimap<String, TaskLock> multimap = this.taskLocks;
        synchronized (multimap) {
            this.taskLocks.put((Object)taskid, (Object)taskLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceLock(String taskid, TaskLock oldLock, TaskLock newLock) {
        Preconditions.checkNotNull((Object)taskid, (Object)"taskid");
        Preconditions.checkNotNull((Object)oldLock, (Object)"oldLock");
        Preconditions.checkNotNull((Object)newLock, (Object)"newLock");
        Multimap<String, TaskLock> multimap = this.taskLocks;
        synchronized (multimap) {
            if (!this.taskLocks.remove((Object)taskid, (Object)oldLock)) {
                log.warn("taskLock[%s] for replacement is not found for task[%s]", new Object[]{oldLock, taskid});
            }
            this.taskLocks.put((Object)taskid, (Object)newLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLock(String taskid, TaskLock taskLock) {
        Preconditions.checkNotNull((Object)taskLock, (Object)"taskLock");
        Multimap<String, TaskLock> multimap = this.taskLocks;
        synchronized (multimap) {
            this.taskLocks.remove((Object)taskid, (Object)taskLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskLock> getLocks(String taskid) {
        Multimap<String, TaskLock> multimap = this.taskLocks;
        synchronized (multimap) {
            return ImmutableList.copyOf((Collection)this.taskLocks.get((Object)taskid));
        }
    }

    @Override
    public void removeTasksOlderThan(long timestamp) {
        List<String> taskIds = this.tasks.entrySet().stream().filter(entry -> ((TaskInfo)entry.getValue()).getStatus().isComplete() && ((TaskInfo)entry.getValue()).getCreatedTime().isBefore(timestamp)).map(Map.Entry::getKey).collect(Collectors.toList());
        taskIds.forEach(this.tasks::remove);
    }
}

