/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import io.micrometer.context.ContextSnapshot;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.ContextPropagation;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InternalProducerAttr;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxContextWriteRestoringThreadLocals<T>
extends FluxOperator<T, T> {
    final Function<Context, Context> doOnContext;

    FluxContextWriteRestoringThreadLocals(Flux<? extends T> source, Function<Context, Context> doOnContext) {
        super(source);
        this.doOnContext = Objects.requireNonNull(doOnContext, "doOnContext");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Context c = this.doOnContext.apply(actual.currentContext());
        try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(c);){
            this.source.subscribe(new ContextWriteRestoringThreadLocalsSubscriber<T>(actual, c));
        }
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return super.scanUnsafe(key);
    }

    static final class FuseableContextWriteRestoringThreadLocalsSubscriber<T>
    extends ContextWriteRestoringThreadLocalsSubscriber<T>
    implements Fuseable.QueueSubscription<T> {
        FuseableContextWriteRestoringThreadLocalsSubscriber(CoreSubscriber<? super T> actual, Context context) {
            super(actual, context);
        }

        @Override
        public void onNext(T t) {
            super.onNext(t);
        }

        @Override
        public T poll() {
            throw new UnsupportedOperationException("Nope");
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Nope");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("Nope");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Nope");
        }
    }

    static class ContextWriteRestoringThreadLocalsSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final Context context;
        Subscription s;

        ContextWriteRestoringThreadLocalsSubscriber(CoreSubscriber<? super T> actual, Context context) {
            this.actual = actual;
            this.context = context;
            this.actualConditional = actual instanceof Fuseable.ConditionalSubscriber ? (Fuseable.ConditionalSubscriber)actual : null;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public Context currentContext() {
            return this.context;
        }

        @Override
        public void onSubscribe(Subscription s) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                if (Operators.validate(this.s, s)) {
                    this.s = s;
                    this.actual.onSubscribe(this);
                }
            }
        }

        public void onNext(T t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onNext(t);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                if (this.actualConditional != null) {
                    boolean bl = this.actualConditional.tryOnNext(t);
                    return bl;
                }
                this.actual.onNext(t);
                boolean bl = true;
                return bl;
            }
        }

        public void onError(Throwable t) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onError(t);
            }
        }

        public void onComplete() {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.actual.currentContext());){
                this.actual.onComplete();
            }
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.context);){
                this.s.request(n);
            }
        }

        public void cancel() {
            try (ContextSnapshot.Scope ignored = ContextPropagation.setThreadLocals(this.context);){
                this.s.cancel();
            }
        }
    }
}

