/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.reactor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogManager;
import com.navercorp.pinpoint.bootstrap.logging.PluginLogger;
import com.navercorp.pinpoint.bootstrap.plugin.reactor.ReactorContextAccessorUtils;

public class FluxAndMonoOperatorConstructorInterceptor
implements AroundInterceptor {
    private final PluginLogger logger = PluginLogManager.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    @Override
    public void before(Object target, Object[] args) {
    }

    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block6: {
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            if (throwable != null) {
                return;
            }
            try {
                if (this.checkSourceReactorContextAccessor(target, args)) {
                    return;
                }
                if (this.checkSourceAsyncContextAccessor(target, args)) {
                    return;
                }
                this.checkArgsAsyncContextAccessor(target, args);
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("AFTER. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    boolean checkSourceReactorContextAccessor(Object target, Object[] args) {
        AsyncContext sourceAsyncContext = this.getReactorContextFromSource(target, args);
        if (sourceAsyncContext != null) {
            this.setReactorContextToTarget(sourceAsyncContext, target);
            return true;
        }
        return false;
    }

    boolean checkSourceAsyncContextAccessor(Object target, Object[] args) {
        AsyncContext sourceAsyncContext = this.getAsyncContextFromSource(target, args);
        if (sourceAsyncContext != null) {
            this.setReactorContextToTarget(sourceAsyncContext, target);
            return true;
        }
        return false;
    }

    boolean checkArgsAsyncContextAccessor(Object target, Object[] args) {
        AsyncContext argAsyncContext = this.getAsyncContextFromArgs(target, args);
        if (argAsyncContext != null) {
            this.setAsyncContextToTarget(argAsyncContext, target);
            this.setReactorContextToTarget(argAsyncContext, target);
            return true;
        }
        return false;
    }

    protected AsyncContext getReactorContextFromSource(Object target, Object[] args) {
        return ReactorContextAccessorUtils.getAsyncContext(args, 0);
    }

    protected AsyncContext getAsyncContextFromSource(Object target, Object[] args) {
        return AsyncContextAccessorUtils.getAsyncContext(args, 0);
    }

    protected AsyncContext getAsyncContextFromArgs(Object target, Object[] args) {
        return AsyncContextAccessorUtils.findAsyncContext(args, 1);
    }

    protected void setAsyncContextToTarget(AsyncContext asyncContext, Object target) {
        AsyncContextAccessorUtils.setAsyncContext(asyncContext, target);
        if (this.isDebug) {
            this.logger.debug("Set asyncContext to target. asyncContext={}", (Object)asyncContext);
        }
    }

    protected void setReactorContextToTarget(AsyncContext asyncContext, Object target) {
        ReactorContextAccessorUtils.setAsyncContext(asyncContext, target);
        if (this.isDebug) {
            this.logger.debug("Set reactorContext to target. reactorContext={}", (Object)asyncContext);
        }
    }
}

