/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source.dialect.snapshot.mysql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcSourceConfig;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.MysqlConfig;
import org.apache.eventmesh.connector.jdbc.CatalogChanges;
import org.apache.eventmesh.connector.jdbc.connection.mysql.MysqlJdbcConnection;
import org.apache.eventmesh.connector.jdbc.context.mysql.MysqlOffsetContext;
import org.apache.eventmesh.connector.jdbc.context.mysql.MysqlPartition;
import org.apache.eventmesh.connector.jdbc.dialect.mysql.MysqlDatabaseDialect;
import org.apache.eventmesh.connector.jdbc.event.Event;
import org.apache.eventmesh.connector.jdbc.event.EventConsumer;
import org.apache.eventmesh.connector.jdbc.event.SchemaChangeEventType;
import org.apache.eventmesh.connector.jdbc.source.SourceMateData;
import org.apache.eventmesh.connector.jdbc.source.dialect.antlr4.mysql.MysqlAntlr4DdlParser;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlConstants;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlDialectSql;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlJdbcContext;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlSourceMateData;
import org.apache.eventmesh.connector.jdbc.source.dialect.snapshot.AbstractSnapshotEngine;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.DefaultValueConvertor;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlDefaultValueConvertorImpl;
import org.apache.eventmesh.connector.jdbc.utils.MysqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSnapshotEngine
extends AbstractSnapshotEngine<MysqlDatabaseDialect, MysqlJdbcContext, MysqlPartition, MysqlOffsetContext, MysqlJdbcConnection> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlSnapshotEngine.class);
    private volatile boolean globalLockAcquired = false;
    private volatile boolean tableLockAcquired = false;
    private List<EventConsumer> consumers = new ArrayList<EventConsumer>(16);
    private MysqlJdbcConnection connection;
    private DefaultValueConvertor defaultValueConvertor = new MysqlDefaultValueConvertorImpl();

    public MysqlSnapshotEngine(JdbcSourceConfig jdbcSourceConfig, MysqlDatabaseDialect databaseDialect, MysqlJdbcContext jdbcContext) {
        super(jdbcSourceConfig, databaseDialect, jdbcContext, (MysqlPartition)jdbcContext.getPartition(), (MysqlOffsetContext)jdbcContext.getOffsetContext());
        this.connection = databaseDialect.getConnection();
        ((MysqlAntlr4DdlParser)jdbcContext.getParser()).addTableIdSet(this.getHandledTables());
    }

    @Override
    protected Set<String> defaultExcludeDatabase() {
        return MysqlConstants.DEFAULT_EXCLUDE_DATABASE;
    }

    @Override
    public void close() throws Exception {
        this.shutdown();
    }

    @Override
    protected SourceMateData buildSourceMateData(MysqlJdbcContext context, AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext, TableId tableId) {
        MysqlSourceMateData sourceMateData = MysqlSourceMateData.newBuilder().name(this.sourceConnectorConfig.getName()).withTableId(tableId).serverId(this.sourceConnectorConfig.getMysqlConfig().getServerId()).snapshot(true).position(context.getSourceInfo().getCurrentBinlogPosition()).build();
        return sourceMateData;
    }

    @Override
    protected void preSnapshot(MysqlJdbcContext jdbcContext, AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext) {
    }

    @Override
    protected void determineTable2Process(MysqlJdbcContext jdbcContext, AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext) {
        snapshotContext.addAll(this.getHandledTables());
    }

    @Override
    protected void lockTables4SchemaSnapshot(MysqlJdbcContext jdbcContext, AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext) throws SQLException {
        this.connection.connection().setTransactionIsolation(4);
        this.connection.executeWithoutCommitting("SET SESSION lock_wait_timeout=10", "SET SESSION innodb_lock_wait_timeout=10");
        MysqlConfig mysqlConfig = this.sourceConnectorConfig.getMysqlConfig();
        if (mysqlConfig.getSnapshotLockingMode().usesLocking() && mysqlConfig.isUseGlobalLock()) {
            this.globalLockAcquiredTry();
        }
    }

    @Override
    protected void determineSnapshotOffset(MysqlJdbcContext jdbcContext, AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext) throws SQLException {
        if (!this.globalLockAcquired && !this.tableLockAcquired) {
            return;
        }
        log.info("Read binlog info from Mysql Server");
        this.connection.query(MysqlDialectSql.SHOW_MASTER_STATUS.ofSQL(), resultSet -> {
            if (resultSet.next()) {
                String binlogFilename = resultSet.getString(1);
                long position = resultSet.getLong(2);
                jdbcContext.setBinlogStartPoint(binlogFilename, position);
                if (resultSet.getMetaData().getColumnCount() >= 5) {
                    String gtidSet = resultSet.getString(5);
                    jdbcContext.completedGtidSet(gtidSet);
                    log.info("Using binlog '{}' at position '{}' and gtid '{}'", new Object[]{binlogFilename, position, gtidSet});
                } else {
                    log.info("Using binlog '{}' at position '{}' ", (Object)binlogFilename, (Object)position);
                }
            } else {
                throw new SQLException("Cannot read the binlog filename and position,Make sure Mysql server is correctly configured");
            }
        });
    }

    @Override
    protected void readStructureOfTables(MysqlJdbcContext jdbcContext, AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext) throws SQLException, InterruptedException {
        if (this.sourceConnectorConfig.getMysqlConfig().getSnapshotLockingMode().usesLocking() && !this.globalLockAcquired) {
            this.lockTable(snapshotContext);
            this.determineSnapshotOffset(jdbcContext, snapshotContext);
        }
        Set<TableId> determineTables = snapshotContext.getDetermineTables();
        for (TableId tableId : determineTables) {
            StringBuilder dropTableDdl = new StringBuilder("DROP TABLE IF EXISTS ");
            dropTableDdl.append(MysqlUtils.wrapper(tableId));
            this.addParseDdlAndEvent(jdbcContext, dropTableDdl.toString(), tableId);
        }
        HashMap databaseMapTables = determineTables.stream().collect(Collectors.groupingBy(TableId::getCatalogName, HashMap::new, Collectors.toList()));
        Set databaseSet = databaseMapTables.keySet();
        for (String database : databaseSet) {
            StringBuilder dropDatabaseDdl = new StringBuilder("DROP DATABASE IF EXISTS ").append(MysqlUtils.wrapper(database));
            this.addParseDdlAndEvent(jdbcContext, dropDatabaseDdl.toString(), new TableId(database));
            String databaseCreateDdl = this.connection.query(MysqlDialectSql.SHOW_CREATE_DATABASE.ofWrapperSQL(MysqlUtils.wrapper(database)), rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 1) {
                    String ddl = rs.getString(2);
                    return ddl;
                }
                return null;
            });
            if (StringUtils.isBlank((CharSequence)databaseCreateDdl)) {
                log.warn("Database {} ddl is empty", (Object)database);
                continue;
            }
            TableId tableId = new TableId(database);
            this.addParseDdlAndEvent(jdbcContext, databaseCreateDdl, tableId);
            this.addParseDdlAndEvent(jdbcContext, "USE " + database, tableId);
            List tableIds = (List)databaseMapTables.get(database);
            this.createTableSnapshotEvent(tableIds, jdbcContext);
        }
    }

    private void addParseDdlAndEvent(MysqlJdbcContext jdbcContext, String ddl, TableId tableId) {
        ((MysqlAntlr4DdlParser)jdbcContext.getParser()).setCurrentDatabase(tableId.getCatalogName());
        ((MysqlAntlr4DdlParser)jdbcContext.getParser()).setCatalogTableSet(jdbcContext.getCatalogTableSet());
        ((MysqlAntlr4DdlParser)jdbcContext.getParser()).parse(ddl, event -> {
            try {
                CatalogChanges catalogChanges;
                SchemaChangeEventType schemaChangeEventType;
                if (event == null) {
                    return;
                }
                if (event.getJdbcConnectData().isSchemaChanges() && (SchemaChangeEventType.TABLE_CREATE == (schemaChangeEventType = SchemaChangeEventType.ofSchemaChangeEventType((catalogChanges = event.getJdbcConnectData().getPayload().getCatalogChanges()).getType(), catalogChanges.getOperationType())) || SchemaChangeEventType.TABLE_ALERT == schemaChangeEventType)) {
                    catalogChanges.getColumns().forEach(column -> column.setDefaultValue(this.defaultValueConvertor.parseDefaultValue((Column<?>)column, column.getDefaultValueExpression())));
                }
                event.getJdbcConnectData().getPayload().withDdl(ddl).ofSourceMateData().setSnapshot(true);
                this.eventQueue.put(event);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void createTableSnapshotEvent(List<TableId> tableIds, MysqlJdbcContext jdbcContext) throws SQLException {
        if (CollectionUtils.isEmpty(tableIds)) {
            return;
        }
        for (TableId tableId : tableIds) {
            this.connection.query(MysqlDialectSql.SHOW_CREATE_TABLE.ofWrapperSQL(tableId.toString()), resultSet -> {
                if (resultSet.next()) {
                    String createTableDdl = resultSet.getString(2);
                    this.addParseDdlAndEvent(jdbcContext, createTableDdl, tableId);
                }
            });
        }
    }

    private void lockTable(AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext) throws SQLException {
        Boolean lockedTable = this.connection.query(MysqlDialectSql.SHOW_GRANTS_FOR_CURRENT_USER.ofSQL(), rs -> {
            while (rs.next()) {
                String grantPrivilege = rs.getString(1);
                if (StringUtils.isBlank((CharSequence)grantPrivilege)) continue;
                if (!StringUtils.containsAny((CharSequence)grantPrivilege.toUpperCase(), (CharSequence[])new CharSequence[]{"ALL", "LOCK TABLES"})) continue;
                return true;
            }
            return false;
        });
        if (!lockedTable.booleanValue()) {
            throw new SQLException("Current User does not have the 'LOCK TABLES' privilege");
        }
        if (CollectionUtils.isNotEmpty(snapshotContext.getDetermineTables())) {
            String tableNameList = snapshotContext.getDetermineTables().stream().map(TableId::toString).collect(Collectors.joining(","));
            this.connection.executeWithoutCommitting(MysqlDialectSql.LOCK_TABLES.ofWrapperSQL(tableNameList));
        }
        this.tableLockAcquired = true;
    }

    @Override
    protected void releaseSnapshotLocks(MysqlJdbcContext jdbcContext, AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext) throws Exception {
        if (this.globalLockAcquired) {
            this.connection.executeWithoutCommitting(MysqlDialectSql.UNLOCK_TABLES.ofSQL());
            this.globalLockAcquired = false;
        }
        if (this.tableLockAcquired) {
            this.connection.executeWithoutCommitting(MysqlDialectSql.UNLOCK_TABLES.ofSQL());
            this.globalLockAcquired = false;
        }
    }

    @Override
    protected Optional<String> getSnapshotTableSelectSql(MysqlJdbcContext jdbcContext, AbstractSnapshotEngine.SnapshotContext<MysqlPartition, MysqlOffsetContext> snapshotContext, TableId tableId) {
        return Optional.of(MysqlDialectSql.SNAPSHOT_TABLE_SELECT_SQL.ofWrapperSQL(tableId.toString()));
    }

    private void globalLockAcquiredTry() throws SQLException {
        this.connection.executeWithoutCommitting(MysqlDialectSql.LOCK_TABLE_GLOBAL.ofSQL());
        this.globalLockAcquired = true;
    }

    public String getThreadName() {
        return this.getClass().getSimpleName() + "-thread";
    }

    public void run() {
        while (this.isRunning) {
            try {
                Event event = (Event)this.eventQueue.poll(5L, TimeUnit.SECONDS);
                if (event == null) continue;
                this.consumers.forEach(consumer -> consumer.accept(event));
            }
            catch (Exception e) {
                log.warn("Consume snapshot event error", (Throwable)e);
            }
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void registerSnapshotEventConsumer(EventConsumer consumer) {
        if (consumer == null) {
            return;
        }
        this.consumers.add(consumer);
    }

    @Override
    protected OptionalLong getRowCount4Table(TableId tableId) {
        return this.connection.getRowCount4Table(tableId);
    }
}

