/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.rds;

import com.alibaba.otter.canal.parse.exception.PositionNotFoundException;
import com.alibaba.otter.canal.parse.inbound.ParserExceptionHandler;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlEventParser;
import com.alibaba.otter.canal.parse.inbound.mysql.rds.RdsLocalBinlogEventParser;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.sink.CanalEventSink;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;

public class RdsBinlogEventParserProxy
extends MysqlEventParser {
    private String rdsOpenApiUrl = "https://rds.aliyuncs.com/";
    private String accesskey;
    private String secretkey;
    private String instanceId;
    private String directory;
    private int batchFileSize = 4;
    private RdsLocalBinlogEventParser rdsLocalBinlogEventParser = null;
    private ExecutorService executorService = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "rds-binlog-daemon-thread");
        t.setDaemon(true);
        return t;
    });

    @Override
    public void start() {
        if (this.rdsLocalBinlogEventParser == null && StringUtils.isNotEmpty((String)this.accesskey) && StringUtils.isNotEmpty((String)this.secretkey) && StringUtils.isNotEmpty((String)this.instanceId)) {
            this.rdsLocalBinlogEventParser = new RdsLocalBinlogEventParser();
            this.setRdsOssMode(true);
            ParserExceptionHandler targetHandler = this.getParserExceptionHandler();
            if (this.directory == null) {
                this.directory = System.getProperty("java.io.tmpdir", "/tmp") + "/" + this.destination;
            }
            this.rdsLocalBinlogEventParser.setLogPositionManager(this.getLogPositionManager());
            this.rdsLocalBinlogEventParser.setDestination(this.destination);
            this.rdsLocalBinlogEventParser.setAlarmHandler(this.getAlarmHandler());
            this.rdsLocalBinlogEventParser.setConnectionCharsetStd(this.connectionCharset);
            this.rdsLocalBinlogEventParser.setConnectionCharsetNumber(this.connectionCharsetNumber);
            this.rdsLocalBinlogEventParser.setEnableTsdb(this.enableTsdb);
            this.rdsLocalBinlogEventParser.setEventBlackFilter(this.eventBlackFilter);
            this.rdsLocalBinlogEventParser.setFilterQueryDcl(this.filterQueryDcl);
            this.rdsLocalBinlogEventParser.setFilterQueryDdl(this.filterQueryDdl);
            this.rdsLocalBinlogEventParser.setFilterQueryDml(this.filterQueryDml);
            this.rdsLocalBinlogEventParser.setFilterRows(this.filterRows);
            this.rdsLocalBinlogEventParser.setFilterTableError(this.filterTableError);
            this.rdsLocalBinlogEventParser.setMasterInfo(this.masterInfo);
            this.rdsLocalBinlogEventParser.setEventFilter(this.eventFilter);
            this.rdsLocalBinlogEventParser.setMasterPosition(this.masterPosition);
            this.rdsLocalBinlogEventParser.setTransactionSize(this.transactionSize);
            this.rdsLocalBinlogEventParser.setUrl(this.rdsOpenApiUrl);
            this.rdsLocalBinlogEventParser.setAccesskey(this.accesskey);
            this.rdsLocalBinlogEventParser.setSecretkey(this.secretkey);
            this.rdsLocalBinlogEventParser.setInstanceId(this.instanceId);
            this.rdsLocalBinlogEventParser.setEventSink((CanalEventSink<List<CanalEntry.Entry>>)this.eventSink);
            this.rdsLocalBinlogEventParser.setDirectory(this.directory);
            this.rdsLocalBinlogEventParser.setBatchFileSize(this.batchFileSize);
            this.rdsLocalBinlogEventParser.setParallel(this.parallel);
            this.rdsLocalBinlogEventParser.setParallelBufferSize(this.parallelBufferSize);
            this.rdsLocalBinlogEventParser.setParallelThreadSize(this.parallelThreadSize);
            this.rdsLocalBinlogEventParser.setFinishListener(() -> this.executorService.execute(() -> {
                this.rdsLocalBinlogEventParser.stop();
                this.setDumpErrorCount(0);
                this.start();
            }));
            this.setParserExceptionHandler(e -> {
                this.handleMysqlParserException(e);
                if (targetHandler != null) {
                    targetHandler.handle(e);
                }
            });
        }
        super.start();
    }

    private void handleMysqlParserException(Throwable throwable) {
        if (throwable instanceof PositionNotFoundException) {
            this.logger.info("remove rds not found position, try download rds binlog!");
            this.executorService.execute(() -> {
                try {
                    this.logger.info("stop mysql parser!");
                    RdsBinlogEventParserProxy rdsBinlogEventParserProxy = this;
                    long serverId = rdsBinlogEventParserProxy.getServerId();
                    this.rdsLocalBinlogEventParser.setServerId(serverId);
                    rdsBinlogEventParserProxy.stop();
                }
                catch (Throwable e) {
                    this.logger.info("handle exception failed", e);
                }
                try {
                    this.logger.info("start rds mysql binlog parser!");
                    this.rdsLocalBinlogEventParser.start();
                }
                catch (Throwable e) {
                    this.logger.info("handle exception failed", e);
                    this.rdsLocalBinlogEventParser.stop();
                    RdsBinlogEventParserProxy rdsBinlogEventParserProxy = this;
                    rdsBinlogEventParserProxy.start();
                }
            });
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    public boolean isStart() {
        return super.isStart();
    }

    public void setRdsOpenApiUrl(String rdsOpenApiUrl) {
        this.rdsOpenApiUrl = rdsOpenApiUrl;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public void setSecretkey(String secretkey) {
        this.secretkey = secretkey;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setBatchFileSize(int batchFileSize) {
        this.batchFileSize = batchFileSize;
    }
}

