/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.util.Timeout;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonKeys;
import org.redisson.RedissonRemoteService;
import org.redisson.api.Entry;
import org.redisson.api.RFuture;
import org.redisson.api.RRemoteService;
import org.redisson.api.RTransferQueue;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.api.annotation.RRemoteAsync;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.ListDrainToDecoder;
import org.redisson.executor.RemotePromise;
import org.redisson.iterator.RedissonListIterator;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.remote.RemoteServiceRequest;

public class RedissonTransferQueue<V>
extends RedissonExpirable
implements RTransferQueue<V> {
    private static final Convertor<Object> CONVERTER = obj -> {
        if (obj != null) {
            RemoteServiceRequest request = (RemoteServiceRequest)obj;
            return request.getArgs()[0];
        }
        return null;
    };
    private static final RedisStrictCommand<Object> EVAL_REQUEST = new RedisStrictCommand<Object>("EVAL", CONVERTER);
    private static final RedisCommand EVAL_LIST = new RedisCommand<Object>("EVAL", new ObjectListReplayDecoder(), CONVERTER);
    private final String queueName;
    private final String mapName;
    private final TransferQueueServiceAsync service;
    private final RRemoteService remoteService;

    public RedissonTransferQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RRemoteService remoteService) {
        super(codec, commandExecutor, name);
        this.service = remoteService.get(TransferQueueServiceAsync.class, RemoteInvocationOptions.defaults().noAck());
        this.remoteService = remoteService;
        this.queueName = ((RedissonRemoteService)remoteService).getRequestQueueName(TransferQueueService.class);
        this.mapName = ((RedissonRemoteService)remoteService).getRequestTasksMapName(TransferQueueService.class);
    }

    public RedissonTransferQueue(CommandAsyncExecutor commandExecutor, String name, RRemoteService remoteService) {
        super(commandExecutor, name);
        this.service = remoteService.get(TransferQueueServiceAsync.class, RemoteInvocationOptions.defaults().noAck());
        this.remoteService = remoteService;
        this.queueName = ((RedissonRemoteService)remoteService).getRequestQueueName(TransferQueueService.class);
        this.mapName = ((RedissonRemoteService)remoteService).getRequestTasksMapName(TransferQueueService.class);
    }

    @Override
    public boolean tryTransfer(V v) {
        RemotePromise future = (RemotePromise)this.service.invoke(v).toCompletableFuture();
        boolean added = this.commandExecutor.get(future.getAddFuture());
        if (added && !future.cancel(false)) {
            this.commandExecutor.get(future);
            return true;
        }
        return false;
    }

    @Override
    public RFuture<Boolean> tryTransferAsync(V v) {
        RemotePromise future = (RemotePromise)this.service.invoke(v).toCompletableFuture();
        CompletionStage result = future.getAddFuture().thenCompose(added -> {
            if (!added.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return future.cancelAsync(false).thenCompose(canceled -> {
                if (canceled.booleanValue()) {
                    return CompletableFuture.completedFuture(false);
                }
                return future.thenApply(res -> true);
            });
        });
        return new CompletableFutureWrapper<Boolean>((CompletableFuture<Boolean>)result);
    }

    @Override
    public void transfer(V v) throws InterruptedException {
        RFuture<Void> future = this.service.invoke(v);
        this.commandExecutor.getInterrupted(future);
    }

    @Override
    public RFuture<Void> transferAsync(V v) {
        return this.service.invoke(v);
    }

    @Override
    public boolean tryTransfer(V v, long timeout, TimeUnit unit) throws InterruptedException {
        RemotePromise future = (RemotePromise)this.service.invoke(v).toCompletableFuture();
        long remainTime = unit.toMillis(timeout);
        long startTime = System.currentTimeMillis();
        CompletableFuture<Boolean> addFuture = future.getAddFuture().toCompletableFuture();
        try {
            addFuture.get(remainTime, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            if (!addFuture.cancel(false) && !future.cancel(false)) {
                this.commandExecutor.getInterrupted(future);
                return true;
            }
            return false;
        }
        remainTime -= System.currentTimeMillis() - startTime;
        try {
            future.toCompletableFuture().get(remainTime, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            if (!future.cancel(false)) {
                this.commandExecutor.getInterrupted(future);
                return true;
            }
            return false;
        }
        this.commandExecutor.getInterrupted(future);
        return true;
    }

    @Override
    public RFuture<Boolean> tryTransferAsync(V v, long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        RemotePromise future = (RemotePromise)this.service.invoke(v).toCompletableFuture();
        long remainTime = unit.toMillis(timeout);
        long startTime = System.currentTimeMillis();
        Timeout timeoutFuture = this.getServiceManager().newTimeout(tt -> {
            if (!future.getAddFuture().cancel(false)) {
                future.cancelAsync(false);
            }
        }, remainTime, TimeUnit.MILLISECONDS);
        future.whenComplete((res, exc) -> {
            if (future.isCancelled()) {
                result.complete(false);
                return;
            }
            timeoutFuture.cancel();
            if (exc != null) {
                result.completeExceptionally((Throwable)exc);
                return;
            }
            result.complete(true);
        });
        future.getAddFuture().whenComplete((added, e) -> {
            if (future.getAddFuture().isCancelled()) {
                result.complete(false);
                return;
            }
            if (e != null) {
                timeoutFuture.cancel();
                result.completeExceptionally((Throwable)e);
                return;
            }
            if (!added.booleanValue()) {
                timeoutFuture.cancel();
                result.complete(false);
                return;
            }
            Runnable task = () -> future.cancelAsync(false).whenComplete((canceled, ex) -> {
                if (ex != null) {
                    timeoutFuture.cancel();
                    result.completeExceptionally((Throwable)ex);
                    return;
                }
                if (canceled.booleanValue()) {
                    timeoutFuture.cancel();
                    result.complete(false);
                }
            });
            long time = remainTime - (System.currentTimeMillis() - startTime);
            if (time > 0L) {
                this.getServiceManager().newTimeout(tt -> task.run(), time, TimeUnit.MILLISECONDS);
            } else {
                task.run();
            }
        });
        return new CompletableFutureWrapper<Boolean>(result);
    }

    @Override
    public boolean hasWaitingConsumer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getWaitingConsumerCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(V v) {
        RemotePromise future = (RemotePromise)this.service.invoke(v).toCompletableFuture();
        return this.commandExecutor.get(future.getAddFuture());
    }

    @Override
    public RFuture<Boolean> addAsync(V v) {
        RemotePromise future = (RemotePromise)this.service.invoke(v).toCompletableFuture();
        return new CompletableFutureWrapper<Boolean>(future.getAddFuture());
    }

    @Override
    public boolean offer(V v) {
        return this.add(v);
    }

    @Override
    public V remove() {
        V value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V poll() {
        TransferQueueServiceImpl s = new TransferQueueServiceImpl();
        RFuture<Boolean> r = this.remoteService.tryExecuteAsync(TransferQueueService.class, s, (ExecutorService)ImmediateEventExecutor.INSTANCE, -1L, null);
        this.get(r);
        return (V)s.getResult();
    }

    @Override
    public RFuture<V> pollAsync() {
        TransferQueueServiceImpl s = new TransferQueueServiceImpl();
        RFuture<Boolean> future = this.remoteService.tryExecuteAsync(TransferQueueService.class, s, (ExecutorService)ImmediateEventExecutor.INSTANCE, -1L, null);
        CompletionStage<Object> f = future.thenApply(r -> s.getResult());
        return new CompletableFutureWrapper<Object>(f);
    }

    @Override
    public V element() {
        V value = this.peek();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V peek() {
        return this.get(this.peekAsync());
    }

    @Override
    public RFuture<V> peekAsync() {
        return this.commandExecutor.evalReadAsync(this.queueName, this.codec, EVAL_REQUEST, "local id = redis.call('lindex', KEYS[1], 0); if id ~= false then return redis.call('hget', KEYS[2], id); end return nil;", Arrays.asList(this.queueName, this.mapName), new Object[0]);
    }

    @Override
    public void put(V v) throws InterruptedException {
        this.add(v);
    }

    @Override
    public boolean offer(V v, long timeout, TimeUnit unit) throws InterruptedException {
        return this.add(v);
    }

    @Override
    public V take() throws InterruptedException {
        return this.poll(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public RFuture<V> takeAsync() {
        return this.pollAsync(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V poll(long timeout, TimeUnit unit) throws InterruptedException {
        TransferQueueServiceImpl s = new TransferQueueServiceImpl();
        this.remoteService.tryExecute(TransferQueueService.class, s, (ExecutorService)ImmediateEventExecutor.INSTANCE, timeout, unit);
        return (V)s.getResult();
    }

    @Override
    public RFuture<V> pollAsync(long timeout, TimeUnit unit) {
        TransferQueueServiceImpl s = new TransferQueueServiceImpl();
        RFuture<Boolean> future = this.remoteService.tryExecuteAsync(TransferQueueService.class, s, (ExecutorService)ImmediateEventExecutor.INSTANCE, timeout, unit);
        CompletionStage<Object> f = future.thenApply(r -> s.getResult());
        return new CompletableFutureWrapper<Object>(f);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        boolean all = true;
        for (Object obj : c) {
            all &= this.contains(obj);
        }
        return all;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return false;
        }
        boolean added = false;
        for (V obj : c) {
            added |= this.add(obj);
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        RedissonKeys keys = new RedissonKeys(this.commandExecutor);
        keys.delete(this.queueName, this.mapName);
    }

    public RFuture<Void> clearAsync() {
        RedissonKeys keys = new RedissonKeys(this.commandExecutor);
        CompletionStage<Void> f = keys.deleteAsync(this.queueName, this.mapName).thenApply(r -> null);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public int size() {
        return this.remoteService.getPendingInvocations(TransferQueueService.class);
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.remoteService.getPendingInvocationsAsync(TransferQueueService.class);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        ByteBuf encodedObject = this.encode(o);
        boolean result = this.stream().anyMatch(v -> {
            ByteBuf encodedValue = this.encode(v);
            boolean res = encodedValue.equals((Object)encodedObject);
            encodedValue.release();
            return res;
        });
        encodedObject.release();
        return result;
    }

    public RFuture<V> getValueAsync(int index) {
        return this.commandExecutor.evalReadAsync(this.queueName, this.codec, EVAL_REQUEST, "local id = redis.call('lindex', KEYS[1], ARGV[1]); if id ~= false then return redis.call('hget', KEYS[2], id); end return nil;", Arrays.asList(this.queueName, this.mapName), index);
    }

    @Override
    public Iterator<V> iterator() {
        return new RedissonListIterator<V>(0){

            @Override
            public V getValue(int index) {
                RFuture future = RedissonTransferQueue.this.getValueAsync(index);
                return RedissonTransferQueue.this.get(future);
            }

            @Override
            public V remove(int index) {
                if (index == 0) {
                    RFuture future = RedissonTransferQueue.this.commandExecutor.evalWriteNoRetryAsync(RedissonTransferQueue.this.queueName, RedissonTransferQueue.this.codec, EVAL_REQUEST, "local id = redis.call('lpop', KEYS[1]); if id ~= false then return redis.call('hget', KEYS[2], id); end return nil;", Arrays.asList(RedissonTransferQueue.this.queueName, RedissonTransferQueue.this.mapName), new Object[0]);
                    return RedissonTransferQueue.this.get(future);
                }
                RFuture future = RedissonTransferQueue.this.commandExecutor.evalWriteAsync(RedissonTransferQueue.this.queueName, RedissonTransferQueue.this.codec, EVAL_REQUEST, "local id = redis.call('lindex', KEYS[1], ARGV[1]); if id ~= false then redis.call('lset', KEYS[1], ARGV[1], 'DELETED_BY_REDISSON');redis.call('lrem', KEYS[1], 1, 'DELETED_BY_REDISSON');local val = redis.call('hget', KEYS[2], id); redis.call('hdel', KEYS[2], id); return val; end; return nil;", Arrays.asList(RedissonTransferQueue.this.queueName, RedissonTransferQueue.this.mapName), index);
                return RedissonTransferQueue.this.get(future);
            }

            @Override
            public void fastSet(int index, V value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(int index, V value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Object[] toArray() {
        List<V> list = this.readAll();
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<V> list = this.readAll();
        return list.toArray(a);
    }

    @Override
    public int drainTo(Collection<? super V> c) {
        return this.get(this.drainToAsync(c));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Object>("EVAL", new ListDrainToDecoder(c), CONVERTER), "local ids = redis.call('lrange', KEYS[1], 0, -1); local result = {};for i=1, #ids, 5000 do local vals = redis.call('hmget', KEYS[2], unpack(ids, i, math.min(i+4999, #ids))); for k,v in ipairs(vals) do table.insert(result, v); end; end; redis.call('del', KEYS[1], KEYS[2]); return result", Arrays.asList(this.queueName, this.mapName), new Object[0]);
    }

    @Override
    public int drainTo(Collection<? super V> c, int maxElements) {
        if (maxElements <= 0) {
            return 0;
        }
        return this.get(this.drainToAsync(c, maxElements));
    }

    @Override
    public RFuture<Integer> drainToAsync(Collection<? super V> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, new RedisCommand<Object>("EVAL", new ListDrainToDecoder(c), CONVERTER), "local elemNum = math.min(ARGV[1], redis.call('llen', KEYS[1])) - 1;local ids = redis.call('lrange', KEYS[1], 0, elemNum); redis.call('ltrim', KEYS[1], elemNum + 1, -1); local result = {};for i=1, #ids, 5000 do local vals = redis.call('hmget', KEYS[2], unpack(ids, i, math.min(i+4999, #ids))); redis.call('hdel', KEYS[2], unpack(ids, i, math.min(i+4999, #ids)));for k,v in ipairs(vals) do table.insert(result, v); end; end; return result", Arrays.asList(this.queueName, this.mapName), maxElements);
    }

    @Override
    public List<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<List<V>> readAllAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, EVAL_LIST, "local ids = redis.call('lrange', KEYS[1], 0, -1); local result = {};for i=1, #ids, 5000 do local vals = redis.call('hmget', KEYS[2], unpack(ids, i, math.min(i+4999, #ids))); for k,v in ipairs(vals) do table.insert(result, v); end; end; return result;", Arrays.asList(this.queueName, this.mapName), new Object[0]);
    }

    @Override
    public V pollFromAny(long timeout, TimeUnit unit, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Entry<String, V> pollFromAnyWithName(Duration timeout, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Entry<String, V>> pollFromAnyWithNameAsync(Duration timeout, String ... queueNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<V>> pollFirstFromAny(Duration duration, int count, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<V>> pollLastFromAny(Duration duration, int count, String ... queueNames) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Map<String, List<V>>> pollFirstFromAnyAsync(Duration duration, int count, String ... queueNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Map<String, List<V>>> pollLastFromAnyAsync(Duration duration, int count, String ... queueNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public V takeLastAndOfferFirstTo(String queueName) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int subscribeOnElements(Consumer<V> consumer) {
        return this.getServiceManager().getElementsSubscribeService().subscribeOnElements(this::takeAsync, consumer);
    }

    @Override
    public int subscribeOnElements(Function<V, CompletionStage<Void>> consumer) {
        return this.getServiceManager().getElementsSubscribeService().subscribeOnElements(this::takeAsync, consumer);
    }

    @Override
    public void unsubscribe(int listenerId) {
        this.commandExecutor.getServiceManager().getElementsSubscribeService().unsubscribe(listenerId);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<V> poll(int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<V> pollFromAnyAsync(long timeout, TimeUnit unit, String ... queueNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<V> takeLastAndOfferFirstToAsync(String queueName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Void> putAsync(V value) {
        RemotePromise future = (RemotePromise)this.service.invoke(value).toCompletableFuture();
        CompletionStage f = future.getAddFuture().thenApply(r -> null);
        return new CompletableFutureWrapper<Void>((CompletableFuture<Void>)f);
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        return this.addAsync(e);
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<List<V>> pollAsync(int limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        throw new UnsupportedOperationException();
    }

    @RRemoteAsync(value=TransferQueueService.class)
    public static interface TransferQueueServiceAsync {
        public <V> RFuture<Void> invoke(V var1);
    }

    public static interface TransferQueueService {
        public <V> void invoke(V var1);
    }

    public static class TransferQueueServiceImpl
    implements TransferQueueService {
        private Object result;

        @Override
        public <V> void invoke(V value) {
            this.result = value;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

