/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldProxy;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.RedissonLiveObjectService;
import org.redisson.RedissonObject;
import org.redisson.api.RFuture;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.client.RedisException;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.liveobject.resolver.MapResolver;
import org.redisson.liveobject.resolver.NamingScheme;

public class LiveObjectInterceptor {
    private final CommandAsyncExecutor commandExecutor;
    private final Class<?> entityClass;
    private final NamingScheme namingScheme;
    private final RedissonLiveObjectService service;
    private final MapResolver mapResolver;

    public LiveObjectInterceptor(CommandAsyncExecutor commandExecutor, RedissonLiveObjectService service, Class<?> entityClass, MapResolver mapResolver) {
        this.service = service;
        this.mapResolver = mapResolver;
        this.commandExecutor = commandExecutor;
        this.entityClass = entityClass;
        this.namingScheme = commandExecutor.getObjectBuilder().getNamingScheme(entityClass);
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @AllArguments Object[] args, @This Object me, @FieldValue(value="liveObjectId") Object id, @FieldProxy(value="liveObjectId") Setter idSetter, @FieldProxy(value="liveObjectId") Getter idGetter, @FieldValue(value="liveObjectLiveMap") RMap<String, ?> map, @FieldProxy(value="liveObjectLiveMap") Setter mapSetter, @FieldProxy(value="liveObjectLiveMap") Getter mapGetter) throws Throwable {
        if ("setLiveObjectId".equals(method.getName())) {
            block13: {
                if (args[0].getClass().isArray()) {
                    throw new UnsupportedOperationException("RId value cannot be an array.");
                }
                if (idGetter.getValue() != null) {
                    this.mapResolver.remove(this.entityClass, idGetter.getValue());
                    String idKey = this.namingScheme.getName(this.entityClass, args[0]);
                    if (map != null) {
                        if (((RedissonObject)((Object)map)).getRawName().equals(idKey)) {
                            return map;
                        }
                        try {
                            map.rename(idKey);
                            idSetter.setValue(args[0]);
                            return null;
                        }
                        catch (RedisException e) {
                            if (e.getMessage() != null && e.getMessage().startsWith("ERR no such key")) break block13;
                            throw e;
                        }
                    }
                }
            }
            idSetter.setValue(args[0]);
            return null;
        }
        if ("getLiveObjectId".equals(method.getName())) {
            return id;
        }
        if ("delete".equals(method.getName())) {
            CommandBatchService ce = this.commandExecutor instanceof CommandBatchService ? (CommandBatchService)this.commandExecutor : new CommandBatchService(this.commandExecutor);
            Object idd = ((RLiveObject)me).getLiveObjectId();
            RFuture<Long> deleteFuture = this.service.delete(idd, me.getClass().getSuperclass(), this.namingScheme, ce);
            ce.execute();
            return (Long)this.commandExecutor.get(deleteFuture.toCompletableFuture()) > 0L;
        }
        if (map == null) {
            map = this.mapResolver.resolve(this.commandExecutor, this.entityClass, id, mapSetter, mapGetter);
        }
        if ("getLiveObjectLiveMap".equals(method.getName())) {
            return map;
        }
        try {
            return method.invoke(map, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static interface Getter {
        public Object getValue();
    }

    public static interface Setter {
        public void setValue(Object var1);
    }
}

