/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.atomic.AtomicReference;

public final class SpinLock {
    private final AtomicReference<Thread> acquired = new AtomicReference();
    private final int spinLimit = 7000;
    private int nestedLevel;

    private void lockInterruptibly() throws InterruptedException {
        int spins = 0;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.acquired.get() == Thread.currentThread()) {
                ++this.nestedLevel;
                return;
            }
            if (this.acquired.get() == null && this.acquired.compareAndSet(null, Thread.currentThread())) {
                this.nestedLevel = 1;
                return;
            }
            if (spins >= 7000) {
                Thread.yield();
                continue;
            }
            ++spins;
        }
    }

    private void unlock() {
        if (this.acquired.get() == Thread.currentThread()) {
            --this.nestedLevel;
            if (this.nestedLevel == 0) {
                this.acquired.set(null);
            }
        }
    }

    public void execute(Runnable r) throws InterruptedException {
        this.lockInterruptibly();
        try {
            r.run();
        }
        finally {
            this.unlock();
        }
    }
}

