/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.classloading;

import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.BootstrapPackage;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import java.io.InputStream;

public class DebugTransformerClassInjector
implements ClassInjector {
    private static final BootstrapPackage bootstrapPackage = new BootstrapPackage();

    @Override
    public <T> Class<? extends T> injectClass(ClassLoader classLoader, String className) {
        ClassLoader targetClassLoader = classLoader;
        if (bootstrapPackage.isBootstrapPackage(className)) {
            targetClassLoader = Object.class.getClassLoader();
        }
        try {
            return Class.forName(className, false, targetClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new PinpointException("ClassNo class " + className + " with classLoader " + classLoader, (Throwable)e);
        }
    }

    @Override
    public InputStream getResourceAsStream(ClassLoader classLoader, String internalName) {
        ClassLoader targetClassLoader = DebugTransformerClassInjector.getClassLoader(classLoader);
        targetClassLoader = this.filterBootstrapPackage(targetClassLoader, internalName);
        return targetClassLoader.getResourceAsStream(internalName);
    }

    private static ClassLoader getClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private ClassLoader filterBootstrapPackage(ClassLoader classLoader, String classPath) {
        if (bootstrapPackage.isBootstrapPackageByInternalName(classPath)) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

