/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender.grpc;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectJob;
import io.github.resilience4j.core.IntervalFunction;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class ExponentialBackoffReconnectJob
implements ReconnectJob {
    private static final AtomicIntegerFieldUpdater<ExponentialBackoffReconnectJob> ATTEMPT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ExponentialBackoffReconnectJob.class, "attempt");
    private volatile int attempt = 0;
    private final IntervalFunction intervalFunction;
    private final Runnable runnable;
    private volatile long lastInterval;

    public ExponentialBackoffReconnectJob(Runnable runnable) {
        this(runnable, TimeUnit.SECONDS.toMillis(3L), TimeUnit.SECONDS.toMillis(30L));
    }

    public ExponentialBackoffReconnectJob(Runnable runnable, long initialIntervalMillis, long maxIntervalMillis) {
        this.runnable = Objects.requireNonNull(runnable, "runnable");
        this.intervalFunction = IntervalFunction.ofExponentialRandomBackoff((long)initialIntervalMillis, (double)1.2, (double)0.3, (long)maxIntervalMillis);
        this.lastInterval = initialIntervalMillis;
    }

    @Override
    public final void resetInterval() {
        ATTEMPT_UPDATER.set(this, 0);
    }

    @Override
    public long nextInterval() {
        long interval;
        int attempt = ATTEMPT_UPDATER.incrementAndGet(this);
        this.lastInterval = interval = ((Long)this.intervalFunction.apply((Object)attempt)).longValue();
        return interval;
    }

    @VisibleForTesting
    int getAttempt() {
        return this.attempt;
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    public String toString() {
        return "ExponentialBackoffReconnectJob{attempt=" + this.attempt + ", lastInterval=" + this.lastInterval + "ms, runnable=" + this.runnable + '}';
    }
}

