/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.CloseableClient;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Observers;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.LeaseGrantRequest;
import io.etcd.jetcd.api.LeaseGrpc;
import io.etcd.jetcd.api.LeaseKeepAliveRequest;
import io.etcd.jetcd.api.LeaseKeepAliveResponse;
import io.etcd.jetcd.api.LeaseRevokeRequest;
import io.etcd.jetcd.api.LeaseTimeToLiveRequest;
import io.etcd.jetcd.common.exception.ClosedClientException;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.lease.LeaseRevokeResponse;
import io.etcd.jetcd.lease.LeaseTimeToLiveResponse;
import io.etcd.jetcd.options.LeaseOption;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LeaseImpl
implements Lease {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseImpl.class);
    private static final int FIRST_KEEPALIVE_TIMEOUT_MS = 5000;
    private final ClientConnectionManager connectionManager;
    private final LeaseGrpc.LeaseFutureStub stub;
    private final LeaseGrpc.LeaseStub leaseStub;
    private final Map<Long, KeepAlive> keepAlives;
    private final ListeningScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<?> keepAliveFuture;
    private ScheduledFuture<?> deadlineFuture;
    private StreamObserver<LeaseKeepAliveRequest> keepAliveRequestObserver;
    private StreamObserver<LeaseKeepAliveResponse> keepAliveResponseObserver;
    private volatile boolean hasKeepAliveServiceStarted;
    private volatile boolean closed;

    LeaseImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(LeaseGrpc::newFutureStub);
        this.leaseStub = connectionManager.newStub(LeaseGrpc::newStub);
        this.keepAlives = new ConcurrentHashMap<Long, KeepAlive>();
        this.scheduledExecutorService = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(2));
    }

    @Override
    public CompletableFuture<LeaseGrantResponse> grant(long ttl) {
        LeaseGrantRequest leaseGrantRequest = LeaseGrantRequest.newBuilder().setTTL(ttl).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.leaseGrant(leaseGrantRequest), LeaseGrantResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<LeaseRevokeResponse> revoke(long leaseId) {
        LeaseRevokeRequest leaseRevokeRequest = LeaseRevokeRequest.newBuilder().setID(leaseId).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.leaseRevoke(leaseRevokeRequest), LeaseRevokeResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public synchronized CloseableClient keepAlive(long leaseId, final StreamObserver<io.etcd.jetcd.lease.LeaseKeepAliveResponse> observer) {
        if (this.closed) {
            throw EtcdExceptionFactory.newClosedLeaseClientException();
        }
        final KeepAlive keepAlive = this.keepAlives.computeIfAbsent(leaseId, key -> new KeepAlive(leaseId));
        keepAlive.addObserver(observer);
        if (!this.hasKeepAliveServiceStarted) {
            this.hasKeepAliveServiceStarted = true;
            this.start();
        }
        return new CloseableClient(){

            @Override
            public void close() {
                keepAlive.removeObserver((StreamObserver<io.etcd.jetcd.lease.LeaseKeepAliveResponse>)observer);
            }
        };
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (!this.hasKeepAliveServiceStarted) {
            return;
        }
        this.keepAliveFuture.cancel(true);
        this.deadlineFuture.cancel(true);
        this.keepAliveRequestObserver.onCompleted();
        this.keepAliveResponseObserver.onCompleted();
        this.scheduledExecutorService.shutdownNow();
        ClosedClientException errResp = EtcdExceptionFactory.newClosedLeaseClientException();
        this.keepAlives.forEach((k, v) -> v.onError(errResp));
        this.keepAlives.clear();
    }

    private synchronized void removeKeepAlive(long leaseId) {
        this.keepAlives.remove(leaseId);
    }

    private void start() {
        this.sendKeepAliveExecutor();
        this.deadLineExecutor();
    }

    private void reset() {
        this.keepAliveFuture.cancel(true);
        this.keepAliveRequestObserver.onCompleted();
        this.keepAliveResponseObserver.onCompleted();
        this.sendKeepAliveExecutor();
    }

    private void sendKeepAliveExecutor() {
        this.keepAliveResponseObserver = Observers.observer(response -> this.processKeepAliveResponse((LeaseKeepAliveResponse)response), error -> this.processOnError());
        this.keepAliveRequestObserver = this.leaseStub.leaseKeepAlive(this.keepAliveResponseObserver);
        this.keepAliveFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> this.keepAlives.entrySet().stream().filter(entry -> ((KeepAlive)entry.getValue()).getNextKeepAlive() < System.currentTimeMillis()).map(Map.Entry::getKey).map(leaseId -> LeaseKeepAliveRequest.newBuilder().setID((long)leaseId).build()).forEach(arg_0 -> this.keepAliveRequestObserver.onNext(arg_0)), 0L, 500L, TimeUnit.MILLISECONDS);
    }

    private synchronized void processOnError() {
        if (this.closed) {
            return;
        }
        Util.addOnFailureLoggingCallback(this.connectionManager.getExecutorService(), this.scheduledExecutorService.schedule(() -> this.reset(), 500L, TimeUnit.MILLISECONDS), LOG, "scheduled reset failed");
    }

    private synchronized void processKeepAliveResponse(LeaseKeepAliveResponse leaseKeepAliveResponse) {
        if (this.closed) {
            return;
        }
        long leaseID = leaseKeepAliveResponse.getID();
        long ttl = leaseKeepAliveResponse.getTTL();
        KeepAlive ka = this.keepAlives.get(leaseID);
        if (ka == null) {
            return;
        }
        if (ttl > 0L) {
            long nextKeepAlive = System.currentTimeMillis() + ttl * 1000L / 3L;
            ka.setNextKeepAlive(nextKeepAlive);
            ka.setDeadLine(System.currentTimeMillis() + ttl * 1000L);
            ka.onNext(leaseKeepAliveResponse);
        } else {
            this.removeKeepAlive(leaseID);
            ka.onError(EtcdExceptionFactory.newEtcdException(ErrorCode.NOT_FOUND, "etcdserver: requested lease not found"));
        }
    }

    private void deadLineExecutor() {
        this.deadlineFuture = this.scheduledExecutorService.scheduleAtFixedRate(() -> {
            long now = System.currentTimeMillis();
            this.keepAlives.values().removeIf(ka -> {
                if (ka.getDeadLine() < now) {
                    ka.onCompleted();
                    return true;
                }
                return false;
            });
        }, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public CompletableFuture<io.etcd.jetcd.lease.LeaseKeepAliveResponse> keepAliveOnce(long leaseId) {
        CompletableFuture future = new CompletableFuture();
        StreamObserver requestObserver = Observers.observe(this.leaseStub::leaseKeepAlive, response -> future.complete(new io.etcd.jetcd.lease.LeaseKeepAliveResponse((LeaseKeepAliveResponse)response)), throwable -> future.completeExceptionally(EtcdExceptionFactory.toEtcdException(throwable)));
        CompletionStage answer = future.whenCompleteAsync((val, throwable) -> requestObserver.onCompleted(), (Executor)this.connectionManager.getExecutorService());
        requestObserver.onNext((Object)LeaseKeepAliveRequest.newBuilder().setID(leaseId).build());
        return answer;
    }

    @Override
    public CompletableFuture<LeaseTimeToLiveResponse> timeToLive(long leaseId, LeaseOption option) {
        Preconditions.checkNotNull((Object)option, (Object)"LeaseOption should not be null");
        LeaseTimeToLiveRequest leaseTimeToLiveRequest = LeaseTimeToLiveRequest.newBuilder().setID(leaseId).setKeys(option.isAttachedKeys()).build();
        return Util.toCompletableFutureWithRetry(() -> this.stub.leaseTimeToLive(leaseTimeToLiveRequest), LeaseTimeToLiveResponse::new, this.connectionManager.getExecutorService());
    }

    private final class KeepAlive
    implements StreamObserver<LeaseKeepAliveResponse> {
        private final List<StreamObserver<io.etcd.jetcd.lease.LeaseKeepAliveResponse>> observers;
        private final long leaseId;
        private long deadLine;
        private long nextKeepAlive = System.currentTimeMillis();

        public KeepAlive(long leaseId) {
            this.deadLine = this.nextKeepAlive + 5000L;
            this.observers = new CopyOnWriteArrayList<StreamObserver<io.etcd.jetcd.lease.LeaseKeepAliveResponse>>();
            this.leaseId = leaseId;
        }

        public long getDeadLine() {
            return this.deadLine;
        }

        public void setDeadLine(long deadLine) {
            this.deadLine = deadLine;
        }

        public void addObserver(StreamObserver<io.etcd.jetcd.lease.LeaseKeepAliveResponse> observer) {
            this.observers.add(observer);
        }

        public void removeObserver(StreamObserver<io.etcd.jetcd.lease.LeaseKeepAliveResponse> listener) {
            this.observers.remove(listener);
            if (this.observers.isEmpty()) {
                LeaseImpl.this.removeKeepAlive(this.leaseId);
            }
        }

        public long getNextKeepAlive() {
            return this.nextKeepAlive;
        }

        public void setNextKeepAlive(long nextKeepAlive) {
            this.nextKeepAlive = nextKeepAlive;
        }

        public void onNext(LeaseKeepAliveResponse response) {
            for (StreamObserver<io.etcd.jetcd.lease.LeaseKeepAliveResponse> observer : this.observers) {
                observer.onNext((Object)new io.etcd.jetcd.lease.LeaseKeepAliveResponse(response));
            }
        }

        public void onError(Throwable throwable) {
            for (StreamObserver<io.etcd.jetcd.lease.LeaseKeepAliveResponse> observer : this.observers) {
                observer.onError((Throwable)EtcdExceptionFactory.toEtcdException(throwable));
            }
        }

        public void onCompleted() {
            this.observers.forEach(StreamObserver::onCompleted);
            this.observers.clear();
        }
    }
}

