/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="m_creditbureau_token")
public class CreditBureauToken
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    private static final Logger LOG = LoggerFactory.getLogger(CreditBureauToken.class);
    @Column(name="username")
    private String userName;
    @Column(name="token")
    private String accessToken;
    @Column(name="token_type")
    private String tokenType;
    @Column(name="expires_in")
    private String expiresIn;
    @Column(name="issued")
    private String issued;
    @Column(name="expiry_date")
    private LocalDate expires;
    static final long serialVersionUID = -2529669900080668847L;

    public static CreditBureauToken fromJson(JsonCommand command) {
        String userName = command.stringValueOfParameterNamed("userName");
        String accessToken = command.stringValueOfParameterNamed("access_token");
        String tokenType = command.stringValueOfParameterNamed("token_type");
        String expiresIn = command.stringValueOfParameterNamed("expires_in");
        String issued = command.stringValueOfParameterNamed(".issued");
        String expiry = command.stringValueOfParameterNamed(".expires");
        DateTimeFormatter dateformat = new DateTimeFormatterBuilder().appendPattern("EEE, dd MMM yyyy kk:mm:ss zzz").toFormatter();
        LocalDate expires = LocalDate.parse(expiry, dateformat);
        return new CreditBureauToken().setUserName(userName).setAccessToken(accessToken).setTokenType(tokenType).setExpiresIn(expiresIn).setIssued(issued).setExpires(expires);
    }

    @Generated
    public String getUserName() {
        return this._persistence_get_userName();
    }

    @Generated
    public String getAccessToken() {
        return this._persistence_get_accessToken();
    }

    @Generated
    public String getTokenType() {
        return this._persistence_get_tokenType();
    }

    @Generated
    public String getExpiresIn() {
        return this._persistence_get_expiresIn();
    }

    @Generated
    public String getIssued() {
        return this._persistence_get_issued();
    }

    @Generated
    public LocalDate getExpires() {
        return this._persistence_get_expires();
    }

    @Generated
    public CreditBureauToken setUserName(String userName) {
        this._persistence_set_userName(userName);
        return this;
    }

    @Generated
    public CreditBureauToken setAccessToken(String accessToken) {
        this._persistence_set_accessToken(accessToken);
        return this;
    }

    @Generated
    public CreditBureauToken setTokenType(String tokenType) {
        this._persistence_set_tokenType(tokenType);
        return this;
    }

    @Generated
    public CreditBureauToken setExpiresIn(String expiresIn) {
        this._persistence_set_expiresIn(expiresIn);
        return this;
    }

    @Generated
    public CreditBureauToken setIssued(String issued) {
        this._persistence_set_issued(issued);
        return this;
    }

    @Generated
    public CreditBureauToken setExpires(LocalDate expires) {
        this._persistence_set_expires(expires);
        return this;
    }

    @Generated
    public CreditBureauToken() {
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new CreditBureauToken();
    }

    public Object _persistence_get(String string) {
        if (string == "expiresIn") {
            return this.expiresIn;
        }
        if (string == "expires") {
            return this.expires;
        }
        if (string == "userName") {
            return this.userName;
        }
        if (string == "accessToken") {
            return this.accessToken;
        }
        if (string == "tokenType") {
            return this.tokenType;
        }
        if (string == "issued") {
            return this.issued;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "expiresIn") {
            this.expiresIn = (String)object;
            return;
        }
        if (string == "expires") {
            this.expires = (LocalDate)object;
            return;
        }
        if (string == "userName") {
            this.userName = (String)object;
            return;
        }
        if (string == "accessToken") {
            this.accessToken = (String)object;
            return;
        }
        if (string == "tokenType") {
            this.tokenType = (String)object;
            return;
        }
        if (string == "issued") {
            this.issued = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_expiresIn() {
        this._persistence_checkFetched("expiresIn");
        return this.expiresIn;
    }

    public void _persistence_set_expiresIn(String string) {
        this._persistence_checkFetchedForSet("expiresIn");
        this._persistence_propertyChange("expiresIn", (Object)this.expiresIn, (Object)string);
        this.expiresIn = string;
    }

    public LocalDate _persistence_get_expires() {
        this._persistence_checkFetched("expires");
        return this.expires;
    }

    public void _persistence_set_expires(LocalDate localDate) {
        this._persistence_checkFetchedForSet("expires");
        this._persistence_propertyChange("expires", (Object)this.expires, (Object)localDate);
        this.expires = localDate;
    }

    public String _persistence_get_userName() {
        this._persistence_checkFetched("userName");
        return this.userName;
    }

    public void _persistence_set_userName(String string) {
        this._persistence_checkFetchedForSet("userName");
        this._persistence_propertyChange("userName", (Object)this.userName, (Object)string);
        this.userName = string;
    }

    public String _persistence_get_accessToken() {
        this._persistence_checkFetched("accessToken");
        return this.accessToken;
    }

    public void _persistence_set_accessToken(String string) {
        this._persistence_checkFetchedForSet("accessToken");
        this._persistence_propertyChange("accessToken", (Object)this.accessToken, (Object)string);
        this.accessToken = string;
    }

    public String _persistence_get_tokenType() {
        this._persistence_checkFetched("tokenType");
        return this.tokenType;
    }

    public void _persistence_set_tokenType(String string) {
        this._persistence_checkFetchedForSet("tokenType");
        this._persistence_propertyChange("tokenType", (Object)this.tokenType, (Object)string);
        this.tokenType = string;
    }

    public String _persistence_get_issued() {
        this._persistence_checkFetched("issued");
        return this.issued;
    }

    public void _persistence_set_issued(String string) {
        this._persistence_checkFetchedForSet("issued");
        this._persistence_propertyChange("issued", (Object)this.issued, (Object)string);
        this.issued = string;
    }
}

