/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.domain;

import org.apache.fineract.organisation.monetary.domain.OrganisationCurrencyRepositoryWrapper;
import org.apache.fineract.portfolio.charge.exception.ChargeNotFoundException;
import org.apache.fineract.portfolio.client.domain.ClientCharge;
import org.apache.fineract.portfolio.client.domain.ClientChargeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientChargeRepositoryWrapper {
    private final ClientChargeRepository repository;
    private final OrganisationCurrencyRepositoryWrapper organisationCurrencyRepository;

    @Autowired
    public ClientChargeRepositoryWrapper(ClientChargeRepository repository, OrganisationCurrencyRepositoryWrapper organisationCurrencyRepositoryWrapper) {
        this.repository = repository;
        this.organisationCurrencyRepository = organisationCurrencyRepositoryWrapper;
    }

    public ClientCharge findOneWithNotFoundDetection(Long id) {
        ClientCharge clientCharge = (ClientCharge)this.repository.findById((Object)id).orElseThrow(() -> new ChargeNotFoundException(id));
        clientCharge.setCurrency(this.organisationCurrencyRepository.findOneWithNotFoundDetection(clientCharge.getCharge().getCurrencyCode()));
        return clientCharge;
    }

    public void save(ClientCharge clientCharge) {
        this.repository.save((Object)clientCharge);
    }

    public void saveAndFlush(ClientCharge clientCharge) {
        this.repository.saveAndFlush((Object)clientCharge);
    }

    public void delete(ClientCharge clientCharge) {
        this.repository.delete((Object)clientCharge);
        this.repository.flush();
    }
}

