/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.products.service.ShareProductReadPlatformService;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountData;
import org.apache.fineract.portfolio.shareaccounts.data.ShareAccountTransactionData;
import org.apache.fineract.portfolio.shareaccounts.domain.PurchasedSharesStatusType;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountDividendDetails;
import org.apache.fineract.portfolio.shareaccounts.service.ShareAccountReadPlatformService;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductData;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductDividendPayOutDetails;
import org.apache.fineract.portfolio.shareproducts.exception.ShareAccountsNotFoundException;

public class ShareProductDividendAssembler {
    private final ShareProductReadPlatformService shareProductReadPlatformService;
    private final ShareAccountReadPlatformService shareAccountReadPlatformService;

    public ShareProductDividendPayOutDetails calculateDividends(Long productId, BigDecimal amount, LocalDate dividendPeriodStartDate, LocalDate dividendPeriodEndDate) {
        HashMap numberOfSharesdaysPerAccount;
        long numberOfShareDays;
        ShareProductData product = (ShareProductData)this.shareProductReadPlatformService.retrieveOne(productId, false);
        MonetaryCurrency currency = new MonetaryCurrency(product.getCurrency().getCode(), product.getCurrency().getDecimalPlaces(), product.getCurrency().getInMultiplesOf());
        Collection shareAccountDatas = this.shareAccountReadPlatformService.retrieveAllShareAccountDataForDividends(productId, product.getAllowDividendCalculationForInactiveClients().booleanValue(), dividendPeriodStartDate);
        if (shareAccountDatas == null || shareAccountDatas.isEmpty()) {
            throw new ShareAccountsNotFoundException(product.getId());
        }
        ShareProductDividendPayOutDetails productDividendPayOutDetails = null;
        int minimumActivePeriod = 0;
        if (product.getMinimumActivePeriod() != null) {
            minimumActivePeriod = product.getMinimumActivePeriod();
        }
        if ((numberOfShareDays = this.calculateNumberOfShareDays(dividendPeriodEndDate, dividendPeriodStartDate, minimumActivePeriod, shareAccountDatas, numberOfSharesdaysPerAccount = new HashMap())) > 0L) {
            double amountPerShareDay = amount.doubleValue() / (double)numberOfShareDays;
            productDividendPayOutDetails = new ShareProductDividendPayOutDetails(productId, Money.of((MonetaryCurrency)currency, (BigDecimal)amount).getAmount(), dividendPeriodStartDate, dividendPeriodEndDate);
            for (ShareAccountData accountData : shareAccountDatas) {
                long numberOfShareDaysPerAccount = (Long)numberOfSharesdaysPerAccount.get(accountData.getId());
                double amountForAccount = (double)numberOfShareDaysPerAccount * amountPerShareDay;
                Money accountAmount = Money.of((MonetaryCurrency)currency, (BigDecimal)BigDecimal.valueOf(amountForAccount));
                ShareAccountDividendDetails dividendDetails = new ShareAccountDividendDetails(accountData.getId(), accountAmount.getAmount(), productDividendPayOutDetails);
                productDividendPayOutDetails.getAccountDividendDetails().add(dividendDetails);
            }
        }
        return productDividendPayOutDetails;
    }

    private long calculateNumberOfShareDays(LocalDate postingDate, LocalDate lastDividendPostDate, int minimumActivePeriod, Collection<ShareAccountData> shareAccountDatas, Map<Long, Long> numberOfSharesdaysPerAccount) {
        long numberOfShareDays = 0L;
        for (ShareAccountData accountData : shareAccountDatas) {
            long numberOfShareDaysPerAccount = 0L;
            Collection purchasedShares = accountData.getPurchasedShares();
            long numberOfShares = 0L;
            LocalDate lastDividendAppliedDate = null;
            for (ShareAccountTransactionData purchasedSharesData : purchasedShares) {
                PurchasedSharesStatusType status = PurchasedSharesStatusType.fromInt((Integer)((Long)purchasedSharesData.getStatus().getId()).intValue());
                PurchasedSharesStatusType type = PurchasedSharesStatusType.fromInt((Integer)((Long)purchasedSharesData.getType().getId()).intValue());
                if (!status.isApproved() || type.isChargePayment()) continue;
                LocalDate shareStartDate = purchasedSharesData.getPurchasedDate();
                if (DateUtils.isBefore((LocalDate)shareStartDate, (LocalDate)lastDividendPostDate)) {
                    shareStartDate = lastDividendPostDate;
                }
                int numberOfPurchseDays = DateUtils.getExactDifferenceInDays((LocalDate)shareStartDate, (LocalDate)postingDate);
                if (type.isPurchased() && numberOfPurchseDays < minimumActivePeriod) continue;
                if (lastDividendAppliedDate != null) {
                    numberOfShareDaysPerAccount += (long)DateUtils.getExactDifferenceInDays((LocalDate)lastDividendAppliedDate, (LocalDate)shareStartDate) * numberOfShares;
                }
                lastDividendAppliedDate = shareStartDate;
                if (type.isPurchased()) {
                    numberOfShares += purchasedSharesData.getNumberOfShares().longValue();
                    continue;
                }
                numberOfShares -= purchasedSharesData.getNumberOfShares().longValue();
            }
            if (lastDividendAppliedDate != null) {
                numberOfShareDaysPerAccount += (long)DateUtils.getExactDifferenceInDays(lastDividendAppliedDate, (LocalDate)postingDate) * numberOfShares;
            }
            numberOfShareDays += numberOfShareDaysPerAccount;
            numberOfSharesdaysPerAccount.put(accountData.getId(), numberOfShareDaysPerAccount);
        }
        return numberOfShareDays;
    }

    @Generated
    public ShareProductDividendAssembler(ShareProductReadPlatformService shareProductReadPlatformService, ShareAccountReadPlatformService shareAccountReadPlatformService) {
        this.shareProductReadPlatformService = shareProductReadPlatformService;
        this.shareAccountReadPlatformService = shareAccountReadPlatformService;
    }
}

