/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine.dfa;

import java.util.Random;
import org.apache.flink.streaming.examples.statemachine.dfa.EventTypeAndState;
import org.apache.flink.streaming.examples.statemachine.dfa.Transition;
import org.apache.flink.streaming.examples.statemachine.event.EventType;

public final class State
extends Enum<State> {
    public static final /* enum */ State Terminal = new State(new Transition[0]);
    public static final /* enum */ State InvalidTransition = new State(new Transition[0]);
    public static final /* enum */ State Z = new State(new Transition(EventType.g, Terminal, 1.0f));
    public static final /* enum */ State Y = new State(new Transition(EventType.e, Z, 1.0f));
    public static final /* enum */ State X = new State(new Transition(EventType.b, Y, 0.2f), new Transition(EventType.d, Z, 0.8f));
    public static final /* enum */ State W = new State(new Transition(EventType.b, Y, 1.0f));
    public static final /* enum */ State Initial = new State(new Transition(EventType.a, W, 0.6f), new Transition(EventType.c, X, 0.4f));
    private final Transition[] transitions;
    private static final /* synthetic */ State[] $VALUES;

    public static State[] values() {
        return (State[])$VALUES.clone();
    }

    public static State valueOf(String name) {
        return Enum.valueOf(State.class, name);
    }

    private State(Transition ... transitions) {
        this.transitions = transitions;
    }

    public boolean isTerminal() {
        return this.transitions.length == 0;
    }

    public State transition(EventType evt) {
        for (Transition t : this.transitions) {
            if (t.eventType() != evt) continue;
            return t.targetState();
        }
        return InvalidTransition;
    }

    public EventTypeAndState randomTransition(Random rnd) {
        if (this.isTerminal()) {
            throw new RuntimeException("Cannot transition from state " + this.name());
        }
        float p = rnd.nextFloat();
        float mass = 0.0f;
        Transition transition = null;
        for (Transition t : this.transitions) {
            if (!(p <= (mass += t.prob()))) continue;
            transition = t;
            break;
        }
        assert (transition != null);
        return new EventTypeAndState(transition.eventType(), transition.targetState());
    }

    public EventType randomInvalidTransition(Random rnd) {
        EventType candidate;
        while (this.transition(candidate = EventType.values()[rnd.nextInt(EventType.values().length)]) != InvalidTransition) {
        }
        return candidate;
    }

    static {
        $VALUES = new State[]{Terminal, InvalidTransition, Z, Y, X, W, Initial};
    }
}

