/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.Serializable;
import java.util.BitSet;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedNormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.SortMergeFullOuterJoinIterator;
import org.apache.flink.table.runtime.operators.join.SortMergeInnerJoinIterator;
import org.apache.flink.table.runtime.operators.join.SortMergeOneSideOuterJoinIterator;
import org.apache.flink.table.runtime.operators.sort.BinaryExternalSorter;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.LazyMemorySegmentPool;
import org.apache.flink.table.runtime.util.ResettableExternalBuffer;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;

public class SortMergeJoinFunction
implements Serializable {
    private final double externalBufferMemRatio;
    private final FlinkJoinType type;
    private final boolean leftIsSmaller;
    private final boolean[] filterNulls;
    private final int maxNumFileHandles;
    private final boolean compressionEnabled;
    private final int compressionBlockSize;
    private final boolean asyncMergeEnabled;
    private GeneratedJoinCondition condFuncCode;
    private GeneratedProjection projectionCode1;
    private GeneratedProjection projectionCode2;
    private GeneratedNormalizedKeyComputer computer1;
    private GeneratedRecordComparator comparator1;
    private GeneratedNormalizedKeyComputer computer2;
    private GeneratedRecordComparator comparator2;
    private GeneratedRecordComparator genKeyComparator;
    private transient StreamTask<?, ?> taskContainer;
    private transient long externalBufferMemory;
    private transient MemoryManager memManager;
    private transient IOManager ioManager;
    private transient BinaryRowDataSerializer serializer1;
    private transient BinaryRowDataSerializer serializer2;
    private transient BinaryExternalSorter sorter1;
    private transient BinaryExternalSorter sorter2;
    private transient Collector<RowData> collector;
    private transient boolean[] isFinished;
    private transient JoinCondition condFunc;
    private transient RecordComparator keyComparator;
    private transient Projection<RowData, BinaryRowData> projection1;
    private transient Projection<RowData, BinaryRowData> projection2;
    private transient RowData leftNullRow;
    private transient RowData rightNullRow;
    private transient JoinedRowData joinedRow;

    public SortMergeJoinFunction(double externalBufferMemRatio, FlinkJoinType type, boolean leftIsSmaller, int maxNumFileHandles, boolean compressionEnabled, int compressionBlockSize, boolean asyncMergeEnabled, GeneratedJoinCondition condFuncCode, GeneratedProjection projectionCode1, GeneratedProjection projectionCode2, GeneratedNormalizedKeyComputer computer1, GeneratedRecordComparator comparator1, GeneratedNormalizedKeyComputer computer2, GeneratedRecordComparator comparator2, GeneratedRecordComparator genKeyComparator, boolean[] filterNulls) {
        this.externalBufferMemRatio = externalBufferMemRatio;
        this.type = type;
        this.leftIsSmaller = leftIsSmaller;
        this.maxNumFileHandles = maxNumFileHandles;
        this.compressionEnabled = compressionEnabled;
        this.compressionBlockSize = compressionBlockSize;
        this.asyncMergeEnabled = asyncMergeEnabled;
        this.condFuncCode = condFuncCode;
        this.projectionCode1 = projectionCode1;
        this.projectionCode2 = projectionCode2;
        this.computer1 = (GeneratedNormalizedKeyComputer)Preconditions.checkNotNull((Object)computer1);
        this.comparator1 = (GeneratedRecordComparator)Preconditions.checkNotNull((Object)comparator1);
        this.computer2 = (GeneratedNormalizedKeyComputer)Preconditions.checkNotNull((Object)computer2);
        this.comparator2 = (GeneratedRecordComparator)Preconditions.checkNotNull((Object)comparator2);
        this.genKeyComparator = (GeneratedRecordComparator)Preconditions.checkNotNull((Object)genKeyComparator);
        this.filterNulls = filterNulls;
    }

    public void open(boolean adaptiveHashJoin, StreamTask<?, ?> taskContainer, StreamConfig operatorConfig, StreamRecordCollector collector, long totalMemory, RuntimeContext runtimeContext, OperatorMetricGroup operatorMetricGroup) throws Exception {
        this.taskContainer = taskContainer;
        this.isFinished = new boolean[]{false, false};
        this.collector = collector;
        ClassLoader cl = taskContainer.getUserCodeClassLoader();
        AbstractRowDataSerializer inputSerializer1 = this.getInputSerializer1(adaptiveHashJoin, this.leftIsSmaller, cl, operatorConfig);
        this.serializer1 = new BinaryRowDataSerializer(inputSerializer1.getArity());
        AbstractRowDataSerializer inputSerializer2 = this.getInputSerializer2(adaptiveHashJoin, this.leftIsSmaller, cl, operatorConfig);
        this.serializer2 = new BinaryRowDataSerializer(inputSerializer2.getArity());
        this.memManager = taskContainer.getEnvironment().getMemoryManager();
        this.ioManager = taskContainer.getEnvironment().getIOManager();
        this.externalBufferMemory = (long)((double)totalMemory * this.externalBufferMemRatio);
        this.externalBufferMemory = Math.max(this.externalBufferMemory, 327680L);
        long totalSortMem = totalMemory - (this.type.equals((Object)FlinkJoinType.FULL) ? this.externalBufferMemory * 2L : this.externalBufferMemory);
        if (totalSortMem < 0L) {
            throw new TableException("Memory size is too small: " + totalMemory + ", please increase manage memory of task manager.");
        }
        this.sorter1 = new BinaryExternalSorter(taskContainer, this.memManager, totalSortMem / 2L, this.ioManager, inputSerializer1, this.serializer1, (NormalizedKeyComputer)this.computer1.newInstance(cl), (RecordComparator)this.comparator1.newInstance(cl), this.maxNumFileHandles, this.compressionEnabled, this.compressionBlockSize, this.asyncMergeEnabled);
        this.sorter1.startThreads();
        this.sorter2 = new BinaryExternalSorter(taskContainer, this.memManager, totalSortMem / 2L, this.ioManager, inputSerializer2, this.serializer2, (NormalizedKeyComputer)this.computer2.newInstance(cl), (RecordComparator)this.comparator2.newInstance(cl), this.maxNumFileHandles, this.compressionEnabled, this.compressionBlockSize, this.asyncMergeEnabled);
        this.sorter2.startThreads();
        this.keyComparator = (RecordComparator)this.genKeyComparator.newInstance(cl);
        this.condFunc = (JoinCondition)this.condFuncCode.newInstance(cl);
        this.condFunc.setRuntimeContext(runtimeContext);
        this.condFunc.open(DefaultOpenContext.INSTANCE);
        this.projection1 = (Projection)this.projectionCode1.newInstance(cl);
        this.projection2 = (Projection)this.projectionCode2.newInstance(cl);
        this.leftNullRow = new GenericRowData(this.serializer1.getArity());
        this.rightNullRow = new GenericRowData(this.serializer2.getArity());
        this.joinedRow = new JoinedRowData();
        this.condFuncCode = null;
        this.computer1 = null;
        this.comparator1 = null;
        this.computer2 = null;
        this.comparator2 = null;
        this.projectionCode1 = null;
        this.projectionCode2 = null;
        this.genKeyComparator = null;
        operatorMetricGroup.gauge("memoryUsedSizeInBytes", () -> this.sorter1.getUsedMemoryInBytes() + this.sorter2.getUsedMemoryInBytes());
        operatorMetricGroup.gauge("numSpillFiles", () -> this.sorter1.getNumSpillFiles() + this.sorter2.getNumSpillFiles());
        operatorMetricGroup.gauge("spillInBytes", () -> this.sorter1.getSpillInBytes() + this.sorter2.getSpillInBytes());
    }

    private AbstractRowDataSerializer getInputSerializer1(boolean adaptiveHashJoin, boolean leftIsSmaller, ClassLoader cl, StreamConfig operatorConfig) {
        if (adaptiveHashJoin && !leftIsSmaller) {
            return (AbstractRowDataSerializer)operatorConfig.getTypeSerializerIn2(cl);
        }
        return (AbstractRowDataSerializer)operatorConfig.getTypeSerializerIn1(cl);
    }

    private AbstractRowDataSerializer getInputSerializer2(boolean adaptiveHashJoin, boolean leftIsSmaller, ClassLoader cl, StreamConfig operatorConfig) {
        if (adaptiveHashJoin && !leftIsSmaller) {
            return (AbstractRowDataSerializer)operatorConfig.getTypeSerializerIn1(cl);
        }
        return (AbstractRowDataSerializer)operatorConfig.getTypeSerializerIn2(cl);
    }

    public void processElement1(RowData element) throws Exception {
        this.sorter1.write(element);
    }

    public void processElement2(RowData element) throws Exception {
        this.sorter2.write(element);
    }

    public void endInput(int inputId) throws Exception {
        this.isFinished[inputId - 1] = true;
        if (this.isAllFinished()) {
            this.doSortMergeJoin();
        }
    }

    private void doSortMergeJoin() throws Exception {
        MutableObjectIterator<BinaryRowData> iterator1 = this.sorter1.getIterator();
        MutableObjectIterator<BinaryRowData> iterator2 = this.sorter2.getIterator();
        if (this.type.equals((Object)FlinkJoinType.INNER)) {
            if (!this.leftIsSmaller) {
                try (SortMergeInnerJoinIterator joinIterator = new SortMergeInnerJoinIterator(this.serializer1, this.serializer2, (Projection)this.projection1, (Projection)this.projection2, this.keyComparator, (MutableObjectIterator<RowData>)iterator1, iterator2, this.newBuffer(this.serializer2), this.filterNulls);){
                    this.innerJoin(joinIterator, false);
                }
            } else {
                try (SortMergeInnerJoinIterator joinIterator = new SortMergeInnerJoinIterator(this.serializer2, this.serializer1, (Projection)this.projection2, (Projection)this.projection1, this.keyComparator, (MutableObjectIterator<RowData>)iterator2, iterator1, this.newBuffer(this.serializer1), this.filterNulls);){
                    this.innerJoin(joinIterator, true);
                }
            }
        } else {
            if (this.type.equals((Object)FlinkJoinType.LEFT)) {
                try (SortMergeOneSideOuterJoinIterator joinIterator = new SortMergeOneSideOuterJoinIterator(this.serializer1, this.serializer2, this.projection1, this.projection2, this.keyComparator, iterator1, iterator2, this.newBuffer(this.serializer2), this.filterNulls);){
                    this.oneSideOuterJoin(joinIterator, false, this.rightNullRow);
                }
            }
            if (this.type.equals((Object)FlinkJoinType.RIGHT)) {
                try (SortMergeOneSideOuterJoinIterator joinIterator = new SortMergeOneSideOuterJoinIterator(this.serializer2, this.serializer1, this.projection2, this.projection1, this.keyComparator, iterator2, iterator1, this.newBuffer(this.serializer1), this.filterNulls);){
                    this.oneSideOuterJoin(joinIterator, true, this.leftNullRow);
                }
            }
            if (this.type.equals((Object)FlinkJoinType.FULL)) {
                try (SortMergeFullOuterJoinIterator fullOuterJoinIterator = new SortMergeFullOuterJoinIterator(this.serializer1, this.serializer2, this.projection1, this.projection2, this.keyComparator, iterator1, iterator2, this.newBuffer(this.serializer1), this.newBuffer(this.serializer2), this.filterNulls);){
                    this.fullOuterJoin(fullOuterJoinIterator);
                }
            }
            if (this.type.equals((Object)FlinkJoinType.SEMI)) {
                try (SortMergeInnerJoinIterator joinIterator = new SortMergeInnerJoinIterator(this.serializer1, this.serializer2, (Projection)this.projection1, (Projection)this.projection2, this.keyComparator, (MutableObjectIterator<RowData>)iterator1, iterator2, this.newBuffer(this.serializer2), this.filterNulls);){
                    while (joinIterator.nextInnerJoin()) {
                        RowData probeRow = joinIterator.getProbeRow();
                        boolean matched = false;
                        try (ResettableExternalBuffer.BufferIterator iter = joinIterator.getMatchBuffer().newIterator();){
                            while (iter.advanceNext()) {
                                BinaryRowData row = iter.getRow();
                                if (!this.condFunc.apply(probeRow, (RowData)row)) continue;
                                matched = true;
                                break;
                            }
                        }
                        if (!matched) continue;
                        this.collector.collect((Object)probeRow);
                    }
                }
            }
            if (this.type.equals((Object)FlinkJoinType.ANTI)) {
                try (SortMergeOneSideOuterJoinIterator joinIterator = new SortMergeOneSideOuterJoinIterator(this.serializer1, this.serializer2, this.projection1, this.projection2, this.keyComparator, iterator1, iterator2, this.newBuffer(this.serializer2), this.filterNulls);){
                    while (joinIterator.nextOuterJoin()) {
                        RowData probeRow = joinIterator.getProbeRow();
                        ResettableExternalBuffer matchBuffer = joinIterator.getMatchBuffer();
                        boolean matched = false;
                        if (matchBuffer != null) {
                            try (ResettableExternalBuffer.BufferIterator iter = matchBuffer.newIterator();){
                                while (iter.advanceNext()) {
                                    BinaryRowData row = iter.getRow();
                                    if (!this.condFunc.apply(probeRow, (RowData)row)) continue;
                                    matched = true;
                                    break;
                                }
                            }
                        }
                        if (matched) continue;
                        this.collector.collect((Object)probeRow);
                    }
                }
            }
            throw new RuntimeException("Not support type: " + this.type);
        }
    }

    private void innerJoin(SortMergeInnerJoinIterator iterator, boolean reverseInvoke) throws Exception {
        while (iterator.nextInnerJoin()) {
            RowData probeRow = iterator.getProbeRow();
            ResettableExternalBuffer.BufferIterator iter = iterator.getMatchBuffer().newIterator();
            while (iter.advanceNext()) {
                BinaryRowData row = iter.getRow();
                this.joinWithCondition(probeRow, (RowData)row, reverseInvoke);
            }
            iter.close();
        }
    }

    private void oneSideOuterJoin(SortMergeOneSideOuterJoinIterator iterator, boolean reverseInvoke, RowData buildNullRow) throws Exception {
        while (iterator.nextOuterJoin()) {
            RowData probeRow = iterator.getProbeRow();
            boolean found = false;
            if (iterator.getMatchKey() != null) {
                ResettableExternalBuffer.BufferIterator iter = iterator.getMatchBuffer().newIterator();
                while (iter.advanceNext()) {
                    BinaryRowData row = iter.getRow();
                    found |= this.joinWithCondition(probeRow, (RowData)row, reverseInvoke);
                }
                iter.close();
            }
            if (found) continue;
            this.collect(probeRow, buildNullRow, reverseInvoke);
        }
    }

    private void fullOuterJoin(SortMergeFullOuterJoinIterator iterator) throws Exception {
        BitSet bitSet = new BitSet();
        while (iterator.nextOuterJoin()) {
            ResettableExternalBuffer.BufferIterator iter;
            bitSet.clear();
            BinaryRowData matchKey = iterator.getMatchKey();
            ResettableExternalBuffer buffer1 = iterator.getBuffer1();
            ResettableExternalBuffer buffer2 = iterator.getBuffer2();
            if (matchKey == null && buffer1.size() > 0) {
                iter = buffer1.newIterator();
                while (iter.advanceNext()) {
                    BinaryRowData row1 = iter.getRow();
                    this.collector.collect((Object)this.joinedRow.replace((RowData)row1, this.rightNullRow));
                }
                iter.close();
                continue;
            }
            if (matchKey == null && buffer2.size() > 0) {
                iter = buffer2.newIterator();
                while (iter.advanceNext()) {
                    BinaryRowData row2 = iter.getRow();
                    this.collector.collect((Object)this.joinedRow.replace(this.leftNullRow, (RowData)row2));
                }
                iter.close();
                continue;
            }
            if (matchKey != null) {
                ResettableExternalBuffer.BufferIterator iter1 = buffer1.newIterator();
                while (iter1.advanceNext()) {
                    BinaryRowData row1 = iter1.getRow();
                    boolean found = false;
                    int index = 0;
                    ResettableExternalBuffer.BufferIterator iter2 = buffer2.newIterator();
                    while (iter2.advanceNext()) {
                        BinaryRowData row2 = iter2.getRow();
                        if (this.condFunc.apply((RowData)row1, (RowData)row2)) {
                            this.collector.collect((Object)this.joinedRow.replace((RowData)row1, (RowData)row2));
                            found = true;
                            bitSet.set(index);
                        }
                        ++index;
                    }
                    iter2.close();
                    if (found) continue;
                    this.collector.collect((Object)this.joinedRow.replace((RowData)row1, this.rightNullRow));
                }
                iter1.close();
                int index = 0;
                ResettableExternalBuffer.BufferIterator iter2 = buffer2.newIterator();
                while (iter2.advanceNext()) {
                    BinaryRowData row2 = iter2.getRow();
                    if (!bitSet.get(index)) {
                        this.collector.collect((Object)this.joinedRow.replace(this.leftNullRow, (RowData)row2));
                    }
                    ++index;
                }
                iter2.close();
                continue;
            }
            throw new RuntimeException("There is a bug.");
        }
    }

    private boolean joinWithCondition(RowData row1, RowData row2, boolean reverseInvoke) throws Exception {
        if (reverseInvoke) {
            if (this.condFunc.apply(row2, row1)) {
                this.collector.collect((Object)this.joinedRow.replace(row2, row1));
                return true;
            }
        } else if (this.condFunc.apply(row1, row2)) {
            this.collector.collect((Object)this.joinedRow.replace(row1, row2));
            return true;
        }
        return false;
    }

    private void collect(RowData row1, RowData row2, boolean reverseInvoke) {
        if (reverseInvoke) {
            this.collector.collect((Object)this.joinedRow.replace(row2, row1));
        } else {
            this.collector.collect((Object)this.joinedRow.replace(row1, row2));
        }
    }

    private ResettableExternalBuffer newBuffer(BinaryRowDataSerializer serializer) {
        LazyMemorySegmentPool pool = new LazyMemorySegmentPool(this.taskContainer, this.memManager, (int)(this.externalBufferMemory / (long)this.memManager.getPageSize()));
        return new ResettableExternalBuffer(this.ioManager, pool, serializer, false);
    }

    private boolean isAllFinished() {
        return this.isFinished[0] && this.isFinished[1];
    }

    public void close() throws Exception {
        if (this.sorter1 != null) {
            this.sorter1.close();
        }
        if (this.sorter2 != null) {
            this.sorter2.close();
        }
        this.condFunc.close();
    }
}

