/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.proto.Requests;
import org.apache.calcite.avatica.proto.Responses;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import org.apache.flink.calcite.shaded.com.google.protobuf.ByteString;
import org.apache.flink.calcite.shaded.com.google.protobuf.CodedInputStream;
import org.apache.flink.calcite.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.flink.calcite.shaded.com.google.protobuf.Message;
import org.apache.flink.calcite.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.flink.calcite.shaded.com.google.protobuf.Parser;
import org.apache.flink.calcite.shaded.com.google.protobuf.TextFormat;
import org.apache.flink.calcite.shaded.com.google.protobuf.UnsafeByteOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufTranslationImpl
implements ProtobufTranslation {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufTranslationImpl.class);
    private static final Map<String, RequestTranslator> REQUEST_PARSERS;
    private static final Map<String, ResponseTranslator> RESPONSE_PARSERS;
    private static final Map<Class<?>, ByteString> MESSAGE_CLASSES;
    private final ThreadLocal<UnsynchronizedBuffer> threadLocalBuffer = new ThreadLocal<UnsynchronizedBuffer>(){

        @Override
        protected UnsynchronizedBuffer initialValue() {
            return new UnsynchronizedBuffer();
        }
    };

    private static List<Class<?>> getAllMessageClasses() {
        ArrayList messageClasses = new ArrayList();
        messageClasses.add(Requests.CatalogsRequest.class);
        messageClasses.add(Requests.CloseConnectionRequest.class);
        messageClasses.add(Requests.CloseStatementRequest.class);
        messageClasses.add(Requests.ColumnsRequest.class);
        messageClasses.add(Requests.CommitRequest.class);
        messageClasses.add(Requests.ConnectionSyncRequest.class);
        messageClasses.add(Requests.CreateStatementRequest.class);
        messageClasses.add(Requests.DatabasePropertyRequest.class);
        messageClasses.add(Requests.ExecuteRequest.class);
        messageClasses.add(Requests.FetchRequest.class);
        messageClasses.add(Requests.OpenConnectionRequest.class);
        messageClasses.add(Requests.PrepareAndExecuteRequest.class);
        messageClasses.add(Requests.PrepareRequest.class);
        messageClasses.add(Requests.RollbackRequest.class);
        messageClasses.add(Requests.SchemasRequest.class);
        messageClasses.add(Requests.SyncResultsRequest.class);
        messageClasses.add(Requests.TableTypesRequest.class);
        messageClasses.add(Requests.TablesRequest.class);
        messageClasses.add(Requests.TypeInfoRequest.class);
        messageClasses.add(Requests.PrepareAndExecuteBatchRequest.class);
        messageClasses.add(Requests.ExecuteBatchRequest.class);
        messageClasses.add(Responses.CloseConnectionResponse.class);
        messageClasses.add(Responses.CloseStatementResponse.class);
        messageClasses.add(Responses.CommitResponse.class);
        messageClasses.add(Responses.ConnectionSyncResponse.class);
        messageClasses.add(Responses.CreateStatementResponse.class);
        messageClasses.add(Responses.DatabasePropertyResponse.class);
        messageClasses.add(Responses.ErrorResponse.class);
        messageClasses.add(Responses.ExecuteResponse.class);
        messageClasses.add(Responses.FetchResponse.class);
        messageClasses.add(Responses.OpenConnectionResponse.class);
        messageClasses.add(Responses.PrepareResponse.class);
        messageClasses.add(Responses.ResultSetResponse.class);
        messageClasses.add(Responses.RollbackResponse.class);
        messageClasses.add(Responses.RpcMetadata.class);
        messageClasses.add(Responses.SyncResultsResponse.class);
        messageClasses.add(Responses.ExecuteBatchResponse.class);
        return messageClasses;
    }

    private static ByteString wrapClassName(Class<?> clz) {
        return UnsafeByteOperations.unsafeWrap((byte[])clz.getName().getBytes(StandardCharsets.UTF_8));
    }

    public static RequestTranslator getParserForRequest(String className) {
        if (null == className || className.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch parser for Request with " + (null == className ? "null" : "missing") + " class name");
        }
        RequestTranslator translator = REQUEST_PARSERS.get(className);
        if (null == translator) {
            throw new IllegalArgumentException("Cannot find request parser for " + className);
        }
        return translator;
    }

    public static ResponseTranslator getParserForResponse(String className) {
        if (null == className || className.isEmpty()) {
            throw new IllegalArgumentException("Cannot fetch parser for Response with " + (null == className ? "null" : "missing") + " class name");
        }
        ResponseTranslator translator = RESPONSE_PARSERS.get(className);
        if (null == translator) {
            throw new IllegalArgumentException("Cannot find response parser for " + className);
        }
        return translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serializeResponse(Service.Response response) throws IOException {
        UnsynchronizedBuffer out = this.threadLocalBuffer.get();
        try {
            Message responseMsg = response.serialize();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Serializing {} '{}'", (Object)responseMsg.getClass().getSimpleName(), (Object)TextFormat.shortDebugString((MessageOrBuilder)responseMsg));
            }
            this.serializeMessage(out, responseMsg);
            byte[] byArray = out.toArray();
            return byArray;
        }
        finally {
            out.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serializeRequest(Service.Request request) throws IOException {
        UnsynchronizedBuffer out = this.threadLocalBuffer.get();
        try {
            Message requestMsg = request.serialize();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Serializing {} '{}'", (Object)requestMsg.getClass().getSimpleName(), (Object)TextFormat.shortDebugString((MessageOrBuilder)requestMsg));
            }
            this.serializeMessage(out, requestMsg);
            byte[] byArray = out.toArray();
            return byArray;
        }
        finally {
            out.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeMessage(OutputStream out, Message msg) throws IOException {
        ByteString serializedMsg;
        UnsynchronizedBuffer buffer = this.threadLocalBuffer.get();
        try {
            msg.writeTo((OutputStream)buffer);
            serializedMsg = UnsafeByteOperations.unsafeWrap((byte[])buffer.toArray());
        }
        finally {
            buffer.reset();
        }
        Common.WireMessage wireMsg = Common.WireMessage.newBuilder().setNameBytes(this.getClassNameBytes(msg.getClass())).setWrappedMessage(serializedMsg).build();
        wireMsg.writeTo(out);
    }

    ByteString getClassNameBytes(Class<?> clz) {
        ByteString byteString = MESSAGE_CLASSES.get(clz);
        if (null == byteString) {
            throw new IllegalArgumentException("Missing ByteString for " + clz.getName());
        }
        return byteString;
    }

    @Override
    public Service.Request parseRequest(byte[] bytes) throws IOException {
        ByteString byteString = UnsafeByteOperations.unsafeWrap((byte[])bytes);
        CodedInputStream inputStream = byteString.newCodedInput();
        inputStream.enableAliasing(true);
        Common.WireMessage wireMsg = Common.WireMessage.parseFrom(inputStream);
        String serializedMessageClassName = wireMsg.getName();
        try {
            RequestTranslator translator = ProtobufTranslationImpl.getParserForRequest(serializedMessageClassName);
            return translator.transform(wireMsg.getWrappedMessage());
        }
        catch (RuntimeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to parse request message '{}'", (Object)TextFormat.shortDebugString((MessageOrBuilder)wireMsg));
            }
            throw e;
        }
    }

    @Override
    public Service.Response parseResponse(byte[] bytes) throws IOException {
        ByteString byteString = UnsafeByteOperations.unsafeWrap((byte[])bytes);
        CodedInputStream inputStream = byteString.newCodedInput();
        inputStream.enableAliasing(true);
        Common.WireMessage wireMsg = Common.WireMessage.parseFrom(inputStream);
        String serializedMessageClassName = wireMsg.getName();
        try {
            ResponseTranslator translator = ProtobufTranslationImpl.getParserForResponse(serializedMessageClassName);
            return translator.transform(wireMsg.getWrappedMessage());
        }
        catch (RuntimeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to parse response message '{}'", (Object)TextFormat.shortDebugString((MessageOrBuilder)wireMsg));
            }
            throw e;
        }
    }

    static {
        ConcurrentHashMap<String, RequestTranslator> reqParsers = new ConcurrentHashMap<String, RequestTranslator>();
        reqParsers.put(Requests.CatalogsRequest.class.getName(), new RequestTranslator(Requests.CatalogsRequest.parser(), new Service.CatalogsRequest()));
        reqParsers.put(Requests.OpenConnectionRequest.class.getName(), new RequestTranslator(Requests.OpenConnectionRequest.parser(), new Service.OpenConnectionRequest()));
        reqParsers.put(Requests.CloseConnectionRequest.class.getName(), new RequestTranslator(Requests.CloseConnectionRequest.parser(), new Service.CloseConnectionRequest()));
        reqParsers.put(Requests.CloseStatementRequest.class.getName(), new RequestTranslator(Requests.CloseStatementRequest.parser(), new Service.CloseStatementRequest()));
        reqParsers.put(Requests.ColumnsRequest.class.getName(), new RequestTranslator(Requests.ColumnsRequest.parser(), new Service.ColumnsRequest()));
        reqParsers.put(Requests.ConnectionSyncRequest.class.getName(), new RequestTranslator(Requests.ConnectionSyncRequest.parser(), new Service.ConnectionSyncRequest()));
        reqParsers.put(Requests.CreateStatementRequest.class.getName(), new RequestTranslator(Requests.CreateStatementRequest.parser(), new Service.CreateStatementRequest()));
        reqParsers.put(Requests.DatabasePropertyRequest.class.getName(), new RequestTranslator(Requests.DatabasePropertyRequest.parser(), new Service.DatabasePropertyRequest()));
        reqParsers.put(Requests.FetchRequest.class.getName(), new RequestTranslator(Requests.FetchRequest.parser(), new Service.FetchRequest()));
        reqParsers.put(Requests.PrepareAndExecuteRequest.class.getName(), new RequestTranslator(Requests.PrepareAndExecuteRequest.parser(), new Service.PrepareAndExecuteRequest()));
        reqParsers.put(Requests.PrepareRequest.class.getName(), new RequestTranslator(Requests.PrepareRequest.parser(), new Service.PrepareRequest()));
        reqParsers.put(Requests.SchemasRequest.class.getName(), new RequestTranslator(Requests.SchemasRequest.parser(), new Service.SchemasRequest()));
        reqParsers.put(Requests.TablesRequest.class.getName(), new RequestTranslator(Requests.TablesRequest.parser(), new Service.TablesRequest()));
        reqParsers.put(Requests.TableTypesRequest.class.getName(), new RequestTranslator(Requests.TableTypesRequest.parser(), new Service.TableTypesRequest()));
        reqParsers.put(Requests.TypeInfoRequest.class.getName(), new RequestTranslator(Requests.TypeInfoRequest.parser(), new Service.TypeInfoRequest()));
        reqParsers.put(Requests.ExecuteRequest.class.getName(), new RequestTranslator(Requests.ExecuteRequest.parser(), new Service.ExecuteRequest()));
        reqParsers.put(Requests.SyncResultsRequest.class.getName(), new RequestTranslator(Requests.SyncResultsRequest.parser(), new Service.SyncResultsRequest()));
        reqParsers.put(Requests.CommitRequest.class.getName(), new RequestTranslator(Requests.CommitRequest.parser(), new Service.CommitRequest()));
        reqParsers.put(Requests.RollbackRequest.class.getName(), new RequestTranslator(Requests.RollbackRequest.parser(), new Service.RollbackRequest()));
        reqParsers.put(Requests.PrepareAndExecuteBatchRequest.class.getName(), new RequestTranslator(Requests.PrepareAndExecuteBatchRequest.parser(), new Service.PrepareAndExecuteBatchRequest()));
        reqParsers.put(Requests.ExecuteBatchRequest.class.getName(), new RequestTranslator(Requests.ExecuteBatchRequest.parser(), new Service.ExecuteBatchRequest()));
        REQUEST_PARSERS = Collections.unmodifiableMap(reqParsers);
        ConcurrentHashMap<String, ResponseTranslator> respParsers = new ConcurrentHashMap<String, ResponseTranslator>();
        respParsers.put(Responses.OpenConnectionResponse.class.getName(), new ResponseTranslator(Responses.OpenConnectionResponse.parser(), new Service.OpenConnectionResponse()));
        respParsers.put(Responses.CloseConnectionResponse.class.getName(), new ResponseTranslator(Responses.CloseConnectionResponse.parser(), new Service.CloseConnectionResponse()));
        respParsers.put(Responses.CloseStatementResponse.class.getName(), new ResponseTranslator(Responses.CloseStatementResponse.parser(), new Service.CloseStatementResponse()));
        respParsers.put(Responses.ConnectionSyncResponse.class.getName(), new ResponseTranslator(Responses.ConnectionSyncResponse.parser(), new Service.ConnectionSyncResponse()));
        respParsers.put(Responses.CreateStatementResponse.class.getName(), new ResponseTranslator(Responses.CreateStatementResponse.parser(), new Service.CreateStatementResponse()));
        respParsers.put(Responses.DatabasePropertyResponse.class.getName(), new ResponseTranslator(Responses.DatabasePropertyResponse.parser(), new Service.DatabasePropertyResponse()));
        respParsers.put(Responses.ExecuteResponse.class.getName(), new ResponseTranslator(Responses.ExecuteResponse.parser(), new Service.ExecuteResponse()));
        respParsers.put(Responses.FetchResponse.class.getName(), new ResponseTranslator(Responses.FetchResponse.parser(), new Service.FetchResponse()));
        respParsers.put(Responses.PrepareResponse.class.getName(), new ResponseTranslator(Responses.PrepareResponse.parser(), new Service.PrepareResponse()));
        respParsers.put(Responses.ResultSetResponse.class.getName(), new ResponseTranslator(Responses.ResultSetResponse.parser(), new Service.ResultSetResponse()));
        respParsers.put(Responses.ErrorResponse.class.getName(), new ResponseTranslator(Responses.ErrorResponse.parser(), new Service.ErrorResponse()));
        respParsers.put(Responses.SyncResultsResponse.class.getName(), new ResponseTranslator(Responses.SyncResultsResponse.parser(), new Service.SyncResultsResponse()));
        respParsers.put(Responses.RpcMetadata.class.getName(), new ResponseTranslator(Responses.RpcMetadata.parser(), new Service.RpcMetadataResponse()));
        respParsers.put(Responses.CommitResponse.class.getName(), new ResponseTranslator(Responses.CommitResponse.parser(), new Service.CommitResponse()));
        respParsers.put(Responses.RollbackResponse.class.getName(), new ResponseTranslator(Responses.RollbackResponse.parser(), new Service.RollbackResponse()));
        respParsers.put(Responses.ExecuteBatchResponse.class.getName(), new ResponseTranslator(Responses.ExecuteBatchResponse.parser(), new Service.ExecuteBatchResponse()));
        RESPONSE_PARSERS = Collections.unmodifiableMap(respParsers);
        ConcurrentHashMap messageClassNames = new ConcurrentHashMap();
        for (Class<?> msgClz : ProtobufTranslationImpl.getAllMessageClasses()) {
            messageClassNames.put(msgClz, ProtobufTranslationImpl.wrapClassName(msgClz));
        }
        MESSAGE_CLASSES = Collections.unmodifiableMap(messageClassNames);
    }

    static class ResponseTranslator {
        private final Parser<? extends Message> parser;
        private final Service.Response impl;

        ResponseTranslator(Parser<? extends Message> parser, Service.Response impl) {
            this.parser = parser;
            this.impl = impl;
        }

        public Service.Response transform(ByteString serializedMessage) throws InvalidProtocolBufferException {
            Message msg = (Message)this.parser.parseFrom(serializedMessage);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Deserialized {} '{}'", (Object)msg.getClass().getSimpleName(), (Object)TextFormat.shortDebugString((MessageOrBuilder)msg));
            }
            return this.impl.deserialize(msg);
        }
    }

    static class RequestTranslator {
        private final Parser<? extends Message> parser;
        private final Service.Request impl;

        RequestTranslator(Parser<? extends Message> parser, Service.Request impl) {
            this.parser = parser;
            this.impl = impl;
        }

        public Service.Request transform(ByteString serializedMessage) throws InvalidProtocolBufferException {
            Message msg = (Message)this.parser.parseFrom(serializedMessage.newCodedInput());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Deserialized {} '{}'", (Object)msg.getClass().getSimpleName(), (Object)TextFormat.shortDebugString((MessageOrBuilder)msg));
            }
            return this.impl.deserialize(msg);
        }
    }
}

