/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;

@Internal
public final class ExecNodeConfig
implements ReadableConfig {
    private final ReadableConfig tableConfig;
    private final ReadableConfig nodeConfig;
    private final boolean isCompiled;

    private ExecNodeConfig(ReadableConfig tableConfig, ReadableConfig nodeConfig, boolean isCompiled) {
        this.nodeConfig = nodeConfig;
        this.tableConfig = tableConfig;
        this.isCompiled = isCompiled;
    }

    static ExecNodeConfig of(TableConfig tableConfig, ReadableConfig nodeConfig, boolean isCompiled) {
        return new ExecNodeConfig((ReadableConfig)tableConfig, nodeConfig, isCompiled);
    }

    public static ExecNodeConfig ofNodeConfig(ReadableConfig nodeConfig, boolean isCompiled) {
        return new ExecNodeConfig((ReadableConfig)new Configuration(), nodeConfig, isCompiled);
    }

    @VisibleForTesting
    public static ExecNodeConfig ofTableConfig(TableConfig tableConfig, boolean isCompiled) {
        return new ExecNodeConfig((ReadableConfig)tableConfig, (ReadableConfig)TableConfig.getDefault(), isCompiled);
    }

    public <T> T get(ConfigOption<T> option) {
        return (T)this.nodeConfig.getOptional(option).orElseGet(() -> this.tableConfig.get(option));
    }

    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional tableValue = this.nodeConfig.getOptional(option);
        if (tableValue.isPresent()) {
            return tableValue;
        }
        return this.tableConfig.getOptional(option);
    }

    @Internal
    public Map<String, String> toMap() {
        Map nodeConfigMap = this.nodeConfig.toMap();
        Map tableConfigMap = this.tableConfig.toMap();
        tableConfigMap.putAll(nodeConfigMap);
        return tableConfigMap;
    }

    public long getStateRetentionTime() {
        return ((Duration)this.get(ExecutionConfigOptions.IDLE_STATE_RETENTION)).toMillis();
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public boolean shouldSetUid() {
        ExecutionConfigOptions.UidGeneration uidGeneration = (ExecutionConfigOptions.UidGeneration)this.get(ExecutionConfigOptions.TABLE_EXEC_UID_GENERATION);
        switch (uidGeneration) {
            case PLAN_ONLY: {
                return this.isCompiled;
            }
            case ALWAYS: {
                return true;
            }
            case DISABLED: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown UID generation strategy: " + uidGeneration);
    }
}

