/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.hybrid;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.connector.base.source.hybrid.HybridSourceEnumeratorState;
import org.apache.flink.core.io.SimpleVersionedSerializer;

public class HybridSourceEnumeratorStateSerializer
implements SimpleVersionedSerializer<HybridSourceEnumeratorState> {
    private static final int CURRENT_VERSION = 0;

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(HybridSourceEnumeratorState enumState) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeInt(enumState.getCurrentSourceIndex());
                out.writeInt(enumState.getWrappedStateSerializerVersion());
                out.writeInt(enumState.getWrappedState().length);
                out.write(enumState.getWrappedState());
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public HybridSourceEnumeratorState deserialize(int version, byte[] serialized) throws IOException {
        if (version == 0) {
            return this.deserializeV0(serialized);
        }
        throw new IOException(String.format("The bytes are serialized with version %d, while this deserializer only supports version up to %d", version, 0));
    }

    private HybridSourceEnumeratorState deserializeV0(byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            HybridSourceEnumeratorState hybridSourceEnumeratorState;
            try (DataInputStream in = new DataInputStream(bais);){
                int sourceIndex = in.readInt();
                int nestedVersion = in.readInt();
                int length = in.readInt();
                byte[] nestedBytes = new byte[length];
                in.readFully(nestedBytes);
                hybridSourceEnumeratorState = new HybridSourceEnumeratorState(sourceIndex, nestedBytes, nestedVersion);
            }
            return hybridSourceEnumeratorState;
        }
    }
}

