/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.file.tfile.Utils;

final class Chunk {
    private Chunk() {
    }

    public static class SingleChunkEncoder
    extends OutputStream {
        private final DataOutputStream out;
        private int remain;
        private boolean closed = false;

        public SingleChunkEncoder(DataOutputStream out, int size) throws IOException {
            this.out = out;
            this.remain = size;
            Utils.writeVInt(out, size);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.remain > 0) {
                this.out.write(b);
                --this.remain;
            } else {
                throw new IOException("Writing more bytes than advertised size.");
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.remain >= len) {
                this.out.write(b, off, len);
                this.remain -= len;
            } else {
                throw new IOException("Writing more bytes than advertised size.");
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                if (this.remain > 0) {
                    throw new IOException("Writing less bytes than advertised size.");
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    public static class ChunkEncoder
    extends OutputStream {
        private DataOutputStream out;
        private byte[] buf;
        private int count;

        public ChunkEncoder(DataOutputStream out, byte[] buf) {
            this.out = out;
            this.buf = buf;
            this.count = 0;
        }

        private void writeChunk(byte[] chunk, int offset, int len, boolean last) throws IOException {
            if (last) {
                Utils.writeVInt(this.out, len);
                if (len > 0) {
                    this.out.write(chunk, offset, len);
                }
            } else if (len > 0) {
                Utils.writeVInt(this.out, -len);
                this.out.write(chunk, offset, len);
            }
        }

        private void writeBufData(byte[] data, int offset, int len) throws IOException {
            if (this.count + len > 0) {
                Utils.writeVInt(this.out, -(this.count + len));
                this.out.write(this.buf, 0, this.count);
                this.count = 0;
                this.out.write(data, offset, len);
            }
        }

        private void flushBuffer() throws IOException {
            if (this.count > 0) {
                this.writeChunk(this.buf, 0, this.count, false);
                this.count = 0;
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count >= this.buf.length) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)b;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len + this.count >= this.buf.length) {
                this.writeBufData(b, off, len);
                return;
            }
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer();
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.buf != null) {
                try {
                    this.writeChunk(this.buf, 0, this.count, true);
                }
                finally {
                    this.buf = null;
                    this.out = null;
                }
            }
        }
    }

    public static class ChunkDecoder
    extends InputStream {
        private DataInputStream in = null;
        private boolean lastChunk;
        private int remain = 0;
        private boolean closed;

        public ChunkDecoder() {
            this.lastChunk = true;
            this.closed = true;
        }

        public void reset(DataInputStream downStream) {
            this.in = downStream;
            this.lastChunk = false;
            this.remain = 0;
            this.closed = false;
        }

        public ChunkDecoder(DataInputStream in) {
            this.in = in;
            this.lastChunk = false;
            this.closed = false;
        }

        public boolean isLastChunk() throws IOException {
            this.checkEOF();
            return this.lastChunk;
        }

        public int getRemain() throws IOException {
            this.checkEOF();
            return this.remain;
        }

        private void readLength() throws IOException {
            this.remain = Utils.readVInt(this.in);
            if (this.remain >= 0) {
                this.lastChunk = true;
            } else {
                this.remain = -this.remain;
            }
        }

        private boolean checkEOF() throws IOException {
            if (this.isClosed()) {
                return true;
            }
            while (this.remain <= 0) {
                if (this.lastChunk) {
                    return true;
                }
                this.readLength();
            }
            return false;
        }

        @Override
        public int available() {
            return this.remain;
        }

        @Override
        public int read() throws IOException {
            if (this.checkEOF()) {
                return -1;
            }
            int ret = this.in.read();
            if (ret < 0) {
                throw new IOException("Corrupted chunk encoding stream");
            }
            --this.remain;
            return ret;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if ((off | len | off + len | b.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (!this.checkEOF()) {
                int n = Math.min(this.remain, len);
                int ret = this.in.read(b, off, n);
                if (ret < 0) {
                    throw new IOException("Corrupted chunk encoding stream");
                }
                this.remain -= ret;
                return ret;
            }
            return -1;
        }

        @Override
        public long skip(long n) throws IOException {
            if (!this.checkEOF()) {
                long ret = this.in.skip(Math.min((long)this.remain, n));
                this.remain = (int)((long)this.remain - ret);
                return ret;
            }
            return 0L;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                try {
                    while (!this.checkEOF()) {
                        this.skip(Integer.MAX_VALUE);
                    }
                }
                finally {
                    this.closed = true;
                }
            }
        }
    }
}

