/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractDTService;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenIOException;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.auth.delegation.S3ADelegationTokens;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DurationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDelegationTokenBinding
extends AbstractDTService {
    private final Text kind;
    private SecretManager<AbstractS3ATokenIdentifier> secretManager;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDelegationTokenBinding.class);

    protected AbstractDelegationTokenBinding(String name, Text kind) {
        super(name);
        this.kind = Objects.requireNonNull(kind);
    }

    public Text getKind() {
        return this.kind;
    }

    public Text getOwnerText() {
        return new Text(this.getOwner().getUserName());
    }

    public S3ADelegationTokens.TokenIssuingPolicy getTokenIssuingPolicy() {
        return S3ADelegationTokens.TokenIssuingPolicy.RequestNewToken;
    }

    public Token<AbstractS3ATokenIdentifier> createDelegationToken(Optional<RoleModel.Policy> policy, EncryptionSecrets encryptionSecrets, Text renewer) throws IOException {
        this.requireServiceStarted();
        AbstractS3ATokenIdentifier tokenIdentifier = this.createTokenIdentifier(policy, encryptionSecrets, renewer);
        if (tokenIdentifier != null) {
            Token<AbstractS3ATokenIdentifier> token = new Token<AbstractS3ATokenIdentifier>(tokenIdentifier, this.secretManager);
            token.setKind(this.getKind());
            LOG.debug("Created token {} with token identifier {}", token, (Object)tokenIdentifier);
            return token;
        }
        return null;
    }

    public abstract AbstractS3ATokenIdentifier createTokenIdentifier(Optional<RoleModel.Policy> var1, EncryptionSecrets var2, Text var3) throws IOException;

    protected <T extends AbstractS3ATokenIdentifier> T convertTokenIdentifier(AbstractS3ATokenIdentifier identifier, Class<T> expectedClass) throws DelegationTokenIOException {
        if (!identifier.getClass().equals(expectedClass)) {
            throw new DelegationTokenIOException("Delegation token is wrong class; expected a token identifier of type " + expectedClass + " but got " + identifier.getClass() + " and kind " + identifier.getKind());
        }
        return (T)identifier;
    }

    public abstract AWSCredentialProviderList deployUnbonded() throws IOException;

    public abstract AWSCredentialProviderList bindToTokenIdentifier(AbstractS3ATokenIdentifier var1) throws IOException;

    public abstract AbstractS3ATokenIdentifier createEmptyIdentifier();

    @Override
    public String toString() {
        return super.toString() + " token kind = " + this.getKind();
    }

    @Override
    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.secretManager = this.createSecretMananger();
    }

    public String getDescription() {
        return "Token binding " + this.getKind().toString();
    }

    protected SecretManager<AbstractS3ATokenIdentifier> createSecretMananger() throws IOException {
        return new TokenSecretManager();
    }

    public String getUserAgentField() {
        return "";
    }

    protected static byte[] getSecretManagerPasssword() {
        return "non-password".getBytes(Charset.forName("UTF-8"));
    }

    protected class TokenSecretManager
    extends SecretManager<AbstractS3ATokenIdentifier> {
        protected TokenSecretManager() {
        }

        @Override
        protected byte[] createPassword(AbstractS3ATokenIdentifier identifier) {
            return AbstractDelegationTokenBinding.getSecretManagerPasssword();
        }

        @Override
        public byte[] retrievePassword(AbstractS3ATokenIdentifier identifier) throws SecretManager.InvalidToken {
            return AbstractDelegationTokenBinding.getSecretManagerPasssword();
        }

        @Override
        public AbstractS3ATokenIdentifier createIdentifier() {
            try (DurationInfo ignored = new DurationInfo(LOG, true, "Creating Delegation Token Identifier", new Object[0]);){
                AbstractS3ATokenIdentifier abstractS3ATokenIdentifier = AbstractDelegationTokenBinding.this.createEmptyIdentifier();
                return abstractS3ATokenIdentifier;
            }
        }
    }
}

