/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlTypeName
extends Enum<SqlTypeName> {
    public static final /* enum */ SqlTypeName BOOLEAN = new SqlTypeName(1, false, 16, SqlTypeFamily.BOOLEAN);
    public static final /* enum */ SqlTypeName TINYINT = new SqlTypeName(1, false, -6, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName SMALLINT = new SqlTypeName(1, false, 5, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName INTEGER = new SqlTypeName(1, false, 4, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName BIGINT = new SqlTypeName(1, false, -5, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName DECIMAL = new SqlTypeName(7, false, 3, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName FLOAT = new SqlTypeName(1, false, 6, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName REAL = new SqlTypeName(1, false, 7, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName DOUBLE = new SqlTypeName(1, false, 8, SqlTypeFamily.NUMERIC);
    public static final /* enum */ SqlTypeName DATE = new SqlTypeName(1, false, 91, SqlTypeFamily.DATE);
    public static final /* enum */ SqlTypeName TIME = new SqlTypeName(3, false, 92, SqlTypeFamily.TIME);
    public static final /* enum */ SqlTypeName TIME_WITH_LOCAL_TIME_ZONE = new SqlTypeName(3, false, 1111, SqlTypeFamily.TIME);
    public static final /* enum */ SqlTypeName TIMESTAMP = new SqlTypeName(3, false, 93, SqlTypeFamily.TIMESTAMP);
    public static final /* enum */ SqlTypeName TIMESTAMP_WITH_LOCAL_TIME_ZONE = new SqlTypeName(3, false, 93, SqlTypeFamily.TIMESTAMP);
    public static final /* enum */ SqlTypeName INTERVAL_YEAR = new SqlTypeName(1, false, 1111, SqlTypeFamily.INTERVAL_YEAR_MONTH);
    public static final /* enum */ SqlTypeName INTERVAL_YEAR_MONTH = new SqlTypeName(1, false, 1111, SqlTypeFamily.INTERVAL_YEAR_MONTH);
    public static final /* enum */ SqlTypeName INTERVAL_MONTH = new SqlTypeName(1, false, 1111, SqlTypeFamily.INTERVAL_YEAR_MONTH);
    public static final /* enum */ SqlTypeName INTERVAL_DAY = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_DAY_HOUR = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_DAY_MINUTE = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_DAY_SECOND = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_HOUR = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_HOUR_MINUTE = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_HOUR_SECOND = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_MINUTE = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_MINUTE_SECOND = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName INTERVAL_SECOND = new SqlTypeName(7, false, 1111, SqlTypeFamily.INTERVAL_DAY_TIME);
    public static final /* enum */ SqlTypeName CHAR = new SqlTypeName(3, false, 1, SqlTypeFamily.CHARACTER);
    public static final /* enum */ SqlTypeName VARCHAR = new SqlTypeName(3, false, 12, SqlTypeFamily.CHARACTER);
    public static final /* enum */ SqlTypeName BINARY = new SqlTypeName(3, false, -2, SqlTypeFamily.BINARY);
    public static final /* enum */ SqlTypeName VARBINARY = new SqlTypeName(3, false, -3, SqlTypeFamily.BINARY);
    public static final /* enum */ SqlTypeName NULL = new SqlTypeName(1, true, 0, SqlTypeFamily.NULL);
    public static final /* enum */ SqlTypeName UNKNOWN = new SqlTypeName(1, true, 0, SqlTypeFamily.NULL);
    public static final /* enum */ SqlTypeName ANY = new SqlTypeName(7, true, 2000, SqlTypeFamily.ANY);
    public static final /* enum */ SqlTypeName SYMBOL = new SqlTypeName(1, true, 1111, null);
    public static final /* enum */ SqlTypeName MULTISET = new SqlTypeName(1, false, 2003, SqlTypeFamily.MULTISET);
    public static final /* enum */ SqlTypeName ARRAY = new SqlTypeName(1, false, 2003, SqlTypeFamily.ARRAY);
    public static final /* enum */ SqlTypeName MAP = new SqlTypeName(1, false, 1111, SqlTypeFamily.MAP);
    public static final /* enum */ SqlTypeName DISTINCT = new SqlTypeName(1, false, 2001, null);
    public static final /* enum */ SqlTypeName STRUCTURED = new SqlTypeName(1, false, 2002, null);
    public static final /* enum */ SqlTypeName ROW = new SqlTypeName(1, false, 2002, null);
    public static final /* enum */ SqlTypeName OTHER = new SqlTypeName(1, false, 1111, null);
    public static final /* enum */ SqlTypeName CURSOR = new SqlTypeName(1, false, 2012, SqlTypeFamily.CURSOR);
    public static final /* enum */ SqlTypeName COLUMN_LIST = new SqlTypeName(1, false, 1113, SqlTypeFamily.COLUMN_LIST);
    public static final /* enum */ SqlTypeName DYNAMIC_STAR = new SqlTypeName(7, true, 2000, SqlTypeFamily.ANY);
    public static final /* enum */ SqlTypeName GEOMETRY = new SqlTypeName(1, false, 2015, SqlTypeFamily.GEO);
    public static final /* enum */ SqlTypeName MEASURE = new SqlTypeName(1, true, 1111, SqlTypeFamily.ANY);
    public static final /* enum */ SqlTypeName SARG = new SqlTypeName(1, true, 1111, SqlTypeFamily.ANY);
    public static final /* enum */ SqlTypeName VARIANT = new SqlTypeName(1, false, 1111, SqlTypeFamily.VARIANT);
    public static final int MAX_DATETIME_PRECISION = 3;
    public static final int DEFAULT_INTERVAL_START_PRECISION = 2;
    public static final int DEFAULT_INTERVAL_FRACTIONAL_SECOND_PRECISION = 6;
    public static final int MIN_INTERVAL_START_PRECISION = 1;
    public static final int MIN_INTERVAL_FRACTIONAL_SECOND_PRECISION = 1;
    public static final int MAX_INTERVAL_START_PRECISION = 10;
    public static final int MAX_INTERVAL_FRACTIONAL_SECOND_PRECISION = 9;
    private static final Map<String, SqlTypeName> VALUES_MAP;
    public static final List<SqlTypeName> ALL_TYPES;
    public static final List<SqlTypeName> BOOLEAN_TYPES;
    public static final List<SqlTypeName> BINARY_TYPES;
    public static final List<SqlTypeName> INT_TYPES;
    public static final List<SqlTypeName> EXACT_TYPES;
    public static final List<SqlTypeName> APPROX_TYPES;
    public static final List<SqlTypeName> NUMERIC_TYPES;
    public static final List<SqlTypeName> FRACTIONAL_TYPES;
    public static final List<SqlTypeName> CHAR_TYPES;
    public static final List<SqlTypeName> STRING_TYPES;
    public static final List<SqlTypeName> GEOMETRY_TYPES;
    public static final List<SqlTypeName> DATETIME_TYPES;
    public static final Set<SqlTypeName> YEAR_INTERVAL_TYPES;
    public static final Set<SqlTypeName> DAY_INTERVAL_TYPES;
    public static final Set<SqlTypeName> INTERVAL_TYPES;
    public static final Set<SqlTypeName> TIME_FRAME_TYPES;
    private static final Map<Integer, SqlTypeName> JDBC_TYPE_TO_NAME;
    private final int signatures;
    private final boolean special;
    private final int jdbcOrdinal;
    private final @Nullable SqlTypeFamily family;
    private static final /* synthetic */ SqlTypeName[] $VALUES;

    public static SqlTypeName[] values() {
        return (SqlTypeName[])$VALUES.clone();
    }

    public static SqlTypeName valueOf(String name) {
        return Enum.valueOf(SqlTypeName.class, name);
    }

    private SqlTypeName(int signatures, @Nullable boolean special, int jdbcType, SqlTypeFamily family) {
        this.signatures = signatures;
        this.special = special;
        this.jdbcOrdinal = jdbcType;
        this.family = family;
    }

    public static @Nullable SqlTypeName get(String name) {
        return VALUES_MAP.get(name);
    }

    public static SqlTypeName lookup(String tag) {
        String tag2 = tag.replace(' ', '_');
        return SqlTypeName.valueOf(tag2);
    }

    public boolean allowsNoPrecNoScale() {
        return (this.signatures & 1) != 0;
    }

    public boolean allowsPrecNoScale() {
        return (this.signatures & 2) != 0;
    }

    public boolean allowsPrec() {
        return this.allowsPrecScale(true, true) || this.allowsPrecScale(true, false);
    }

    public boolean allowsScale() {
        return this.allowsPrecScale(true, true);
    }

    public boolean allowsPrecScale(boolean precision, boolean scale) {
        int mask = precision ? (scale ? 4 : 2) : (scale ? 0 : 1);
        return (this.signatures & mask) != 0;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public int getJdbcOrdinal() {
        return this.jdbcOrdinal;
    }

    private static List<SqlTypeName> combine(List<SqlTypeName> list0, List<SqlTypeName> list1) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(list0)).addAll(list1)).build();
    }

    public int getDefaultScale() {
        switch (this) {
            case DECIMAL: {
                return 0;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 6;
            }
        }
        return -1;
    }

    public @Nullable SqlTypeFamily getFamily() {
        return this.family;
    }

    public static @Nullable SqlTypeName getNameForJdbcType(int jdbcType) {
        return JDBC_TYPE_TO_NAME.get(jdbcType);
    }

    public @Nullable Object getLimit(boolean sign, Limit limit, boolean beyond, int precision, int scale) {
        assert (this.allowsPrecScale(precision != -1, scale != -1)) : this;
        if (limit == Limit.ZERO) {
            if (beyond) {
                return null;
            }
            sign = true;
        }
        switch (this) {
            case BOOLEAN: {
                switch (limit) {
                    case ZERO: {
                        return false;
                    }
                    case UNDERFLOW: {
                        return null;
                    }
                    case OVERFLOW: {
                        if (beyond || !sign) {
                            return null;
                        }
                        return true;
                    }
                }
                throw Util.unexpected(limit);
            }
            case TINYINT: {
                return SqlTypeName.getNumericLimit(2, 8, sign, limit, beyond);
            }
            case SMALLINT: {
                return SqlTypeName.getNumericLimit(2, 16, sign, limit, beyond);
            }
            case INTEGER: {
                return SqlTypeName.getNumericLimit(2, 32, sign, limit, beyond);
            }
            case BIGINT: {
                return SqlTypeName.getNumericLimit(2, 64, sign, limit, beyond);
            }
            case DECIMAL: {
                BigDecimal decimal = SqlTypeName.getNumericLimit(10, precision, sign, limit, beyond);
                if (decimal == null) {
                    return null;
                }
                switch (limit) {
                    case OVERFLOW: {
                        BigDecimal other = (BigDecimal)BIGINT.getLimit(sign, limit, beyond, -1, -1);
                        if (other == null || decimal.compareTo(other) != (sign ? 1 : -1)) break;
                        decimal = other;
                        break;
                    }
                }
                if (scale != 0) {
                    decimal = scale > 0 ? decimal.divide(BigDecimal.TEN.pow(scale)) : decimal.multiply(BigDecimal.TEN.pow(-scale));
                }
                return decimal;
            }
            case CHAR: 
            case VARCHAR: {
                if (!sign) {
                    return null;
                }
                StringBuilder buf = new StringBuilder();
                switch (limit) {
                    case ZERO: {
                        break;
                    }
                    case UNDERFLOW: {
                        if (beyond) {
                            return null;
                        }
                        buf.append("a");
                        break;
                    }
                    case OVERFLOW: {
                        for (int i = 0; i < precision; ++i) {
                            buf.append("Z");
                        }
                        if (!beyond) break;
                        buf.append("Z");
                        break;
                    }
                }
                return buf.toString();
            }
            case BINARY: 
            case VARBINARY: {
                byte[] bytes;
                if (!sign) {
                    return null;
                }
                switch (limit) {
                    case ZERO: {
                        bytes = new byte[]{};
                        break;
                    }
                    case UNDERFLOW: {
                        if (beyond) {
                            return null;
                        }
                        bytes = new byte[]{0};
                        break;
                    }
                    case OVERFLOW: {
                        bytes = new byte[precision + (beyond ? 1 : 0)];
                        Arrays.fill(bytes, (byte)-1);
                        break;
                    }
                    default: {
                        throw Util.unexpected(limit);
                    }
                }
                return bytes;
            }
            case DATE: {
                Calendar calendar = Util.calendar();
                switch (limit) {
                    case ZERO: {
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                        break;
                    }
                    case UNDERFLOW: {
                        return null;
                    }
                    case OVERFLOW: {
                        if (beyond) {
                            return null;
                        }
                        if (sign) {
                            calendar.set(1, 9999);
                            calendar.set(2, 11);
                            calendar.set(5, 31);
                            break;
                        }
                        calendar.set(1, 1);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                        break;
                    }
                }
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                return calendar;
            }
            case TIME: {
                if (!sign) {
                    return null;
                }
                if (beyond) {
                    return null;
                }
                Calendar calendar = Util.calendar();
                switch (limit) {
                    case ZERO: {
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        break;
                    }
                    case UNDERFLOW: {
                        return null;
                    }
                    case OVERFLOW: {
                        calendar.set(11, 23);
                        calendar.set(12, 59);
                        calendar.set(13, 59);
                        int millis = precision >= 3 ? 999 : (precision == 2 ? 990 : (precision == 1 ? 900 : 0));
                        calendar.set(14, millis);
                        break;
                    }
                }
                return calendar;
            }
            case TIMESTAMP: {
                Calendar calendar = Util.calendar();
                switch (limit) {
                    case ZERO: {
                        calendar.set(1, 1970);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        break;
                    }
                    case UNDERFLOW: {
                        return null;
                    }
                    case OVERFLOW: {
                        if (beyond) {
                            return null;
                        }
                        if (sign) {
                            calendar.set(1, 9999);
                            calendar.set(2, 11);
                            calendar.set(5, 31);
                            calendar.set(11, 23);
                            calendar.set(12, 59);
                            calendar.set(13, 59);
                            int millis = precision >= 3 ? 999 : (precision == 2 ? 990 : (precision == 1 ? 900 : 0));
                            calendar.set(14, millis);
                            break;
                        }
                        calendar.set(1, 1);
                        calendar.set(2, 0);
                        calendar.set(5, 1);
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 0);
                        break;
                    }
                }
                return calendar;
            }
        }
        throw Util.unexpected(this);
    }

    public int getMinPrecision() {
        switch (this) {
            case DECIMAL: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: 
            case TIME: 
            case TIMESTAMP: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 1;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 1;
            }
        }
        return -1;
    }

    public int getMinScale() {
        switch (this) {
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return 1;
            }
        }
        return -1;
    }

    public TimeUnit getStartUnit() {
        switch (this) {
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: {
                return TimeUnit.YEAR;
            }
            case INTERVAL_MONTH: {
                return TimeUnit.MONTH;
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: {
                return TimeUnit.DAY;
            }
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: {
                return TimeUnit.HOUR;
            }
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: {
                return TimeUnit.MINUTE;
            }
            case INTERVAL_SECOND: {
                return TimeUnit.SECOND;
            }
        }
        throw new AssertionError((Object)this);
    }

    public TimeUnit getEndUnit() {
        switch (this) {
            case INTERVAL_YEAR: {
                return TimeUnit.YEAR;
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return TimeUnit.MONTH;
            }
            case INTERVAL_DAY: {
                return TimeUnit.DAY;
            }
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_HOUR: {
                return TimeUnit.HOUR;
            }
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_MINUTE: {
                return TimeUnit.MINUTE;
            }
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return TimeUnit.SECOND;
            }
        }
        throw new AssertionError((Object)this);
    }

    public boolean isYearMonth() {
        switch (this) {
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                return true;
            }
        }
        return false;
    }

    private static @Nullable BigDecimal getNumericLimit(int radix, int exponent, boolean sign, Limit limit, boolean beyond) {
        switch (limit) {
            case OVERFLOW: {
                BigDecimal bigRadix = BigDecimal.valueOf(radix);
                if (radix == 2) {
                    --exponent;
                }
                BigDecimal decimal = bigRadix.pow(exponent);
                if (sign || radix != 2) {
                    decimal = decimal.subtract(BigDecimal.ONE);
                }
                if (beyond) {
                    decimal = decimal.add(BigDecimal.ONE);
                }
                if (!sign) {
                    decimal = decimal.negate();
                }
                return decimal;
            }
            case UNDERFLOW: {
                return beyond ? null : (sign ? BigDecimal.ONE : BigDecimal.ONE.negate());
            }
            case ZERO: {
                return BigDecimal.ZERO;
            }
        }
        throw Util.unexpected(limit);
    }

    public SqlLiteral createLiteral(Object o, SqlParserPos pos) {
        switch (this) {
            case BOOLEAN: {
                return SqlLiteral.createBoolean((Boolean)o, pos);
            }
            case DECIMAL: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return SqlLiteral.createExactNumeric(o.toString(), pos);
            }
            case CHAR: 
            case VARCHAR: {
                return SqlLiteral.createCharString((String)o, pos);
            }
            case BINARY: 
            case VARBINARY: {
                return SqlLiteral.createBinaryString((byte[])o, pos);
            }
            case DATE: {
                return SqlLiteral.createDate(o instanceof Calendar ? DateString.fromCalendarFields((Calendar)o) : (DateString)o, pos);
            }
            case TIME: {
                return SqlLiteral.createTime(o instanceof Calendar ? TimeString.fromCalendarFields((Calendar)o) : (TimeString)o, 0, pos);
            }
            case TIMESTAMP: {
                return SqlLiteral.createTimestamp(this, o instanceof Calendar ? TimestampString.fromCalendarFields((Calendar)o) : (TimestampString)o, 0, pos);
            }
        }
        throw Util.unexpected(this);
    }

    public String getName() {
        return this.name();
    }

    public String getSpaceName() {
        return this.name().replace('_', ' ');
    }

    static {
        $VALUES = new SqlTypeName[]{BOOLEAN, TINYINT, SMALLINT, INTEGER, BIGINT, DECIMAL, FLOAT, REAL, DOUBLE, DATE, TIME, TIME_WITH_LOCAL_TIME_ZONE, TIMESTAMP, TIMESTAMP_WITH_LOCAL_TIME_ZONE, INTERVAL_YEAR, INTERVAL_YEAR_MONTH, INTERVAL_MONTH, INTERVAL_DAY, INTERVAL_DAY_HOUR, INTERVAL_DAY_MINUTE, INTERVAL_DAY_SECOND, INTERVAL_HOUR, INTERVAL_HOUR_MINUTE, INTERVAL_HOUR_SECOND, INTERVAL_MINUTE, INTERVAL_MINUTE_SECOND, INTERVAL_SECOND, CHAR, VARCHAR, BINARY, VARBINARY, NULL, UNKNOWN, ANY, SYMBOL, MULTISET, ARRAY, MAP, DISTINCT, STRUCTURED, ROW, OTHER, CURSOR, COLUMN_LIST, DYNAMIC_STAR, GEOMETRY, MEASURE, SARG, VARIANT};
        VALUES_MAP = Util.enumConstants(SqlTypeName.class);
        ALL_TYPES = ImmutableList.of(BOOLEAN, INTEGER, VARCHAR, DATE, TIME, TIMESTAMP, NULL, DECIMAL, ANY, CHAR, BINARY, VARBINARY, new SqlTypeName[]{TINYINT, SMALLINT, BIGINT, REAL, DOUBLE, SYMBOL, INTERVAL_YEAR, INTERVAL_YEAR_MONTH, INTERVAL_MONTH, INTERVAL_DAY, INTERVAL_DAY_HOUR, INTERVAL_DAY_MINUTE, INTERVAL_DAY_SECOND, INTERVAL_HOUR, INTERVAL_HOUR_MINUTE, INTERVAL_HOUR_SECOND, INTERVAL_MINUTE, INTERVAL_MINUTE_SECOND, INTERVAL_SECOND, TIME_WITH_LOCAL_TIME_ZONE, TIMESTAMP_WITH_LOCAL_TIME_ZONE, FLOAT, MULTISET, DISTINCT, STRUCTURED, ROW, CURSOR, COLUMN_LIST, VARIANT});
        BOOLEAN_TYPES = ImmutableList.of(BOOLEAN);
        BINARY_TYPES = ImmutableList.of(BINARY, VARBINARY);
        INT_TYPES = ImmutableList.of(TINYINT, SMALLINT, INTEGER, BIGINT);
        EXACT_TYPES = SqlTypeName.combine(INT_TYPES, ImmutableList.of(DECIMAL));
        APPROX_TYPES = ImmutableList.of(FLOAT, REAL, DOUBLE);
        NUMERIC_TYPES = SqlTypeName.combine(EXACT_TYPES, APPROX_TYPES);
        FRACTIONAL_TYPES = SqlTypeName.combine(APPROX_TYPES, ImmutableList.of(DECIMAL));
        CHAR_TYPES = ImmutableList.of(CHAR, VARCHAR);
        STRING_TYPES = SqlTypeName.combine(CHAR_TYPES, BINARY_TYPES);
        GEOMETRY_TYPES = ImmutableList.of(GEOMETRY);
        DATETIME_TYPES = ImmutableList.of(DATE, TIME, TIME_WITH_LOCAL_TIME_ZONE, TIMESTAMP, TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        YEAR_INTERVAL_TYPES = Sets.immutableEnumSet((Enum)INTERVAL_YEAR, (Enum[])new SqlTypeName[]{INTERVAL_YEAR_MONTH, INTERVAL_MONTH});
        DAY_INTERVAL_TYPES = Sets.immutableEnumSet((Enum)INTERVAL_DAY, (Enum[])new SqlTypeName[]{INTERVAL_DAY_HOUR, INTERVAL_DAY_MINUTE, INTERVAL_DAY_SECOND, INTERVAL_HOUR, INTERVAL_HOUR_MINUTE, INTERVAL_HOUR_SECOND, INTERVAL_MINUTE, INTERVAL_MINUTE_SECOND, INTERVAL_SECOND});
        INTERVAL_TYPES = Sets.immutableEnumSet(Iterables.concat(YEAR_INTERVAL_TYPES, DAY_INTERVAL_TYPES));
        TIME_FRAME_TYPES = Sets.immutableEnumSet(Iterables.concat(INTERVAL_TYPES, ImmutableList.of(SYMBOL)));
        JDBC_TYPE_TO_NAME = ImmutableMap.builder().put(-6, TINYINT).put(5, SMALLINT).put(-5, BIGINT).put(4, INTEGER).put(2, DECIMAL).put(3, DECIMAL).put(6, FLOAT).put(7, REAL).put(8, DOUBLE).put(1, CHAR).put(12, VARCHAR).put(-15, CHAR).put(-9, VARCHAR).put(-2, BINARY).put(-3, VARBINARY).put(91, DATE).put(92, TIME).put(93, TIMESTAMP).put(-7, BOOLEAN).put(16, BOOLEAN).put(2001, DISTINCT).put(2002, STRUCTURED).put(2003, ARRAY).build();
    }

    private static interface PrecScale {
        public static final int NO_NO = 1;
        public static final int YES_NO = 2;
        public static final int YES_YES = 4;
    }

    public static enum Limit {
        ZERO,
        UNDERFLOW,
        OVERFLOW;

    }
}

