/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Litmus;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecWindowJoin;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalJoin;
import org.apache.flink.table.planner.plan.nodes.physical.common.CommonPhysicalJoin$;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil$;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.LogicalType;
import scala.None$;
import scala.Option;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\t\u0013\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011I\u0003!Q1A\u0005\u0002MC\u0001B\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t7\u0002\u0011)\u0019!C\u0001'\"AA\f\u0001B\u0001B\u0003%A\u000bC\u0003^\u0001\u0011\u0005a\fC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0002bBA\u001a\u0001\u0011\u0005\u0013Q\u0007\u0002\u0019'R\u0014X-Y7QQf\u001c\u0018nY1m/&tGm\\<K_&t'BA\n\u0015\u0003\u0019\u0019HO]3b[*\u0011QCF\u0001\ta\"L8/[2bY*\u0011q\u0003G\u0001\u0006]>$Wm\u001d\u0006\u00033i\tA\u0001\u001d7b]*\u00111\u0004H\u0001\ba2\fgN\\3s\u0015\tib$A\u0003uC\ndWM\u0003\u0002 A\u0005)a\r\\5oW*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0014-!\t9#&D\u0001)\u0015\tIC#\u0001\u0004d_6lwN\\\u0005\u0003W!\u0012!cQ8n[>t\u0007\u000b[=tS\u000e\fGNS8j]B\u0011QFL\u0007\u0002%%\u0011qF\u0005\u0002\u0012'R\u0014X-Y7QQf\u001c\u0018nY1m%\u0016d\u0017aB2mkN$XM\u001d\t\u0003eYj\u0011a\r\u0006\u00033QR!!\u000e\u0011\u0002\u000f\r\fGnY5uK&\u0011qg\r\u0002\u000e%\u0016dw\n\u001d;DYV\u001cH/\u001a:\u0002\u0011Q\u0014\u0018-\u001b;TKR\u0004\"A\r\u001e\n\u0005m\u001a$a\u0003*fYR\u0013\u0018-\u001b;TKR\fq\u0001\\3giJ+G\u000e\u0005\u0002?\u00036\tqH\u0003\u0002Ai\u0005\u0019!/\u001a7\n\u0005\t{$a\u0002*fY:{G-Z\u0001\te&<\u0007\u000e\u001e*fY\u0006A!n\\5o)f\u0004X\r\u0005\u0002G\u00136\tqI\u0003\u0002I\u007f\u0005!1m\u001c:f\u0013\tQuIA\u0006K_&t'+\u001a7UsB,\u0017A\u0005:f[\u0006Lg.\u001b8h\u0007>tG-\u001b;j_:\u0004\"!\u0014)\u000e\u00039S!a\u0014\u001b\u0002\u0007I,\u00070\u0003\u0002R\u001d\n9!+\u001a=O_\u0012,\u0017!\u00047fMR<\u0016N\u001c3po&tw-F\u0001U!\t)\u0006,D\u0001W\u0015\t9\u0006$A\u0004m_\u001eL7-\u00197\n\u0005e3&!E,j]\u0012|w/\u001b8h'R\u0014\u0018\r^3hs\u0006qA.\u001a4u/&tGm\\<j]\u001e\u0004\u0013A\u0004:jO\"$x+\u001b8e_^LgnZ\u0001\u0010e&<\u0007\u000e^,j]\u0012|w/\u001b8hA\u00051A(\u001b8jiz\"\u0012b\u00181bE\u000e$WMZ4\u0011\u00055\u0002\u0001\"\u0002\u0019\f\u0001\u0004\t\u0004\"\u0002\u001d\f\u0001\u0004I\u0004\"\u0002\u001f\f\u0001\u0004i\u0004\"B\"\f\u0001\u0004i\u0004\"\u0002#\f\u0001\u0004)\u0005\"B&\f\u0001\u0004a\u0005\"\u0002*\f\u0001\u0004!\u0006\"B.\f\u0001\u0004!\u0016aB5t-\u0006d\u0017\u000e\u001a\u000b\u0004UBD\bCA6o\u001b\u0005a'\"A7\u0002\u000bM\u001c\u0017\r\\1\n\u0005=d'a\u0002\"p_2,\u0017M\u001c\u0005\u0006c2\u0001\rA]\u0001\u0007Y&$X.^:\u0011\u0005M4X\"\u0001;\u000b\u0005U$\u0014\u0001B;uS2L!a\u001e;\u0003\r1KG/\\;t\u0011\u0015IH\u00021\u0001{\u0003\u001d\u0019wN\u001c;fqR\u0004\"a\u001f@\u000f\u0005yb\u0018BA?@\u0003\u001d\u0011V\r\u001c(pI\u0016L1a`A\u0001\u0005\u001d\u0019uN\u001c;fqRT!!` \u0002!I,\u0017/^5sK^\u000bG/\u001a:nCJ\\W#\u00016\u0002\t\r|\u0007/\u001f\u000b\u000f\u0003\u0017\t\t\"a\u0005\u0002\u0018\u0005m\u0011qDA\u0011!\r1\u0015QB\u0005\u0004\u0003\u001f9%\u0001\u0002&pS:DQ\u0001\u000f\bA\u0002eBa!!\u0006\u000f\u0001\u0004a\u0015!D2p]\u0012LG/[8o\u000bb\u0004(\u000f\u0003\u0004\u0002\u001a9\u0001\r!P\u0001\u0005Y\u00164G\u000f\u0003\u0004\u0002\u001e9\u0001\r!P\u0001\u0006e&<\u0007\u000e\u001e\u0005\u0006\t:\u0001\r!\u0012\u0005\u0007\u0003Gq\u0001\u0019\u00016\u0002\u0019M,W.\u001b&pS:$uN\\3\u0002\u0019\u0015D\b\u000f\\1j]R+'/\\:\u0015\t\u0005%\u0012q\u0006\t\u0004}\u0005-\u0012bAA\u0017\u007f\tI!+\u001a7Xe&$XM\u001d\u0005\b\u0003cy\u0001\u0019AA\u0015\u0003\t\u0001x/A\nue\u0006t7\u000f\\1uKR{W\t_3d\u001d>$W\r\u0006\u0002\u00028A\"\u0011\u0011HA%!\u0019\tY$!\u0011\u0002F5\u0011\u0011Q\b\u0006\u0004\u0003\u007f1\u0012\u0001B3yK\u000eLA!a\u0011\u0002>\tAQ\t_3d\u001d>$W\r\u0005\u0003\u0002H\u0005%C\u0002\u0001\u0003\f\u0003\u0017\u0002\u0012\u0011!A\u0001\u0006\u0003\tiEA\u0002`IE\nB!a\u0014\u0002VA\u00191.!\u0015\n\u0007\u0005MCNA\u0004O_RD\u0017N\\4\u0011\u0007-\f9&C\u0002\u0002Z1\u00141!\u00118z\u0001")
public class StreamPhysicalWindowJoin
extends CommonPhysicalJoin
implements StreamPhysicalRel {
    private final RelOptCluster cluster;
    private final RexNode remainingCondition;
    private final WindowingStrategy leftWindowing;
    private final WindowingStrategy rightWindowing;

    public WindowingStrategy leftWindowing() {
        return this.leftWindowing;
    }

    public WindowingStrategy rightWindowing() {
        return this.rightWindowing;
    }

    @Override
    public boolean isValid(Litmus litmus, RelNode.Context context) {
        LogicalType logicalType = this.leftWindowing().getTimeAttributeType();
        LogicalType logicalType2 = this.rightWindowing().getTimeAttributeType();
        if (logicalType == null ? logicalType2 != null : !logicalType.equals(logicalType2)) {
            return litmus.fail("Currently, window join doesn't support different time attribute type of left and right inputs.", new Object[0]);
        }
        WindowSpec windowSpec = this.leftWindowing().getWindow();
        WindowSpec windowSpec2 = this.rightWindowing().getWindow();
        if (windowSpec == null ? windowSpec2 != null : !windowSpec.equals(windowSpec2)) {
            return litmus.fail("Currently, window join doesn't support different window table function of left and right inputs.", new Object[0]);
        }
        return super.isValid(litmus, context);
    }

    @Override
    public boolean requireWatermark() {
        return this.leftWindowing().isRowtime() || this.rightWindowing().isRowtime();
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new StreamPhysicalWindowJoin(this.cluster, traitSet, left, right, joinType, this.remainingCondition, this.leftWindowing(), this.rightWindowing());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String[] leftInputFieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.left.getRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        String[] rightInputFieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.right.getRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        return pw.input("left", this.left).input("right", this.right).item("leftWindow", this.leftWindowing().toSummaryString(leftInputFieldNames)).item("rightWindow", this.rightWindowing().toSummaryString(rightInputFieldNames)).item("joinType", this.joinSpec().getJoinType()).item("where", this.getExpressionString(this.remainingCondition, (List<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.inputRowType().getFieldNames()).toList(), (Option<List<RexNode>>)None$.MODULE$, RelExplainUtil$.MODULE$.preferExpressionFormat(pw), this.convertToExpressionDetail(pw.getDetailLevel()))).item("select", JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getRowType().getFieldNames()).mkString(", "));
    }

    @Override
    public ExecNode<?> translateToExecNode() {
        return new StreamExecWindowJoin((ReadableConfig)ShortcutUtils.unwrapTableConfig(this), this.joinSpec(), this.leftWindowing(), this.rightWindowing(), InputProperty.DEFAULT, InputProperty.DEFAULT, FlinkTypeFactory$.MODULE$.toLogicalRowType(this.getRowType()), this.getRelDetailedDescription());
    }

    public StreamPhysicalWindowJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode leftRel, RelNode rightRel, JoinRelType joinType, RexNode remainingCondition, WindowingStrategy leftWindowing, WindowingStrategy rightWindowing) {
        this.cluster = cluster;
        this.remainingCondition = remainingCondition;
        this.leftWindowing = leftWindowing;
        this.rightWindowing = rightWindowing;
        super(cluster, traitSet, leftRel, rightRel, remainingCondition, joinType, CommonPhysicalJoin$.MODULE$.$lessinit$greater$default$7());
        if (this.joinSpec().getNonEquiCondition().isPresent() && PythonUtil.containsPythonCall(this.joinSpec().getNonEquiCondition().get())) {
            throw new TableException("Only inner join condition with equality predicates supports the Python UDF taking the inputs from the left table and the right table at the same time, e.g., ON T1.id = T2.id && pythonUdf(T1.a, T2.b)");
        }
        this.isValid(Litmus.THROW, null);
    }
}

