/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Snapshot;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSnapshot;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableProjectSnapshotTransposeRule;
import org.immutables.value.Value;

@Value.Enclosing
public class ProjectSnapshotTransposeRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    public ProjectSnapshotTransposeRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        return !project.containsOver();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalSnapshot snapshot = (LogicalSnapshot)call.rel(1);
        RelNode newProject = project.copy(project.getTraitSet(), snapshot.getInputs());
        Snapshot newSnapshot = snapshot.copy(snapshot.getTraitSet(), newProject, snapshot.getPeriod());
        call.transformTo(newSnapshot);
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableProjectSnapshotTransposeRule.Config.builder().build().withOperator().as(Config.class);

        @Override
        default public RelOptRule toRule() {
            return new ProjectSnapshotTransposeRule(this);
        }

        default public Config withOperator() {
            RelRule.OperandTransform snapshotTransform = operandBuilder -> operandBuilder.operand(LogicalSnapshot.class).noInputs();
            RelRule.OperandTransform projectTransform = operandBuilder -> operandBuilder.operand(LogicalProject.class).oneInput(snapshotTransform);
            return this.withOperandSupplier(projectTransform).as(Config.class);
        }
    }
}

