/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@Internal
public final class NullableIfArgsTypeStrategy
implements TypeStrategy {
    private final ConstantArgumentCount includedArguments;
    private final TypeStrategy initialStrategy;
    private final boolean nullableIfAllArgsNullable;

    public NullableIfArgsTypeStrategy(ConstantArgumentCount includedArguments, TypeStrategy initialStrategy, boolean nullableIfAllArgsNullable) {
        this.includedArguments = (ConstantArgumentCount)Preconditions.checkNotNull((Object)includedArguments);
        this.initialStrategy = (TypeStrategy)Preconditions.checkNotNull((Object)initialStrategy);
        this.nullableIfAllArgsNullable = nullableIfAllArgsNullable;
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        return this.initialStrategy.inferType(callContext).map(inferredDataType -> {
            List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
            if (argumentDataTypes.isEmpty()) {
                return (DataType)inferredDataType.notNull();
            }
            int fromArg = this.includedArguments.getMinCount().orElse(0);
            int toArg = Math.min(this.includedArguments.getMaxCount().map(c -> c + 1).orElse(argumentDataTypes.size()), argumentDataTypes.size());
            boolean isNullableArgument = this.nullableIfAllArgsNullable ? IntStream.range(fromArg, toArg).mapToObj(argumentDataTypes::get).map(DataType::getLogicalType).allMatch(LogicalType::isNullable) : IntStream.range(fromArg, toArg).mapToObj(argumentDataTypes::get).map(DataType::getLogicalType).anyMatch(LogicalType::isNullable);
            if (isNullableArgument) {
                return (DataType)inferredDataType.nullable();
            }
            return (DataType)inferredDataType.notNull();
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullableIfArgsTypeStrategy that = (NullableIfArgsTypeStrategy)o;
        return this.includedArguments.equals(that.includedArguments) && this.initialStrategy.equals(that.initialStrategy) && this.nullableIfAllArgsNullable == that.nullableIfAllArgsNullable;
    }

    public int hashCode() {
        return Objects.hash(this.includedArguments, this.initialStrategy, this.nullableIfAllArgsNullable);
    }
}

