/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.deltajoin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.CollectionSupplier;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.collector.TableFunctionResultFuture;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.generated.GeneratedResultFuture;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDeltaJoinRunner
extends RichAsyncFunction<RowData, RowData> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncDeltaJoinRunner.class);
    private static final long serialVersionUID = 1L;
    private static final String METRIC_DELTA_JOIN_LEFT_CALL_ASYNC_FETCH_COST_TIME = "deltaJoinLeftCallAsyncFetchCostTime";
    private static final String METRIC_DELTA_JOIN_RIGHT_CALL_ASYNC_FETCH_COST_TIME = "deltaJoinRightCallAsyncFetchCostTime";
    private final GeneratedFunction<AsyncFunction<RowData, Object>> generatedFetcher;
    private final DataStructureConverter<RowData, Object> fetcherConverter;
    private final GeneratedResultFuture<TableFunctionResultFuture<RowData>> generatedResultFuture;
    private final int asyncBufferCapacity;
    private transient AsyncFunction<RowData, Object> fetcher;
    protected final RowDataSerializer lookupSideRowSerializer;
    private final boolean treatRightAsLookupTable;
    private transient BlockingQueue<JoinedRowResultFuture> resultFutureBuffer;
    private transient List<JoinedRowResultFuture> allResultFutures;
    private transient long callAsyncFetchCostTime = 0L;

    public AsyncDeltaJoinRunner(GeneratedFunction<AsyncFunction<RowData, Object>> generatedFetcher, DataStructureConverter<RowData, Object> fetcherConverter, GeneratedResultFuture<TableFunctionResultFuture<RowData>> generatedResultFuture, RowDataSerializer lookupSideRowSerializer, int asyncBufferCapacity, boolean treatRightAsLookupTable) {
        this.generatedFetcher = generatedFetcher;
        this.fetcherConverter = fetcherConverter;
        this.generatedResultFuture = generatedResultFuture;
        this.lookupSideRowSerializer = lookupSideRowSerializer;
        this.asyncBufferCapacity = asyncBufferCapacity;
        this.treatRightAsLookupTable = treatRightAsLookupTable;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.fetcher = (AsyncFunction)this.generatedFetcher.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, (OpenContext)openContext);
        this.generatedResultFuture.compile(this.getRuntimeContext().getUserCodeClassLoader());
        this.fetcherConverter.open(this.getRuntimeContext().getUserCodeClassLoader());
        this.resultFutureBuffer = new ArrayBlockingQueue<JoinedRowResultFuture>(this.asyncBufferCapacity + 1);
        this.allResultFutures = new ArrayList<JoinedRowResultFuture>();
        LOG.info("Begin to initialize reusable result futures with size {}", (Object)(this.asyncBufferCapacity + 1));
        for (int i = 0; i < this.asyncBufferCapacity + 1; ++i) {
            JoinedRowResultFuture rf = new JoinedRowResultFuture(this.resultFutureBuffer, this.createFetcherResultFuture(openContext), this.fetcherConverter, this.treatRightAsLookupTable);
            this.resultFutureBuffer.add(rf);
            this.allResultFutures.add(rf);
        }
        LOG.info("Finish initializing reusable result futures");
        this.getRuntimeContext().getMetricGroup().gauge(this.treatRightAsLookupTable ? METRIC_DELTA_JOIN_LEFT_CALL_ASYNC_FETCH_COST_TIME : METRIC_DELTA_JOIN_RIGHT_CALL_ASYNC_FETCH_COST_TIME, () -> this.callAsyncFetchCostTime);
    }

    public void asyncInvoke(RowData input, ResultFuture<RowData> resultFuture) throws Exception {
        JoinedRowResultFuture outResultFuture = this.resultFutureBuffer.take();
        outResultFuture.reset(input, resultFuture);
        long startTime = System.currentTimeMillis();
        this.fetcher.asyncInvoke((Object)input, (ResultFuture)outResultFuture);
        this.callAsyncFetchCostTime = System.currentTimeMillis() - startTime;
    }

    public TableFunctionResultFuture<RowData> createFetcherResultFuture(OpenContext openContext) throws Exception {
        TableFunctionResultFuture resultFuture = (TableFunctionResultFuture)((Object)this.generatedResultFuture.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
        FunctionUtils.setFunctionRuntimeContext((Function)resultFuture, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction((Function)resultFuture, (OpenContext)openContext);
        return resultFuture;
    }

    public void close() throws Exception {
        super.close();
        if (this.fetcher != null) {
            FunctionUtils.closeFunction(this.fetcher);
        }
        if (this.allResultFutures != null) {
            for (JoinedRowResultFuture rf : this.allResultFutures) {
                rf.close();
            }
        }
    }

    @VisibleForTesting
    public AsyncFunction<RowData, Object> getFetcher() {
        return this.fetcher;
    }

    @VisibleForTesting
    public static final class JoinedRowResultFuture
    implements ResultFuture<Object> {
        private final BlockingQueue<JoinedRowResultFuture> resultFutureBuffer;
        private final TableFunctionResultFuture<RowData> joinConditionResultFuture;
        private final DataStructureConverter<RowData, Object> resultConverter;
        private final DelegateResultFuture delegate;
        private final boolean treatRightAsLookupTable;
        private RowData streamRow;
        private ResultFuture<RowData> realOutput;

        private JoinedRowResultFuture(BlockingQueue<JoinedRowResultFuture> resultFutureBuffer, TableFunctionResultFuture<RowData> joinConditionResultFuture, DataStructureConverter<RowData, Object> resultConverter, boolean treatRightAsLookupTable) {
            this.resultFutureBuffer = resultFutureBuffer;
            this.joinConditionResultFuture = joinConditionResultFuture;
            this.resultConverter = resultConverter;
            this.delegate = new DelegateResultFuture();
            this.treatRightAsLookupTable = treatRightAsLookupTable;
        }

        public void reset(RowData row, ResultFuture<RowData> realOutput) {
            this.realOutput = realOutput;
            this.streamRow = row;
            this.joinConditionResultFuture.setInput(row);
            this.joinConditionResultFuture.setResultFuture(this.delegate);
            this.delegate.reset();
        }

        public void complete(Collection<Object> result) {
            Collection<RowData> rowDataCollection = this.convertToInternalData(result);
            try {
                this.joinConditionResultFuture.complete(rowDataCollection);
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
                return;
            }
            Collection<RowData> lookupRows = this.delegate.collection;
            if (lookupRows == null || lookupRows.isEmpty()) {
                this.realOutput.complete(Collections.emptyList());
            } else {
                ArrayList<JoinedRowData> outRows = new ArrayList<JoinedRowData>();
                for (RowData lookupRow : lookupRows) {
                    JoinedRowData outRow = this.treatRightAsLookupTable ? new JoinedRowData(this.streamRow.getRowKind(), this.streamRow, lookupRow) : new JoinedRowData(this.streamRow.getRowKind(), lookupRow, this.streamRow);
                    outRows.add(outRow);
                }
                this.realOutput.complete(outRows);
            }
            try {
                this.resultFutureBuffer.put(this);
            }
            catch (InterruptedException e) {
                this.completeExceptionally(e);
            }
        }

        public void completeExceptionally(Throwable error) {
            this.realOutput.completeExceptionally(error);
        }

        public void complete(CollectionSupplier<Object> supplier) {
            throw new UnsupportedOperationException();
        }

        public void close() throws Exception {
            this.joinConditionResultFuture.close();
        }

        private Collection<RowData> convertToInternalData(Collection<Object> data) {
            if (this.resultConverter.isIdentityConversion()) {
                return data;
            }
            ArrayList<RowData> result = new ArrayList<RowData>(data.size());
            for (Object element : data) {
                result.add(this.resultConverter.toInternal(element));
            }
            return result;
        }

        private final class DelegateResultFuture
        implements ResultFuture<RowData> {
            private Collection<RowData> collection;

            private DelegateResultFuture() {
            }

            public void reset() {
                this.collection = null;
            }

            public void complete(Collection<RowData> result) {
                this.collection = result;
            }

            public void completeExceptionally(Throwable error) {
                JoinedRowResultFuture.this.completeExceptionally(error);
            }

            public void complete(CollectionSupplier<RowData> supplier) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

