/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.LinkedList;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.JsonQueryOnEmptyOrError;
import org.apache.flink.table.api.JsonQueryWrapper;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.typeutils.SymbolUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;

@Internal
class JsonQueryConverter
extends CustomizedConverter {
    JsonQueryConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        JsonQueryConverter.checkArgumentNumber(call, 6);
        LinkedList<RexNode> operands = new LinkedList<RexNode>();
        operands.add(context.toRexNode((Expression)call.getChildren().get(0)));
        operands.add(context.toRexNode((Expression)call.getChildren().get(1)));
        Enum wrappingBehavior = ((ValueLiteralExpression)call.getChildren().get(3)).getValueAs(JsonQueryWrapper.class).map(SymbolUtil::commonToCalcite).orElseThrow(() -> new TableException("Missing argument for wrapping behavior."));
        Enum onEmpty = ((ValueLiteralExpression)call.getChildren().get(4)).getValueAs(JsonQueryOnEmptyOrError.class).map(SymbolUtil::commonToCalcite).orElseThrow(() -> new TableException("Missing argument for ON EMPTY behavior."));
        Enum onError = ((ValueLiteralExpression)call.getChildren().get(5)).getValueAs(JsonQueryOnEmptyOrError.class).map(SymbolUtil::commonToCalcite).orElseThrow(() -> new TableException("Missing argument for ON ERROR behavior."));
        operands.add(context.getRelBuilder().getRexBuilder().makeFlag(wrappingBehavior));
        operands.add(context.getRelBuilder().getRexBuilder().makeFlag(onEmpty));
        operands.add(context.getRelBuilder().getRexBuilder().makeFlag(onError));
        FlinkTypeFactory typeFactory = ShortcutUtils.unwrapTypeFactory(context.getRelBuilder());
        RelDataType returnRelType = typeFactory.createFieldTypeFromLogicalType(call.getOutputDataType().getLogicalType());
        return context.getRelBuilder().getRexBuilder().makeCall(returnRelType, FlinkSqlOperatorTable.JSON_QUERY, operands);
    }
}

